

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetMigrateServerDetailsForDestinationClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- This SP will copy cutOverApprovers, dateAndTime, sourceServer, excludedBackupContent details
-- from migrateServerDetails XML to destinationClientId level (table App_ClientProp).
-- Currently this SP handle only create operation i.e. create NAS client with filer details
-- In next revision, will add support for edit operation too.
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetMigrateServerDetailsForDestinationClient')
BEGIN
	print '>>> Drop Stored Procedure: AppSetMigrateServerDetailsForDestinationClient <<<'
	drop procedure AppSetMigrateServerDetailsForDestinationClient
END
IF EXISTS (select * from GxQscripts where name='AppSetMigrateServerDetailsForDestinationClient')
	delete from GxQscripts where name = 'AppSetMigrateServerDetailsForDestinationClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMigrateServerDetailsForDestinationClient')
	delete from GXDBVersions where aliasname = 'AppSetMigrateServerDetailsForDestinationClient'
GO
print '... Creating Procedure: AppSetMigrateServerDetailsForDestinationClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetMigrateServerDetailsForDestinationClient
  @destinationClientId INT,
  @migrateServerDetails XML
AS
  DECLARE @errorCode INT 
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Now logic starts from here ....
SET @errorCode = 0
SET @errorString = N'Successful'
DECLARE @curUtcDateTime BIGINT = dbo.GetUnixTime(GETUTCDATE())
-- Input XML might contain only userId, and we need userName, loginName and email Id for display purposes in GET calls.
-- So extracting all details and filling it when saving in DB.
INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @destinationClientId, 'Cutover approvers', 1,
	CASE WHEN U.id IS NULL THEN CAST(ref.query('.') AS NVARCHAR(MAX))
	ELSE '<cutOverApprovers _type_="13" userEmail="'+ U.email + '" userId="'+CAST (U.id AS NVARCHAR(210))+'" userName="'+U.login+ '" name="'+ U.name +'"/>' END,
	@curUtcDateTime, 0, 0
FROM @migrateServerDetails.nodes('App_MigrateServerDetails/cutOverApprovers') R (ref)
LEFT JOIN UMUsers U WITH(NOLOCK)
ON ref.query('.').value('(cutOverApprovers/@_type_)[1]', 'int') = 13  -- CvEntities::EntityType_USER_ENTITY = 13
	AND ref.query('.').value('(cutOverApprovers/@userId)[1]', 'int') > 0
	AND U.id = ref.query('.').value('(cutOverApprovers/@userId)[1]', 'int')
INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @destinationClientId, 'CutOver date and time', 1, CAST(ref.query('.') AS NVARCHAR(MAX)), @curUtcDateTime, 0, 0
FROM @migrateServerDetails.nodes('App_MigrateServerDetails/dateAndTime') R (ref)
INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @destinationClientId, 'Source server', 1, CAST(ref.query('.') AS NVARCHAR(MAX)), @curUtcDateTime, 0, 0
FROM @migrateServerDetails.nodes('App_MigrateServerDetails/sourceServer') R (ref)
INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @destinationClientId, 'Filer migration excluded backup content', 1, CAST(ref.query('.') AS NVARCHAR(MAX)), @curUtcDateTime, 0, 0
FROM @migrateServerDetails.nodes('App_MigrateServerDetails/excludedBackupContent') R (ref)
INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @destinationClientId, 'Filer migration included backup content', 1, CAST ((SELECT ref.query('.').value('(includedBackupContent/@path)[1]', 'nvarchar(max)') AS '@path' FOR XML PATH ('includedBackupContent'), TYPE) AS NVARCHAR(MAX)), @curUtcDateTime, 0, 0
FROM @migrateServerDetails.nodes('App_MigrateServerDetails/includedBackupContent') R (ref)
INSERT INTO App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT @destinationClientId, 'Backup threshold for filer migration', 1,  ref.query('.').value('(App_MigrateServerDetails/@backupThreshold)[1]', 'int') , @curUtcDateTime, 0, 0
FROM @migrateServerDetails.nodes('App_MigrateServerDetails') R (ref)
SELECT @errorCode as 'errorCode', @errorString as 'errorString'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetMigrateServerDetailsForDestinationClient')
	delete from GxQscripts where name = 'AppSetMigrateServerDetailsForDestinationClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMigrateServerDetailsForDestinationClient')
	delete from GXDBVersions where aliasname = 'AppSetMigrateServerDetailsForDestinationClient'
GO

insert into GXDBVersions values(2, 'AppSetMigrateServerDetailsForDestinationClient',  '00000000000000000000', 'AppSetMigrateServerDetailsForDestinationClient', '00000000000000000000')
GO

