

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetMemoryLeakSymptomForClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: AppSetMemoryLeakSymptomForClients
--
--
--
--        output: 0/1
--
--
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetMemoryLeakSymptomForClients <<<'

IF EXISTS (select * from sysobjects where name='AppSetMemoryLeakSymptomForClients')
	drop procedure AppSetMemoryLeakSymptomForClients
IF EXISTS (select * from GxQscripts where name='AppSetMemoryLeakSymptomForClients')
	delete from GxQscripts where name = 'AppSetMemoryLeakSymptomForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMemoryLeakSymptomForClients')
	delete from GXDBVersions where aliasname = 'AppSetMemoryLeakSymptomForClients'
GO
print '... Creating Procedure: AppSetMemoryLeakSymptomForClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSetMemoryLeakSymptomForClients
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @now DATETIME = DATEADD(HOUR, -1, GETDATE()) -- Doing for previous hour
	DECLARE @startDateForThreshold DATETIME = DATEADD(DAY, -90, @now)
	DECLARE @minimumTimeForLeak DATETIME = DATEADD(HOUR, -12, @now)
	DECLARE @startDateForMinimum DATETIME = DATEADD(DAY, -7, @now)
	DECLARE @date DATE = @now
	DECLARE @currentHour INT = DATEPART(hour,@now)
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
   	IF OBJECT_ID('tempdb.dbo.#MemoryThreshold') IS NOT NULL
        	DROP TABLE #MemoryThreshold
    	CREATE TABLE #MemoryThreshold
    	(
		clientId INT,
        	threshold INT,
		currentcount INT,
		minMemoryRatio FLOAT,
		timeInterval INT,
		xml NVARCHAR(512)
	)
	-- Getting all the clients which has memory usage more than 80% in last hour
	INSERT INTO #MemoryThreshold(clientId, currentcount)
	SELECT PH.clientId, AVG((PH.physicalMemoryKB * (1 - (PH.percentFreePhysicalMemory * 0.01)))/PH.processes) AS Memory
		FROM [HistoryDB].[dbo].MMPerformanceHistory PH
			INNER JOIN
			(
				SELECT DISTINCT clientId FROM [HistoryDB].[dbo].MMPerformanceHistory HighMemory WHERE
				 (CONVERT(DATE, creationDate) = @date AND DATEPART(HOUR, creationDate) >= @currentHour )
				 AND percentFreePhysicalMemory <= 20
			)HighMemory ON PH.clientId = HighMemory.clientId
			WHERE (CONVERT(DATE, PH.creationDate) = @date AND DATEPART(HOUR, PH.creationDate) >= @currentHour )
			GROUP BY PH.clientId
	-- Calculating average memory usage threshold on listed clients based on 'L' data analysis
	UPDATE MT SET threshold = THRESHOLD.Threshold  FROM #MemoryThreshold MT
	INNER JOIN
	(
		SELECT clientId, CEILING( 1.1 * Average + ((SD+1) * 2.0 * (1 + ABS(SD+1))/(SD+1)) ) AS Threshold FROM
		(
			SELECT clientId, ISNULL(STDEV(Memory), 0) AS SD, AVG(Memory) AS Average, COUNT(Memory) AS HistoryCount FROM
			(
				SELECT PH.clientId, AVG((PH.physicalMemoryKB * (1 - (PH.percentFreePhysicalMemory * 0.01)))/PH.processes) AS Memory FROM [HistoryDB].[dbo].MMPerformanceHistory PH INNER JOIN #MemoryThreshold MT1 ON PH.clientId = MT1.clientId
				WHERE creationDate > @startDateForThreshold AND (CONVERT(DATE, creationDate) = @date OR DATEPART(HOUR,creationDate) = @currentHour ) AND NOT (CONVERT(DATE, creationDate) = @date AND DATEPART(HOUR,creationDate) >= @currentHour )
				GROUP BY PH.clientId, CONVERT(DATE, creationDate), DATEPART(HOUR,creationDate)
			)DATAStats
			GROUP BY clientId
		)THRES WHERE HistoryCount > 30
	)THRESHOLD ON MT.clientId = THRESHOLD.clientId
	-- Deleting clients from list which are under threshold limit
	DELETE FROM #MemoryThreshold WHERE threshold IS NULL OR currentcount < threshold
	-- Getting minimum memory usage for past 7 days and calculating ratio with current and minimum usage
	UPDATE MT SET minMemoryRatio = (MinMemory * 1.0)/currentcount, timeInterval = DATEDIFF(HOUR, creationDate, @now) FROM #MemoryThreshold MT INNER JOIN
	(
		SELECT PH.clientId, creationDate, (PH.physicalMemoryKB * (1 - (PH.percentFreePhysicalMemory * 0.01)))/PH.processes AS MinMemory, ROW_NUMBER()
			 OVER (PARTITION BY PH.clientId ORDER BY ((PH.physicalMemoryKB * (1 - (PH.percentFreePhysicalMemory * 0.01)))/PH.processes) ASC, creationDate DESC) AS RN
			 FROM [HistoryDB].[dbo].MMPerformanceHistory PH INNER JOIN #MemoryThreshold MT1 on MT1.clientId = PH.clientId WHERE creationDate > @startDateForMinimum
	)T ON mt.clientId = T.clientId WHERE RN = 1 AND creationDate <= @minimumTimeForLeak
	-- Removing clients from list for whom ration is either small or high usage time is low.
	DELETE FROM #MemoryThreshold
	WHERE
		minMemoryRatio IS NULL OR
		timeInterval IS NULL OR
		minMemoryRatio > 0.4 OR
		((1 - minMemoryRatio) * timeInterval) < 15
	-- Populating XML to make entry in ClientProp table
	UPDATE #MemoryThreshold SET xml = (SELECT [@threshold] = threshold, [@currentCount] = currentcount FOR XML PATH('anomalyDetails'))
	-- Updating ClientProp table if entry is already available.
	UPDATE CP SET CP.attrVal = xml, CP.created = @time FROM #MemoryThreshold MT
    	INNER JOIN APP_ClientProp CP ON MT.clientId = CP.componentNameId AND CP.attrName = N'Client Memory Leak Symptom Detected' AND modified = 0
	-- Deleting clients from list if entry is already available.
	DELETE MT FROM #MemoryThreshold MT
    	INNER JOIN APP_ClientProp CP ON MT.clientId = CP.componentNameId AND CP.attrName = N'Client Memory Leak Symptom Detected' AND modified = 0
	-- Making entry if entry in not there already.
	INSERT INTO APP_ClientProp
	SELECT clientId, N'Client Memory Leak Symptom Detected', 7, xml, @time, 0, 0  FROM #MemoryThreshold
	IF OBJECT_ID('tempdb.dbo.#MemoryThreshold') IS NOT NULL
		DROP TABLE #MemoryThreshold
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetMemoryLeakSymptomForClients')
	delete from GxQscripts where name = 'AppSetMemoryLeakSymptomForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMemoryLeakSymptomForClients')
	delete from GXDBVersions where aliasname = 'AppSetMemoryLeakSymptomForClients'
GO

insert into GXDBVersions values(2, 'AppSetMemoryLeakSymptomForClients',  '00000000000000000000', 'AppSetMemoryLeakSymptomForClients', '00000000000000000000')
GO

