

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetMSSQLSubclientProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: AppSetMSSQLSubclientProp
--  |
--  | Description:
--  |  To add all properties of mssql subclient
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		 To add all properties of mssql subclient
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetMSSQLSubclientProp <<<'

IF EXISTS (select * from sysobjects where name='AppSetMSSQLSubclientProp')
	drop procedure AppSetMSSQLSubclientProp
IF EXISTS (select * from GxQscripts where name='AppSetMSSQLSubclientProp')
	delete from GxQscripts where name = 'AppSetMSSQLSubclientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMSSQLSubclientProp')
	delete from GXDBVersions where aliasname = 'AppSetMSSQLSubclientProp'
GO
print '... Creating Procedure: AppSetMSSQLSubclientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetMSSQLSubclientProp
  @subclientId INT
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @nowTime   INT   = dbo.GetUnixTime (GetUTCdate())
DECLARE @subclients TABLE(id INT)
INSERT INTO @subclients
SELECT id FROM APP_Application WITH (NOLOCK) WHERE appTypeId = 81 AND subclientStatus <> 4 AND subclientName = 'Do Not Backup'
------- Inserting Read Buffer Size ------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'Read Buffer Size')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,N'Read Buffer Size', 10,64,@nowTime,0,0)
----------- Inserting mssql Log backup streams ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'mssql Log backup streams')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'mssql Log backup streams', 7,2,@nowTime,0,0)
----------- Inserting mssql Data backup streams ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'mssql Data backup streams')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'mssql Data backup streams', 7,2,@nowTime,0,0)
----------- Inserting mssql Bkp Conversion ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'mssql Bkp Conversion')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'mssql Bkp Conversion', 10,3,@nowTime,0,0)
----------- Inserting mssql subclient type ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'mssql subclient type')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'mssql subclient type',7,1,@nowTime,0,0)
----------- Inserting sys: pre post option ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'sys: pre post option')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'sys: pre post option', 10,0,@nowTime,0,0)
----------- Inserting last pre cmd change ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'last pre cmd change')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'last pre cmd change', 10,@nowTime,@nowTime,0,0)
----------- Inserting last post cmd change ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'last post cmd change')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'last post cmd change', 10,@nowTime,@nowTime,0,0)
----------- Inserting MSSQL Tunable BlockSize ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'MSSQL Tunable BlockSize')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'MSSQL Tunable BlockSize', 7,0,@nowTime,0,0)
----------- Inserting MSSQL Tunable BufferCount ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'MSSQL Tunable BufferCount')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'MSSQL Tunable BufferCount', 7,20,@nowTime,0,0)
----------- Inserting MSSQL Tunable Max TransferSize ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'MSSQL Tunable Max TransferSize')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'MSSQL Tunable Max TransferSize', 7,0,@nowTime,0,0)
----------- Inserting FLR Hash Block Size ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'FLR Hash Block Size')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'FLR Hash Block Size', 7,0,@nowTime,0,0)
----------- Inserting FLR Hash Min File Size ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'FLR Hash Min File Size')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'FLR Hash Min File Size', 7,0,@nowTime,0,0)
----------- Inserting Use block level SPOS backup ----------------
IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @subclientId AND modified = 0 AND attrName = N'Use block level SPOS backup')
	INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId) VALUES
	(@subclientId,'Use block level SPOS backup', 10,0,@nowTime,0,0)
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetMSSQLSubclientProp')
	delete from GxQscripts where name = 'AppSetMSSQLSubclientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetMSSQLSubclientProp')
	delete from GXDBVersions where aliasname = 'AppSetMSSQLSubclientProp'
GO

insert into GXDBVersions values(2, 'AppSetMSSQLSubclientProp',  '00000000000000000000', 'AppSetMSSQLSubclientProp', '00000000000000000000')
GO

