

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetLiveBrowseRecoveryPoints.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetLiveBrowseRecoveryPoints.sp,v $ $Id: AppSetLiveBrowseRecoveryPoints.sp,v 1.1.2.7 2019/03/08 16:14:11 shussain Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetLiveBrowseRecoveryPoints')
BEGIN
	print '>>> Drop Stored Procedure: AppSetLiveBrowseRecoveryPoints <<<'
	drop procedure AppSetLiveBrowseRecoveryPoints
END
IF EXISTS (select * from GxQscripts where name='AppSetLiveBrowseRecoveryPoints')
	delete from GxQscripts where name = 'AppSetLiveBrowseRecoveryPoints'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetLiveBrowseRecoveryPoints')
	delete from GXDBVersions where aliasname = 'AppSetLiveBrowseRecoveryPoints'
GO
print '... Creating Procedure: AppSetLiveBrowseRecoveryPoints'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetLiveBrowseRecoveryPoints
  @inputXml XML
AS
  DECLARE @response XML
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  = 0
DECLARE @tmpTbl TABLE
(
	id				BIGINT,
	searchKey		NVARCHAR(1024),
	srcClientId		INTEGER,
	srcInstanceId	INTEGER,
	srcBkpSetId		INTEGER,
	srcSubClientId	INTEGER,
	mountHostId		INTEGER,
	bkpJobId		BIGINT,
	recoveryTime	BIGINT,
	rpJobId			BIGINT,
	srcPath			NVARCHAR(1024),
	mountPath		NVARCHAR(1024),
	phase			VARCHAR(20),
	appType			INTEGER,
	bkpType			INTEGER,
	appData			NVARCHAR(MAX),
	expireTime		BIGINT,
	userName		NVARCHAR(1024),
	initRequest		NVARCHAR(MAX),
	createTime		BIGINT
)
BEGIN TRY
	--Read input into temp Table
	INSERT INTO @tmpTbl
	SELECT
	Tbl.col.value('@id','bigint'),
	Tbl.col.value('@searchKey','nvarchar(1024)'),
	Tbl.col.value('@srcClientId','int'),
	Tbl.col.value('@srcInstanceId','int'),
	Tbl.col.value('@srcBkpSetId','int'),
	Tbl.col.value('@srcSubclientId','int'),
	Tbl.col.value('@mountHoseId','int'),
	Tbl.col.value('@bkpJobId','bigint'),
	Tbl.col.value('@recoveryTime','bigint'),
	Tbl.col.value('@rpJobId','bigint'),
	Tbl.col.value('@srcPath','nvarchar(1024)'),
	Tbl.col.value('@mountPath','nvarchar(1024)'),
	Tbl.col.value('@phase','varchar(20)'),
	Tbl.col.value('@appType','int'),
	Tbl.col.value('@bkpType','int'),
	Tbl.col.value('@appData','nvarchar(MAX)'),
	Tbl.col.value('@expireTime','bigint'),
	Tbl.col.value('@userName','nvarchar(1024)'),
	Tbl.col.value('@initRequest','nvarchar(MAX)'),
	Tbl.col.value('@createTime','bigint')
	FROM
	@inputXml.nodes('Ida_SetLiveBrowseRecoveryPointsReq/rpObjectList') Tbl(col)
	--Update values into DB table
	UPDATE APP_LiveBrowseRecoveryPoints
	SET searchKey	= ISNULL((TRP.searchKey), 		RP.searchKey),
	srcClientId		= ISNULL((TRP.srcClientId), 	RP.srcClientId),
	srcInstanceId	= ISNULL((TRP.srcInstanceId), 	RP.srcInstanceId),
	srcBkpSetId		= ISNULL((TRP.srcBkpSetId),		RP.srcBkpSetId),
	srcSubclientId	= ISNULL((TRP.srcSubclientId),	RP.srcSubclientId),
	mountHostId		= ISNULL((TRP.mountHostId), 	RP.mountHostId),
	bkpJobId		= ISNULL((TRP.bkpJobId), 		RP.bkpJobId),
	recoveryTime	= ISNULL((TRP.recoveryTime),	RP.recoveryTime),
	rpJobid			= ISNULL((TRP.rpJobId), 		RP.rpJobId),
	srcpath			= ISNULL((TRP.srcPath), 		RP.srcPath),
	mountPath		= ISNULL((TRP.mountPath),		RP.mountPath),
	phase			= ISNULL((TRP.phase),  			RP.phase),
	apptype			= ISNULL((TRP.appType),  		RP.appType),
	bkpType			= ISNULL((TRP.bkpType),  		RP.bkpType),
	appData			= ISNULL(cast((TRP.appData) as XML), 		RP.appData),
	expireTime		= ISNULL((TRP.expireTime), 		RP.expireTime),
	userName		= ISNULL((TRP.userName), 		RP.userName),
	initRequest		= ISNULL(cast((TRP.initRequest) as XML), 		RP.initRequest),
	createTime		= ISNULL((TRP.createTime), 		RP.createTime)
	FROM APP_LiveBrowseRecoveryPoints RP, @tmpTbl TRP
	where RP.id = TRP.id
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	BEGIN
	SET @errorCode = 1
    SET @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
	END
END CATCH
SET @response= (SELECT
					( SELECT @errorCode as '@errorCode', @errorString as '@errorMessage'
                        FOR XML PATH('response'), TYPE
					)
				FOR XML PATH(''), ROOT('Ida_SetLiveBrowseRecoveryPointsResp'))
SELECT @response
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetLiveBrowseRecoveryPoints')
	delete from GxQscripts where name = 'AppSetLiveBrowseRecoveryPoints'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetLiveBrowseRecoveryPoints')
	delete from GXDBVersions where aliasname = 'AppSetLiveBrowseRecoveryPoints'
GO

insert into GXDBVersions values(2, 'AppSetLiveBrowseRecoveryPoints',  '00010001000200070000', 'AppSetLiveBrowseRecoveryPoints', '00010001000200070000')
GO

