

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetLicense.sp] ---------- 

-------------------------------------------------------------------------------
--   AppSetLicense - Set/Clear License on client
-------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetLicense.sp,v $ $Id: AppSetLicense.sp,v 1.7.60.2 2018/03/22 01:30:05 jiechen Exp $";
--:SET_QUOTED_IDENTIFIER_ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetLicense <<<'

IF EXISTS (select * from sysobjects where name='AppSetLicense')
	drop procedure AppSetLicense
IF EXISTS (select * from GxQscripts where name='AppSetLicense')
	delete from GxQscripts where name = 'AppSetLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetLicense')
	delete from GXDBVersions where aliasname = 'AppSetLicense'
GO
print '... Creating Procedure: AppSetLicense'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSetLicense
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @clientId integer,
  @license integer,
  @licenseVal integer
AS
DECLARE @errCode as int = 0
DECLARE @errString as varchar(1024)=''
DECLARE @hasChanged as int = 0
DECLARE @LicVal   VARCHAR(1024)
BEGIN TRY
		DECLARE @LicName AS VARCHAR(1024) = dbo.GetLicensePropName(@license)
		SET @LicVal  =  convert(varchar(12), @licenseVal)
IF @LicName = 'Installed '			--'CV_PROP_INSTALLED_NAME'
		BEGIN
			Set @errCode= 0x010001                                      --CV_APPID_NOT_FOUND (from appMgr/errors.h)
			SET @errString = 'No License Propname for ['+Convert(varchar(20), @license) + '].'
			SELECT @errCode, 0, 0, @errString
		END
		ELSE
		BEGIN
--  		DON'T WRITE TO DB IF PROPERTY IS BEING CLEARED NOW AND WASN'T PREVIOUSLY SET!   (per Waqas, 4/13/2010)
			IF @licenseVal = 1 OR EXISTS (Select * from app_ClientProp
											Where componentNameId = @clientId
											  AND attrName = @licName
											  AND attrVal  = '1'
											  AND modified = 0
			)
				exec AppInsertClientProp @clientId, 0, 0,@LicName, 2, @LicVal  -- Will row from here be set for c++?
			ELSE
				SELECT @errCode, 0, 0, @errString
		END
END   TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
	SELECT @errCode, 0, 0, @errString
END	  CATCH


IF EXISTS (select * from GxQscripts where name = 'AppSetLicense')
	delete from GxQscripts where name = 'AppSetLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetLicense')
	delete from GXDBVersions where aliasname = 'AppSetLicense'
GO

insert into GXDBVersions values(2, 'AppSetLicense',  '00010007006000020000', 'AppSetLicense', '00010007006000020000')
GO

