

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetLaptopdescription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppSetLaptopDescription()
--  |
--  | Description:  Set the laptop description to "Name of the owners."
--  |
--  |       Input:  lapTop client Id,owner user Id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To set the description of a laptop client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetLaptopDescription')
BEGIN
	print '>>> Drop Stored Procedure: AppSetLaptopDescription <<<'
	drop procedure AppSetLaptopDescription
END
IF EXISTS (select * from GxQscripts where name='AppSetLaptopDescription')
	delete from GxQscripts where name = 'AppSetLaptopDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetLaptopDescription')
	delete from GXDBVersions where aliasname = 'AppSetLaptopDescription'
GO
print '... Creating Procedure: AppSetLaptopDescription'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetLaptopDescription
  @laptopClientId INT,
  @ownerId INT
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorString = N''
-- Skipping populating Client Description with Owner name if the new additonal setting 'SkipClientDescription' is set to 1
DECLARE @isSkipClientDesc integer  = ISNULL((SELECT TOP 1 id FROM GXGlobalParam where name='SkipClientDescription' and value='1'),0)
BEGIN TRY
-- Only enter the try block if isSkipClientDesc is set to 0
IF @isSkipClientDesc=0
BEGIN
	IF object_id('tempdb.dbo.#ctbl') is not null DROP TABLE #ctbl
	create table #ctbl( ownerId integer PRIMARY KEY )
	IF @ownerId <> 0
	BEGIN
		INSERT INTO #ctbl
		VALUES (@ownerId)
	END
	ELSE
	BEGIN
		INSERT INTO #ctbl
		SELECT distinct userId FROM sec_getClientOwnersConfig
		WHERE clientId = @laptopClientId
	END
	IF EXISTS (SELECT TOP 1 ownerId FROM #ctbl)
	BEGIN
		update  C
		set C.clientDescription = ISNULL(STUFF(
									(SELECT ', '+ U.name from UMUSERS U JOIN #ctbl T1 ON U.id = T1.ownerId
									 FOR XML PATH(''), TYPE).value('.[1]', 'nvarchar(max)'),
									 1, 2, ''),'')
		FROM App_client C
		WHERE C.id = @laptopClientId AND
C.status & 0x1000  = 0x1000
	END
	DROP TABLE #ctbl
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetLaptopdescription')
	delete from GxQscripts where name = 'AppSetLaptopdescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetLaptopdescription')
	delete from GXDBVersions where aliasname = 'AppSetLaptopdescription'
GO

insert into GXDBVersions values(2, 'AppSetLaptopdescription',  '00000000000000000000', 'AppSetLaptopdescription', '00000000000000000000')
GO

