

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIsInfrastructurePropertyForNewClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetIsInfrastructurePropertyForNewClient.sp,v $ $Id: AppSetIsInfrastructurePropertyForNewClient.sp,v 1.1.2.6 2020/11/03 01:14:01 kvinayak Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSetIsInfrastructurePropertyForNewClient"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetIsInfrastructurePropertyForNewClient')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIsInfrastructurePropertyForNewClient <<<'
	drop procedure AppSetIsInfrastructurePropertyForNewClient
END
IF EXISTS (select * from GxQscripts where name='AppSetIsInfrastructurePropertyForNewClient')
	delete from GxQscripts where name = 'AppSetIsInfrastructurePropertyForNewClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIsInfrastructurePropertyForNewClient')
	delete from GXDBVersions where aliasname = 'AppSetIsInfrastructurePropertyForNewClient'
GO
print '... Creating Procedure: AppSetIsInfrastructurePropertyForNewClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetIsInfrastructurePropertyForNewClient
  @i_clientId integer=0
AS
SET NOCOUNT ON
BEGIN
	DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(GETUTCDATE()))
	---set the property IsInfrastructure
	DECLARE @IsInfrastructureClient int = 0
	DECLARE @InfrastructureMachineType int = 0
	--MA Look for media agents in the MMHost because cluster media agents will not have package in simInstalledPackages
	IF EXISTS(SELECT TOP 1 1 FROM MMHost WITH(NOLOCK)  WHERE ClientId=@i_clientId AND clientid NOT IN (SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId = 2) )
	BEGIN
		SET @IsInfrastructureClient = 1
	END
	--20 CommServe
	--55  Index Store
	--151 Exchange
	--252 Web Server
	--259 Content Extractor
	--713 VirtualServer Agent
	--726 Web Console
	--730 Cloud Apps
	--729 Content Analyzer
	--1136      VirtualServer Agent on UNIX
	--
	ELSE IF EXISTS(SELECT top 1 1 from simInstalledPackages WITH(NOLOCK)  WHERE ClientId=@i_clientId AND simPackageID in
(55,151, 252, 259,
713,726,729,1108,730,
734,1136, 20,1020,1174,1135,1306
,1173,1140))
	BEGIN
		SET @IsInfrastructureClient = 1
	END
	IF (@IsInfrastructureClient = 1)
	BEGIN
              INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
              SELECT
@i_clientId,'IsInfrastructure' , 2, 1, @currentTime, 0 , 0
              WHERE
                     NOT EXISTS (
                           SELECT 1
                           FROM APP_ClientProp WITH(NOLOCK)
WHERE attrName = 'IsInfrastructure'
                                  AND modified = 0
                                  AND componentNameId = @i_clientId
                     )
			 INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
              SELECT
@i_clientId,'IsInfrastructureMachine' , 2, 1, @currentTime, 0 , 0
              WHERE
                     NOT EXISTS (
                           SELECT 1
                           FROM APP_ClientProp WITH(NOLOCK)
WHERE attrName = 'IsInfrastructureMachine'
                                  AND modified = 0
                                  AND componentNameId = @i_clientId
                     )
			-- Set Type of Infrastructure Machine
			SET @InfrastructureMachineType = ISNULL((SELECT SUM(PToF.infrastructureClientFlag) FROM simInstalledPackages SP
				INNER JOIN App_InfrastructurePkgToFlagMap PToF
				ON SP.simPackageID = PToF.infrastructureClientPkgId where SP.ClientId=@i_clientId), 0)
			 INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
              SELECT
@i_clientId,'InfrastructureMachineType' , 2, @InfrastructureMachineType, @currentTime, 0 , 0
              WHERE
                     NOT EXISTS (
                           SELECT 1
                           FROM APP_ClientProp WITH(NOLOCK)
WHERE attrName = 'InfrastructureMachineType'
                                  AND modified = 0
                                  AND componentNameId = @i_clientId
                     )
	END
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSetIsInfrastructurePropertyForNewClient')
	delete from GxQscripts where name = 'AppSetIsInfrastructurePropertyForNewClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIsInfrastructurePropertyForNewClient')
	delete from GXDBVersions where aliasname = 'AppSetIsInfrastructurePropertyForNewClient'
GO

insert into GXDBVersions values(2, 'AppSetIsInfrastructurePropertyForNewClient',  '00010001000200060000', 'AppSetIsInfrastructurePropertyForNewClient', '00010001000200060000')
GO

