

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIsInfrastructurePropertyForClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetIsInfrastructurePropertyForClients.sp,v $ $Id: AppSetIsInfrastructurePropertyForClients.sp,v 1.1.2.15 2020/12/14 15:27:28 nshah Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppSetIsInfrastructurePropertyForNewClient"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetIsInfrastructurePropertyForClients')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIsInfrastructurePropertyForClients <<<'
	drop procedure AppSetIsInfrastructurePropertyForClients
END
IF EXISTS (select * from GxQscripts where name='AppSetIsInfrastructurePropertyForClients')
	delete from GxQscripts where name = 'AppSetIsInfrastructurePropertyForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIsInfrastructurePropertyForClients')
	delete from GXDBVersions where aliasname = 'AppSetIsInfrastructurePropertyForClients'
GO
print '... Creating Procedure: AppSetIsInfrastructurePropertyForClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetIsInfrastructurePropertyForClients
AS
SET NOCOUNT ON
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
DECLARE @subclientStatusExclude int = cast(0x00010 as int) |  0x00020
	DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(GETUTCDATE()) )
	--Get the clients where the jobs ran
	IF object_id('tempdb.dbo.#backedupClientList') IS NOT NULL
		DROP TABLE #backedupClientList
	CREATE TABLE  #backedupClientList ( cId  int  PRIMARY KEY)
	-- AEB Performance: Identified a bug / fixed and improve performance to avoid query being executed in parallel mode.
	INSERT INTO #backedupClientList
		SELECT
			q.clientId
		FROM
			(
				SELECT
					a.clientId,
					a.id
				FROM JMBkpStats r
					INNER JOIN APP_Application a ON
						r.appId = a.id
						AND (a.subclientstatus & @subclientStatusExclude) = 0
				WHERE
					r.STATUS IN (1, 3, 14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
					AND r.commCellId = 2	-- default commcell Id
				EXCEPT	-- bug fix to exclude clientId / appId not wanted
				SELECT
					a.clientId,
					a.id
				FROM JMBkpStats r
					INNER JOIN APP_Application a ON
						r.appId = a.id
						AND (a.subclientstatus & @subclientStatusExclude) = 0
					INNER JOIN APP_SubClientProp p ON
						p.componentNameId = a.id
						AND p.attrName IN (N'Index SubClient', N'DDB Backup')
						AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))	-- performance for index scan to index seek op
						AND p.modified = 0
						AND p.attrVal = N'1'
				WHERE
					r.STATUS IN (1, 3, 14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
					AND r.commCellId = 2	-- default commcell Id
			) q
		UNION
		SELECT
			a.clientId
		FROM APP_Application a
			LEFT JOIN APP_SubClientProp p ON
				p.componentNameId = a.id
				AND p.attrName IN (N'Index SubClient', N'DDB Backup')
				AND p.modified = 0
				AND p.attrVal = N'1'
				AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))
		WHERE
			dataArchGrpID != 1	 --has storage policy associated
			AND (subclientstatus & @subclientStatusExclude) = 0
			AND p.id IS NULL
			AND a.appTypeId != 1000
			AND a.appTypeId != 1030
	IF object_id('tempdb.dbo.#infrastructureClientList') IS NOT NULL
		DROP TABLE #infrastructureClientList
	CREATE TABLE  #infrastructureClientList ( cId  int  PRIMARY KEY, infrastructureMachineType int DEFAULT (0) )
	IF object_id('tempdb.dbo.#proxyProperties') IS NOT NULL
		DROP TABLE #proxyProperties
	CREATE TABLE  #proxyProperties (attrName varchar(50), attrVal XML)
	INSERT INTO #proxyProperties(attrName, attrVal)
		-- AEB Performance: parallel query change to single core with better index selection.  Elpase / CPU time dropped from ~105ms / ~700ms to 23ms / 16ms and CPUs from 8 to 1
		SELECT
			attrName,
			CAST(attrVal AS XML)
		FROM APP_InstanceProp
		WHERE
			attrName IN (N'Hadoop Config', N'Data Access Nodes')		-- Performance: If scanning index combine selects so only 1 scan op performed
			AND modified = 0
		UNION ALL
		SELECT
			'backup configuration nodes',
			CAST(attrVal AS XML)
		FROM APP_SubClientProp
		WHERE
			attrName = N'backup configuration nodes'
			AND cs_attrName = CHECKSUM(N'backup configuration nodes')	-- Performance: removed scan op by better index selection, now seek op
			AND modified = 0
			AND attrVal <> N'<App_BackupConfigurationNodes/>'
		UNION ALL
		SELECT
			attrName,
			CAST(attrVal AS XML) AS xmlValue
		FROM APP_IDAProp
		WHERE
			attrName IN (N'backup configuration nodes', N'Cloud Proxy Servers')		-- Performance: If scanning index combine selects so only 1 scan op performed
			AND modified = 0
			AND attrVal <> N'<App_BackupConfigurationNodes/>'
	INSERT INTO #infrastructureClientList (cid)
		--SERVERS
		--20 commserve
		--55  Index Store
		--252 Web Server
		--259 Content Extractor
		--713 VirtualServer Agent
		--726 Web Console
		--729 Content Analyzer
		--1136      VirtualServer Agent on UNIX
		--151 Exchange
		--730 Cloud Apps
		--1140 unix Cloud Apps
		--1173 unix Content Extractor
		--1306 unix Index Store
		--1135 unix web console
		--1174 unix Web Server
		--1020 unix commserve
	SELECT ClientId from simInstalledPackages
		WHERE simPackageID in (713,1136,259,55,729,726,252,730,20,1140,1173,1306,1135,1174,1020)
	UNION
	SELECT CLIENTID FROM
	MMHost M
	LEFT JOIN APP_VMToPMMap V ON VMClientId = 2 AND V.PMClientId=M.ClientId
	WHERE V.PMClientId IS NULL
	UNION
	--proxy clients
	SELECT  clientId FROM APP_FirewallOptions WHERE isDMZ=1 and clientId > 0
	UNION
	SELECT  c.clientId FROM APP_FirewallOptions f
	INNER JOIN APP_ClientGroupAssoc c ON f.clientGroupId=c.clientGroupId WHERE f.isDMZ=1
	--GREEN PLUM
	UNION
	SELECT  CAST(attrVal AS INT) FROM APP_InstanceProp WHERE attrName = 'Greenplum Master Client Id' AND modified=0
	UNION
	--GREEN PLUM
	SELECT  clientId FROM APP_GreenPlumAssociation
	UNION
	--Hadoop (master)
	SELECT  attrVal.value('(//App_HadoopConfig/coordinatorNode/@clientId)[1]', 'INT') FROM #proxyProperties WHERE attrName = 'Hadoop Config'
	UNION
	--Hadoop (farm clients)
	SELECT  ref.value('@clientId', 'INT')
	FROM(
	SELECT attrVal  as xmlValue
				FROM #proxyProperties WHERE attrName = 'Hadoop Config'
				) T
				CROSS APPLY T.xmlValue.nodes('App_HadoopConfig/hadoopSites/clusterNodes/client') r(ref)
	UNION
	--Distributed IDA - FS. mongoDB, Cassandra
	SELECT  cast(attrVal as int) FROM APP_InstanceProp WHERE attrName = 'Coordinator Node' AND modified = 0
	UNION
	--mongoDB (farm clients)
	SELECT  ref.value('@clientId', 'INT')
	FROM(
	SELECT attrVal AS xmlValue
				FROM #proxyProperties WHERE attrName = 'Data Access Nodes'
				) T
				CROSS APPLY T.xmlValue.nodes('App_DataAccessNodes/dataAccessNodes') r(ref)
	--Cassandra
	UNION
	SELECT  nodeclientId FROM APP_CassandraNodeProps
	UNION
	--multinode cilents: It can save as subclient or agent properties. It can be client or clientgroup
	SELECT  clientId FROM APP_ClientGroupAssoc WHERE clientGroupId IN (
	SELECT ref.value('@clientGroupId', 'INT')
	FROM(
	SELECT attrVal as xmlValue
				FROM #proxyProperties WHERE attrName = 'backup configuration nodes'
				) T
				CROSS APPLY T.xmlValue.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') r(ref)
				)
	UNION
	SELECT  ref.value('@clientId', 'INT')
	FROM(
	SELECT attrVal as xmlValue
				FROM #proxyProperties WHERE attrName = 'backup configuration nodes'
				) T
				CROSS APPLY T.xmlValue.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') r(ref) WHERE ref.value('@clientId', 'INT') IS NOT NULL
	UNION
	--DB2 MULTI NODE
	SELECT  substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
	FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T1
	WHERE   IP.attrName = 'DB2 Partition Clients' AND IP.modified = 0
	UNION
	--SAP HANA
	SELECT  T1.Data FROM APP_InstanceProp IP CROSS APPLY dbo.SplitString(IP.attrVal, '+') T1
	WHERE   IP.attrName = 'Database Clients' AND IP.modified = 0
	UNION
	--SQL AWS AND AZURE
	SELECT  ref.value('@clientId', 'INT')
	FROM(
	SELECT attrVal as xmlValue
				FROM #proxyProperties WHERE attrName = 'Cloud Proxy Servers'
				) T
				CROSS APPLY T.xmlValue.nodes('App_MemberServers/memberServers/client') r(ref)
	UNION
	--oracle RAC
	SELECT clientId FROM APP_OracleRacInstance
	--delete the client ids that are no longer in app_client table
	DELETE p FROM #infrastructureClientList p
	LEFT JOIN app_client c ON p.cid = c.id
WHERE c.id is null OR c.status & 0x1000 <> 0
	-- Update infratructureMachineType in #infrastructureClientList
	UPDATE InfraList
	SET InfraList.infrastructureMachineType = B.InfrastructureMachineflags
	FROM #infrastructureClientList InfraList
	INNER JOIN (
				SELECT InfraListTmp.cId, SUM(PToF.infrastructureClientFlag) AS 'InfrastructureMachineflags'
				FROM #infrastructureClientList InfraListTmp
				INNER JOIN simInstalledPackages SP WITH (NOLOCK)
					ON SP.ClientId = InfraListTmp.cId
				INNER JOIN App_InfrastructurePkgToFlagMap PToF WITH (NOLOCK)
					ON SP.simPackageID = PToF.infrastructureClientPkgId
				GROUP BY (InfraListTmp.cId)) B
		ON InfraList.Cid = B.cId
	--List of Infrastructure clients
	--select * from APP_Client where id in(
	--SELECT  p.cId FROM #infrastructureClientList p
	--LEFT JOIN #backedupClientList b on p.cId = b.cId
	--WHERE b.cId is null)
	--Update the property of the existing clients
	--Update the property of the existing clients that in backup list
	UPDATE P SET attrVal = '0'
	FROM App_clientProp P
	INNER JOIN #backedupClientList C ON C.cId = P.componentNameId
	WHERE attrName = 'IsInfrastructure' AND attrVal = '1' and modified=0
	--Update the property of the existing clients that are not in backup list now
	UPDATE P
		SET attrVal = '1'
	FROM App_clientProp P
	INNER JOIN  #infrastructureClientList i ON
			i.cid = p.componentNameId
		LEFT JOIN #backedupClientList C ON
			C.cId = P.componentNameId
	WHERE
P.attrName = 'IsInfrastructure'
		AND P.attrVal = N'0'
		AND P.modified = 0		-- performance: better index selection and eliminates parallel execution due to Index Scan Op
		AND c.cid is null
    -- Update infrastructureMachine property if new packages are installed
	UPDATE P
		SET attrVal = '1'
	FROM App_clientProp P
	INNER JOIN #infrastructureClientList infraList ON
		P.componentNameId = infraList.cId
AND P.attrName = 'IsInfrastructureMachine'
		AND P.attrVal <> '1'
		AND P.modified = 0
	LEFT JOIN App_clientProp P1 ON
		P1.componentNameId = P.componentNameId
AND P1.attrName='IsInfrastructureMachineUserDefined'
		AND P1.attrVal='0' AND P1.modified=0
	WHERE P1.id IS NULL
	-- Update the infrastructureMachineType in App_ClientProp table
	UPDATE P
		SET P.attrVal = infraList.infrastructureMachineType
	FROM App_ClientProp P
		INNER JOIN #infrastructureClientList infraList ON
			P.componentNameId = infraList.cId
AND P.attrName = 'InfrastructureMachineType'
		AND P.attrVal <> infraList.infrastructureMachineType
		AND modified=0
	-- INSERT IsInfrastructure, IsInfrastructureMachine and InfrastructureMachineType properties.
	-- Adding them in single insert statement.
	INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT p.cId, 'IsInfrastructure', 2, 1, @currentTime, 0 , 0
	FROM #infrastructureClientList p
	LEFT JOIN #backedupClientList b on p.cId = b.cId
LEFT JOIN APP_ClientProp cp  on cp.componentNameId=p.cId and cp.attrName='IsInfrastructure' and modified=0
	WHERE b.cId is null AND cp.componentNameId is null
	UNION ALL
SELECT p.cId, 'IsInfrastructureMachine', 2, 1, @currentTime, 0 , 0
	FROM #infrastructureClientList p
LEFT JOIN APP_ClientProp cp  on cp.componentNameId=p.cId and cp.attrName='IsInfrastructureMachine' and modified=0
	WHERE cp.componentNameId is null
	UNION ALL
SELECT p.cId, 'InfrastructureMachineType', 2, p.infrastructureMachineType, @currentTime, 0 , 0
	FROM #infrastructureClientList p
LEFT JOIN APP_ClientProp cp on cp.componentNameId=p.cId and cp.attrName='InfrastructureMachineType' and modified=0
	WHERE cp.componentNameId is null
	IF object_id('tempdb.dbo.#backedupClientList') IS NOT NULL
		DROP TABLE #backedupClientList
	IF object_id('tempdb.dbo.#infrastructureClientList') IS NOT NULL
		DROP TABLE #infrastructureClientList
	IF object_id('tempdb.dbo.#proxyProperties') IS NOT NULL
		DROP TABLE #proxyProperties
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppSetIsInfrastructurePropertyForClients')
	delete from GxQscripts where name = 'AppSetIsInfrastructurePropertyForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIsInfrastructurePropertyForClients')
	delete from GXDBVersions where aliasname = 'AppSetIsInfrastructurePropertyForClients'
GO

insert into GXDBVersions values(2, 'AppSetIsInfrastructurePropertyForClients',  '00010001000200150000', 'AppSetIsInfrastructurePropertyForClients', '00010001000200150000')
GO

