

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetInstallationCompanyId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure: "AppSetInstallationCompanyId.sp"
--	|	Description: It sets Installation Company Id property for missing clients.
--	|				 Main use case is, VM clients that are added by tenant admins and do not have the property set.
--	| 				 This is called from Smart client group refresh code.
--	|	Inputs: A well known external temp table #AppSetInstallationCompanyId_clientsWithoutProp that has list of client Ids without this property.
--	|			nowTime (if available).
--	|	Outputs: errorCode, errorString
--	|	Author: jswaminathan
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetInstallationCompanyId')
BEGIN
	print '>>> Drop Stored Procedure: AppSetInstallationCompanyId <<<'
	drop procedure AppSetInstallationCompanyId
END
IF EXISTS (select * from GxQscripts where name='AppSetInstallationCompanyId')
	delete from GxQscripts where name = 'AppSetInstallationCompanyId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetInstallationCompanyId')
	delete from GXDBVersions where aliasname = 'AppSetInstallationCompanyId'
GO
print '... Creating Procedure: AppSetInstallationCompanyId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetInstallationCompanyId
  @nowTime INT = 0,
  @o_errorCode INT OUTPUT,
  @o_errorString VARCHAR(1024) OUTPUT
AS
-- Temp table to be created by caller code before calling this SP.
--IF OBJECT_ID('tempdb.dbo.#AppSetInstallationCompanyId_clientsWithoutProp') IS NOT NULL
--	DROP TABLE #AppSetInstallationCompanyId_clientsWithoutProp
--CREATE TABLE #AppSetInstallationCompanyId_clientsWithoutProp
--(
--	clientId INT PRIMARY KEY
--)
IF @nowTime = 0
	SET @nowTime = dbo.getUnixTime(GETUTCDATE())
-- Caller should mandatorily pass output table. Else raise exception.
IF OBJECT_ID('tempdb.dbo.#AppSetInstallationCompanyId_clientsWithoutProp') IS NULL
BEGIN
	RAISERROR('Error. Input table AppSetInstallationCompanyId_clientsWithoutProp not yet created',
			16,
			1
			)
	RETURN
END
IF EXISTS (SELECT TOP 1 clientId FROM #AppSetInstallationCompanyId_clientsWithoutProp)
	AND NOT EXISTS (SELECT TOP 1 value FROM GxGlobalParam (NOLOCK) WHERE name = 'SCGRefresh_SetInstallCompanyId' AND value = '0' AND modified = 0)
BEGIN
	BEGIN TRY
		-- This is the final table. It contains the company Id of each client. (one row per client)
		IF OBJECT_ID('tempdb.dbo.#ClientCompanies') IS NOT NULL
			DROP TABLE #ClientCompanies
		CREATE TABLE #ClientCompanies
		(
			clientId INT PRIMARY KEY,
			companyId INT
		)
		-- This is temp table. It can contain multiple rows per client.
		IF OBJECT_ID('tempdb.dbo.#ClientCompaniesTemp') IS NOT NULL
			DROP TABLE #ClientCompaniesTemp
		CREATE TABLE #ClientCompaniesTemp
		(
			clientId INT,
			companyId INT
			UNIQUE CLUSTERED (clientId, companyId)			-- Some clients may belong to multiple companies.
		)
		-- Get the company Ids of the client from their SCG association.
		INSERT INTO #ClientCompaniesTemp
			SELECT CGA.clientId,
					CP.componentNameId
			FROM #AppSetInstallationCompanyId_clientsWithoutProp I
				INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK)
					ON I.clientId = CGA.clientId
				INNER JOIN APP_CompanyProp CP (NOLOCK)
ON CP.attrName = 'Associated Smart Client Group'
					AND CP.attrVal = CAST(CGA.clientGroupId AS VARCHAR(10))
					AND CP.modified = 0
		IF @@ROWCOUNT > 0		-- If this is 0, then there are no clients belonging to company. Let all of them be set with 0.
		BEGIN
			-- Clients are belonging to one or more companies. We will now apply our thumb rule to process these clients.
			-- 1. If client belongs to only one company, then that is the final company Id.
			-- 2. If client belongs to multiple company Ids, then
				-- a. If the companies are mutually exclusive, then final company Id is 0. (might be infrastructure machines shared between tenants).
				-- b. If the companies are parent - child, then final company Id is the parent most company Id. (reseller configuration).
			DECLARE @_companyClientsCount INT = 0
			DECLARE @_processedClientsCount INT = 0
			SET @_companyClientsCount = (SELECT COUNT(DISTINCT clientId) FROM #ClientCompaniesTemp)
			-- 1. Clients belonging to one company.
			INSERT INTO #ClientCompanies
				SELECT clientId, MIN(companyId)
				FROM #ClientCompaniesTemp
				GROUP BY clientID
				HAVING COUNT(companyId) = 1
			SET @_processedClientsCount = @@ROWCOUNT					-- One client - one row.
			IF (@_companyClientsCount <> @_processedClientsCount)		-- If they both are equal, then all clients with company Id are processed.
			BEGIN
				-- 2a. Clients belonging to mutually exclusive companies.
				INSERT INTO #ClientCompanies
					SELECT CCT.clientId, 0
					FROM #ClientCompaniesTemp CCT
						INNER JOIN UMDSProviders P (NOLOCK)
							ON CCT.companyId = P.id
							AND P.ownerCompany = 0			-- Mutually exclusive companies.
					GROUP BY CCT.clientID
					HAVING COUNT(CCT.companyId) > 1
				SET @_processedClientsCount = @@ROWCOUNT + @_processedClientsCount 		-- Again, one client - one row (with 0 company Id).
				IF (@_companyClientsCount <> @_processedClientsCount)					-- If they both are equal, then all clients with company Id are processed.
				BEGIN
					-- Remove already processed clients.
					DELETE CCT
					FROM #ClientCompaniesTemp CCT
						INNER JOIN #ClientCompanies CC
							ON CCT.clientId = CC.clientId
					-- 2b. Reseller configuration.
					-- Does all the companies (for each client) come under same family tree? If yes, set parent most company Id. If no, set 0.
					-- 1. Get child-most(maximum) company Id for each client.
					IF OBJECT_ID('tempdb.dbo.#ClientsAndChildMostCompanies') IS NOT NULL
						DROP TABLE #ClientsAndChildMostCompanies
					CREATE TABLE #ClientsAndChildMostCompanies
					(
						clientId INT,
						childMostCompanyId INT,
						UNIQUE CLUSTERED (clientId, childMostCompanyId)
					)
					INSERT INTO #ClientsAndChildMostCompanies
						SELECT clientId, MAX(companyId)
						FROM #ClientCompaniesTemp
						GROUP BY clientId
					-- 2. Get parent companies for these child-most companies.
					IF OBJECT_ID('tempdb.dbo.#ChildMostAndParentCompanies') IS NOT NULL
						DROP TABLE #ChildMostAndParentCompanies
					CREATE TABLE #ChildMostAndParentCompanies
					(
						childMostCompanyId INT,
						parentCompanyID INT,
						UNIQUE CLUSTERED (childMostCompanyId, parentCompanyId)
					)
					;WITH CTECompanies (childMostCompanyId, parentCompanyId)
					AS
					(
						SELECT DISTINCT C.childMostCompanyId AS childMostCompanyId,			-- Many clients can have same child-most company. Use DISTINCT to reduce the no. of rows processed.
										P.ownerCompany AS parentCompanyId
						FROM #ClientsAndChildMostCompanies C
							INNER JOIN UMDSProviders P
								ON C.childMostCompanyId = P.id
						WHERE
							P.ownerCompany <> 0
						UNION ALL
						SELECT C.childMostCompanyId AS childCompanyId,
							   P.ownerCompany AS parentCompanyId
						FROM CTECompanies C
							INNER JOIN UMDSProviders P
								ON P.id = C.parentCompanyId
						WHERE
							P.ownerCompany <> 0
					)
					INSERT INTO #ChildMostAndParentCompanies
						SELECT DISTINCT childMostCompanyId, parentCompanyId
						FROM CTECompanies
					-- 3. Validate entries in Client Companies temp against this.
					-- If client belongs to either the child most company or it's parent company, then that entry is valid.
					IF OBJECT_ID('tempdb.dbo.#validEntries') IS NOT NULL
						DROP TABLE #validEntries
					CREATE TABLE #validEntries
					(
						clientID INT,
						allowedCompanyId INT
						UNIQUE CLUSTERED (clientId, allowedCompanyId)
					)
					INSERT INTO #validEntries
						SELECT ClientChildMostCompany.clientID, parentCompanyID
						FROM #ClientsAndChildMostCompanies ClientChildMostCompany
							INNER JOIN #ChildMostAndParentCompanies ChildMostParentCompanies
								ON ClientChildMostCompany.childMostCompanyId = ChildMostParentCompanies.childMostCompanyId
							INNER JOIN #ClientCompaniesTemp CCT
								ON CCT.clientId = ClientChildMostCompany.clientId AND CCT.companyId = parentCompanyID
						UNION
						SELECT clientId, childMostCompanyId
						FROM #ClientsAndChildMostCompanies ClientChildMostCompany
					-- 4. Identify those misconfigured client - company Id combinations that are not part of above allowed table. (MisConfiguredClients: Column: clientId)
					IF OBJECT_ID('tempdb.dbo.#misConfiguredClients') IS NOT NULL
						DROP TABLE #misConfiguredClients
					CREATE TABLE #misConfiguredClients
					(
						clientId INT PRIMARY KEY
					)
					INSERT INTO #misConfiguredClients
						SELECT DISTINCT CCT.clientId
						FROM #ClientCompaniesTemp CCT
							LEFT OUTER JOIN #validEntries APC
								ON CCT.clientId = APC.clientId
								AND CCT.companyId = APC.allowedCompanyId
						WHERE
							APC.allowedCompanyId IS NULL
					-- 5. For the remaining clients not part of the misconfigured table, set them with the parent-most(minimum) company Id for each client. (ClientCompanies).
					INSERT INTO #ClientCompanies
						SELECT CCT.clientId, MIN(companyId)
						FROM #ClientCompaniesTemp CCT
							LEFT OUTER JOIN #misConfiguredClients MCC
								ON CCT.clientId = MCC.clientId
						WHERE
							MCC.clientId IS NULL
						GROUP BY CCT.clientId
				END				-- Inner (@_companyClientsCount <> @_processedClientsCount)
			END		-- Outer (@_companyClientsCount <> @_processedClientsCount)
		END		-- Row count > 0
		IF OBJECT_ID('tempdb.dbo.#clientCompanyMap') IS NOT NULL
        	DROP TABLE #clientCompanyMap
    	CREATE TABLE #clientCompanyMap
        (
            	id INT NOT NULL,
				companyId INT
            	PRIMARY KEY (id)
        )
		-- This is the final list that is going to be set.
		INSERT INTO #clientCompanyMap
			SELECT DISTINCT
					I.clientId,
					CASE WHEN CC.companyId IS NOT NULL THEN CC.companyId ELSE 0 END
			FROM #AppSetInstallationCompanyId_clientsWithoutProp I
				LEFT OUTER JOIN #ClientCompanies CC
					ON I.clientID = CC.clientId
		-- If some client already has set as 0, then overwrite it. Don't overwrite if some other non-zero value is set.
		UPDATE APP_ClientProp
		SET attrVal = CC.companyId,
			created = @nowTime
		FROM #clientCompanyMap CC
WHERE (componentNameId = CC.id) AND (attrName = 'Installation Company ID') AND (attrVal = '0') AND (modified = 0) AND (CC.companyId <> 0)
		UPDATE APP_CompanyEntities
		SET companyId = CC.companyId,
			created = @nowTime
		FROM #clientCompanyMap CC
		WHERE (entityType = 3) AND (entityId = CC.id) AND (APP_CompanyEntities.companyId = 0) AND (modified = 0) AND (CC.companyId <> 0)
		-- Insert entries that are new.
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT CC.id,
'Installation Company ID',
				   7,
				   CC.companyId,
				   @nowTime,
				   0
			FROM #clientCompanyMap CC
				LEFT OUTER JOIN APP_ClientProp ACP
ON (ACP.componentNameId = CC.id) AND (ACP.attrName = 'Installation Company ID') AND (ACP.modified = 0)
			WHERE (ACP.componentNameID IS NULL)
		INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)
SELECT 3, CC.id, CC.companyId, @nowTime
			FROM #clientCompanyMap CC
				LEFT OUTER JOIN APP_CompanyEntities ACE
					ON (ACE.entityType = 3) AND (ACE.entityId = CC.id)
			WHERE (CC.companyId <> 0) AND (ACE.entityType IS NULL)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	   SET @o_errorCode = 1
	   SET @o_errorString = 'Failed to set installation company Id property.'
	END CATCH
END			-- Main IF. If clients without property is set and Global param is not set.
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetInstallationCompanyId')
	delete from GxQscripts where name = 'AppSetInstallationCompanyId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetInstallationCompanyId')
	delete from GXDBVersions where aliasname = 'AppSetInstallationCompanyId'
GO

insert into GXDBVersions values(2, 'AppSetInstallationCompanyId',  '00000000000000000000', 'AppSetInstallationCompanyId', '00000000000000000000')
GO

