

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIndexingV2Property.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015 Commvault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetIndexingV2Property.sp,v $ $Id: AppSetIndexingV2Property.sp,v 1.1.4.3 2020/10/08 15:50:29 mmansano Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetIndexingV2Property')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIndexingV2Property <<<'
	drop procedure AppSetIndexingV2Property
END
IF EXISTS (select * from GxQscripts where name='AppSetIndexingV2Property')
	delete from GxQscripts where name = 'AppSetIndexingV2Property'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIndexingV2Property')
	delete from GXDBVersions where aliasname = 'AppSetIndexingV2Property'
GO
print '... Creating Procedure: AppSetIndexingV2Property'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetIndexingV2Property
  @xmlText XML
AS
SET NOCOUNT ON
--
DECLARE @o_xmlText XML;
--
DECLARE @appId int = (SELECT TOP(1) A.id
	FROM APP_Application A WITH (NOLOCK)
	WHERE A.id = (SELECT @xmlText.value('(/Indexing_SetIndexingVersionReq/@appId)[1]', 'int')));
--
DECLARE @clientId int = (SELECT TOP(1) C.id
	FROM APP_Client C WITH (NOLOCK)
	WHERE C.id = (SELECT @xmlText.value('(/Indexing_SetIndexingVersionReq/@clientId)[1]', 'int')));
--
DECLARE @backupsetId int = (SELECT TOP(1) B.id
	FROM APP_BackupSetName B WITH (NOLOCK)
	WHERE B.id = (SELECT @xmlText.value('(/Indexing_SetIndexingVersionReq/@backupsetId)[1]', 'int')));
DECLARE @appTypeOverride int = @xmlText.value('(/Indexing_SetIndexingVersionReq/@appTypeOverride)[1]', 'int');
DECLARE @errorCode int = 0;
DECLARE @errorString nvarchar(max) = '';
--
IF @appTypeOverride IS NULL OR @appTypeOverride = 0
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Invalid arguments: AppType is not passed in input xml';
	GOTO ARGS_ERROR;
END
IF @appId IS NOT NULL
	SELECT @clientId = A.clientId FROM APP_Application A WITH (NOLOCK) WHERE A.id = @appId;
ELSE IF @backupsetId IS NOT NULL
	SELECT @clientId = A.clientId, @appId = A.id FROM APP_Application A WITH (NOLOCK) INNER JOIN APP_BackupSetName B ON A.backupSet = B.id WHERE B.id = @backupsetId;
ELSE
BEGIN
	SET @errorCode = 1;
	SET @errorString = 'Invalid arguments: AppId or BackupSet Id should be passed in the input xml';
	GOTO ARGS_ERROR;
END
-- Get the IndexingAppType from input CvAppType
DECLARE @idxAppType int
BEGIN
	EXEC appgetindexingapptype @appTypeOverride, @appId, @idxAppType OUTPUT, @errorCode OUTPUT
	IF @errorCode IS NOT NULL AND @errorCode <> 0
	BEGIN
		SET @errorString = 'Failed to do IdxAppType conversion.';
		GOTO ARGS_ERROR;
	END
END
--
DECLARE @indexingV2AttrName nvarchar(512) = dbo.GetIndexingV2PropNameByAppType(@idxAppType);
IF EXISTS (SELECT 1 FROM APP_Client C WITH (NOLOCK)	WHERE C.id = @clientId AND C.releaseId >= 16)
BEGIN
	IF NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName AND modified=0)
        INSERT INTO APP_ClientProp SELECT @clientId, @indexingV2AttrName, 2, '1',
		  dbo.GetUnixTime(GETUTCDATE()), 0, 0 FROM app_client WHERE id=@clientId AND NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WHERE CP.attrName = @indexingV2AttrName AND CP.componentNameId = @clientId and modified=0)
	ELSE IF NOT EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName AND attrVal = '1' AND modified=0)
		UPDATE APP_ClientProp SET attrVal = '1', created = dbo.GetUnixTime(GETUTCDATE()) WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName AND modified=0;
	-- Set bitmask enabled v2
	EXEC dbo.UpdateIdxV2AppTypesBitmask @clientId
	if @indexingV2AttrName = 'IndexingV2' AND EXISTS (SELECT 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName = @indexingV2AttrName AND attrVal = '1' and modified=0)
	BEGIN
		DECLARE @m_xmlText XML
		SET @m_xmlText =    (SELECT
								(SELECT @clientId AS '@clientId'
									FOR XML PATH('client'), TYPE)
							FOR XML PATH('App_UpgradeRetentionPropertiesReq'), TYPE )
		CREATE TABLE #tempTable1(xmlText XML)
		INSERT into #tempTable1
			exec dbo.AppUpgradeRetentionProperties @m_xmlText
		DROP TABLE #tempTable1
	END
END
ARGS_ERROR:
SET @o_xmlText =
	(SELECT @errorCode AS '@errorCode',
		@errorString AS '@errorString'
	FOR XML PATH('Indexing_SetIndexingVersionResp'), TYPE);
SELECT @o_xmlText;
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIndexingV2Property')
	delete from GxQscripts where name = 'AppSetIndexingV2Property'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIndexingV2Property')
	delete from GXDBVersions where aliasname = 'AppSetIndexingV2Property'
GO

insert into GXDBVersions values(2, 'AppSetIndexingV2Property',  '00010001000400030000', 'AppSetIndexingV2Property', '00010001000400030000')
GO

