

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxSrvrMigration.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetIdxSrvrMigration <<<'

IF EXISTS (select * from sysobjects where name='AppSetIdxSrvrMigration')
	drop procedure AppSetIdxSrvrMigration
IF EXISTS (select * from GxQscripts where name='AppSetIdxSrvrMigration')
	delete from GxQscripts where name = 'AppSetIdxSrvrMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxSrvrMigration')
	delete from GXDBVersions where aliasname = 'AppSetIdxSrvrMigration'
GO
print '... Creating Procedure: AppSetIdxSrvrMigration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetIdxSrvrMigration
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @curtime INT = DBO.GetUnixTime(getdate())
DECLARE @bsGuid nvarchar(max) = @xmlText.value('(/App_SetIdxServerMigration/@backupSetGuid)[1]', 'nvarchar(max)')
DECLARE @srcClname nvarchar(max) = @xmlText.value('(/App_SetIdxServerMigration/@srcClientName)[1]', 'nvarchar(max)')
DECLARE @dstClname nvarchar(max) = @xmlText.value('(/App_SetIdxServerMigration/@dstClientName)[1]', 'nvarchar(max)')
DECLARE @jobId BIGINT = @xmlText.value('(/App_SetIdxServerMigration/@jobId)[1]', 'BIGINT')
DECLARE @srcClId int = (SELECT id FROM APP_Client WHERE name = @srcClName)
DECLARE @dstClId int = (SELECT id FROM APP_Client WHERE name = @dstClName)
DECLARE @idxId int = (SELECT id FROM App_IndexDBInfo WHERE backupSetGUID = @bsGuid)
IF @srcClId IS NOT NULL AND @dstClId IS NOT NULL AND @idxId IS NOT NULL
BEGIN
	IF EXISTS (SELECT * FROM IdxServerMigrations WHERE indexId = @idxId AND fromClientId = @srcClId AND toClientId = @dstClId AND isMigrated = 0)
	BEGIN
		UPDATE IdxServerMigrations
		SET isMigrated = 1, jobId = @jobId, endTime = @curtime
		WHERE indexId = @idxId AND fromClientId = @srcClId AND toClientId = @dstClId AND isMigrated = 0
	END
	ELSE
	BEGIN
		INSERT INTO IdxServerMigrations(indexId, fromClientId, toClientId, isMigrated, jobId, endTime)
		VALUES (@idxId, @srcClId, @dstClId, 1, @jobId, @curtime)
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxSrvrMigration')
	delete from GxQscripts where name = 'AppSetIdxSrvrMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxSrvrMigration')
	delete from GXDBVersions where aliasname = 'AppSetIdxSrvrMigration'
GO

insert into GXDBVersions values(2, 'AppSetIdxSrvrMigration',  '00000000000000000000', 'AppSetIdxSrvrMigration', '00000000000000000000')
GO

