

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxSrvrForDBReq.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetIdxSrvrForDBReq')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIdxSrvrForDBReq <<<'
	drop procedure AppSetIdxSrvrForDBReq
END
IF EXISTS (select * from GxQscripts where name='AppSetIdxSrvrForDBReq')
	delete from GxQscripts where name = 'AppSetIdxSrvrForDBReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxSrvrForDBReq')
	delete from GXDBVersions where aliasname = 'AppSetIdxSrvrForDBReq'
GO
print '... Creating Procedure: AppSetIdxSrvrForDBReq'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetIdxSrvrForDBReq
  @xmlText XML OUTPUT
AS
DECLARE @outXml XML
DECLARE @dbGuid nvarchar(max) =  @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/@dbGuid)[1]', 'nvarchar(max)')
DECLARE @bsGuid nvarchar(max) = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/@backupSetGuid)[1]', 'nvarchar(max)')
DECLARE @clname nvarchar(max) = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/indexServer/@clientName)[1]', 'nvarchar(max)')
DECLARE @type int = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/@appType)[1]', 'integer')
DECLARE @bsId int
DECLARE @errString	NVARCHAR(MAX)=N''
DECLARE @errCode		INT = 0
DECLARE @engineType INT = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProps/indexServer/@idxDbEngineType)[1]', 'integer')
DECLARE @idxSrvrClId INT
DECLARE @pseudoISClientId INT
DECLARE @solrServerType INT = 1 -- Standalone
DECLARE @forceSwitch BIT = @xmlText.value('(/App_SetIdxSrvrForDbReq/@forceSwitch)[1]', 'BIT')
DECLARE @userBrowse BIT = @xmlText.value('(/App_SetIdxSrvrForDbReq/@userBrowse)[1]', 'BIT')
DECLARE @idxAppType INT = @type
DECLARE @jobId BIGINT = ISNULL(@xmlText.value('(/App_SetIdxSrvrForDbReq/@jobId)[1]', 'BIGINT'), -1) -- For logging migration in IdxServerMigrations
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
IF OBJECT_ID('tempdb.dbo.#tmpIdxSrvListXML') IS NOT NULL     DROP TABLE #tmpIdxSrvListXML
IF OBJECT_ID('tempdb.dbo.#tmpIdxSrvList') IS NOT NULL     DROP TABLE #tmpIdxSrvList
CREATE TABLE #getIndexServers
					(     serverURL NVARCHAR(512),
							clientId INT,
							clientName NVARCHAR(256),
							cloudId INT,
							hostName NVARCHAR(256),
							basePort INT,
							engineName  NVARCHAR(256),
							serverType INT,
							indexServerClientId INT,
							internalCloudName NVARCHAR(256)
					)
IF ( @dbGuid='' or @dbGuid is null or @bsGuid='' or @bsGuid is null)
BEGIN
	SET @errCode = 1
	SET @errString = 'Either DbGuid or bsGuid is null'
	SET @outXml = (
		select   @errCode as '@errorCode', @errString as '@errorString'
	 FOR XML PATH('App_SetIdxSrvrForDbResp'), type)
	GOTO CX_EXIT
END
IF @type = 137
BEGIN
	EXEC GetSetIdxSrvrForExchOnePassApp @bsGuid, @dbGuid,@clname,@type,@idxAppType,@outXml OUTPUT
	GOTO CX_EXIT
END
SELECT @bsId = BS.id from APP_BackupSetName as BS WITH(NOLOCK) where BS.GUID = @bsGuid
--Get Indexing AppType
DECLARE @errorCode INT = 0
DECLARE @appId INT = 0
DECLARE @subclientIndexEnabled INT = dbo.isSubClientIndexEnabled(@bsId)
-- let's try to make sure the caller has set dbname as expected
IF @subclientIndexEnabled = 1
BEGIN
	IF @bsGuid = @dbGuid AND NOT EXISTS (SELECT 1 FROM App_Application APP WITH(NOLOCK) WHERE APP.backupset = @bsId AND APP.GUID = @dbGuid)
	BEGIN
		SET @errCode = 1
		SET @errString = 'Subclient Index On but dbname is not set to correct subclientguid'
		SET @outXml = (
			select   @errCode as '@errorCode', @errString as '@errorString'
			FOR XML PATH('App_SetIdxSrvrForDbResp'), type)
		GOTO CX_EXIT
	END
END
SELECT TOP 1 @appId = App.id from App_Application App WITH(NOLOCK) WHERE App.backupset = @bsId AND (@subclientIndexEnabled = 0 OR App.GUID = @dbGuid)
IF @type IS NULL OR @type = 0
	SELECT TOP 1 @type = appTypeId from App_Application App WITH(NOLOCK) WHERE id = @appId
EXEC AppGetIndexingAppType @type, @appId, @idxAppType OUT, @errorCode OUT
IF @engineType IS NULL
BEGIN
	DECLARE @srcClientId INT = 0
	DECLARE @isCaseClient INT = 0
	DECLARE @isCloudLaptop INT = 0
	IF EXISTS (SELECT 1 FROM APP_SubClientProp SCP WITH(NOLOCK)
				INNER JOIN APP_Application APP WITH(NOLOCK) ON SCP.componentNameId = APP.id
				WHERE SCP.attrName = 'Cloud Mode Enabled' AND SCP.attrVal = N'1' AND SCP.modified = 0 AND APP.backupset = @bsId)
		SET @isCloudLaptop = 1
	SELECT TOP(1) @srcClientId = clientId from APP_Application WITH(NOLOCK) WHERE backupSet = (
	SELECT id from APP_BackupSetName WITH(NOLOCK) where GUID = @bsGuid)
IF (EXISTS (SELECT 1 FROM app_clientProp WITH(NOLOCK) where componentNameId = @srcClientId AND attrName = 'Case Manager Pseudo Client' AND attrVal = N'1' and modified = 0)  AND (@idxAppType IN ( 33, 29)))
	SET @isCaseClient = 1
IF ((@isCloudLaptop = 1) OR @idxAppType IN (200115, 78, 139, 200118,200127, 200128) OR (@isCaseClient = 1 ))
	BEGIN
		SET @engineType = 2
	END
	ELSE
		SET @engineType = 1/*CTREE*/
END
IF @engineType = 1
BEGIN
	--primary server
	Exec dbo.GetSetClassicIdxSrvrForDb @bsGuid, @dbGuid,@clname,@type,@idxAppType,@forceSwitch, 0, 1,@userBrowse, @jobId, @idxSrvrClId OUTPUT
	-- secondary copy server
	DECLARE @secondaryCopyId INT = 0
	SELECT TOP(1) @secondaryCopyId =CAST(CP1.attrVal AS INT) FROM APP_ClientProp CP1 WITH(NOLOCK)
			INNER JOIN APP_ClientProp CP2 WITH(NOLOCK)  ON CP1.componentNameId = CP2.componentNameId
			INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON AGC.id = CAST(CP1.attrVal AS INT)
			INNER JOIN APP_Application AP  WITH(NOLOCK) ON CP2.attrVal  =  CAST(AP.dataArchGrpID AS nvarchar)
			WHERE CP1.attrName like 'Index Server Secondary CopyId' AND CP2.attrName like 'Index Server ArchGroup Id'
			AND CP1.modified = 0 AND CP2.modified = 0 AND  AP.backupSet = @bsId AND (@subclientIndexEnabled = 0 OR AP.id = @appId)
			ORDER BY AP.id
	IF @secondaryCopyId <> 0
	BEGIN
		DECLARE @secondaryIdxSrvr INT = 0
		Exec dbo.GetSetClassicIdxSrvrForDb @bsGuid, @dbGuid,@clname,@type,@idxAppType,@forceSwitch, @secondaryCopyId, 0,userBrowse, @jobId, @secondaryIdxSrvr OUTPUT
	END
	ELSE
	BEGIN
		-- remove any secondary copy server entry of DB if present.
	   DELETE FROM App_IndexDBInfo where dbName = @dbGuid AND backupSetGUID = @bsGuid AND idxDbEngineType=1 AND isPrimary=0
	END
END
ELSE
BEGIN
	Exec dbo.GetSetDynamicIdxSrvrForDb @bsGuid, @dbGuid,@clname,@type,@idxAppType,@idxSrvrClId OUTPUT
END
-- get the physical client id in case of solr engine.
DECLARE @idxSrvrCloudName NVARCHAR(256)
DECLARE @cloudId INT
IF @engineType = 2
BEGIN
	DECLARE @roleName NVARCHAR(256)
IF(@idxAppType = 200115)
		SET @roleName = 'Cloud PaaS Index'
ELSE IF(@idxAppType = 78)
		SET @roleName = ''
ELSE IF(@idxAppType = 139 OR @idxAppType = 200127 OR @idxAppType = 200128)
		SET @roleName = '' -- we dont want to use roleName to get the index servers as role will be added during collection creation only
ELSE IF(@idxAppType = 200118)
		SET @roleName = ''
	ELSE IF (@isCaseClient = 1) -- If it's a case manager client, we don't want to use roleName to get the index servers
		SET @roleName = ''
	ELSE
		SET @roleName = 'FileSystem Index'
	EXEC DM2GetIndexServers @roleName, @idxSrvrClId
	SELECT TOP 1 @idxSrvrClId = clientId, @idxSrvrCloudName = internalCloudName,@cloudId = cloudId, @pseudoISClientId = indexServerClientId FROM #getIndexServers
	DELETE FROM #getIndexServers
END
DECLARE @primarySrvrXml XML = (
		select CL.name as '@clientName' , CL.net_hostname as '@hostName', CL.cvdPort as '@cvdPort', CL.evmgrcPort as '@evmgrcPort', IDP.idxDbEngineType as '@idxDbEngineType',
CASE WHEN (MmHostSoftState < 1 OR MmHostEnabled < 1 OR ((Attribute & 16) = 16)) THEN 1 ELSE 0 END as '@isOffline', MMHost.OfflineReason as '@offlineReason',
		CASE WHEN ((Attribute & 32768) = 32768) THEN 1 ELSE 0 END AS '@isPowerManagedVM',CL.id as '@clientId', @idxSrvrCloudName as '@cloudName', @pseudoISClientId as '@pseudoClientId', @cloudId as '@cloudId'
		from  App_client as CL WITH(NOLOCK) , App_IndexDBInfo AS IDP  WITH(NOLOCK), MMHost WITH(NOLOCK) WHERE CL.id = @idxSrvrClId AND IDP.dbName = @dbGuid AND IDP.backupSetGuid = @bsGuid AND IDP.isPrimary = 1 AND MMHost.ClientId = @idxSrvrClId
		FOR XML PATH ('idxSrvrClientInfos'), type)
-- Populate secondary index servers.
DECLARE @secondaryIdxServers TABLE (clientId int, engineType int, cloudName NVARCHAR(256), pseudoClientId INT, cloudId INT)
DECLARE @secondaryIdxServersCur CURSOR
DECLARE @secondarySrvrEngineType INT
DECLARE @secondarySrvrPseudoClientId INT
SET  @secondaryIdxServersCur = CURSOR FOR SELECT currentIdxServer, idxDbEngineType FROM  App_IndexDBInfo AS IDP WITH(NOLOCK)
									WHERE IDP.dbName = @dbGuid AND IDP.backupSetGuid = @bsGuid AND IDP.isPrimary = 0
OPEN @secondaryIdxServersCur
FETCH NEXT FROM @secondaryIdxServersCur INTO @secondarySrvrPseudoClientId, @secondarySrvrEngineType
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @secondarySrvrCloudName NVARCHAR(256)
	IF @secondarySrvrEngineType = 2  -- get the physical client id in case of solr engine.
	BEGIN
		EXEC DM2GetIndexServers 'FileSystem Index', @secondarySrvrPseudoClientId
		INSERT INTO @secondaryIdxServers
		SELECT TOP 1 clientId, @secondarySrvrEngineType, internalCloudName, @secondarySrvrPseudoClientId, cloudId  FROM #getIndexServers
		DELETE FROM #getIndexServers
	END
	FETCH NEXT FROM @secondaryIdxServersCur INTO @secondarySrvrPseudoClientId, @secondarySrvrEngineType
END
CLOSE @secondaryIdxServersCur
DEALLOCATE @secondaryIdxServersCur
DECLARE @secondarySrvrXml XML = (
	select CL.name as '@clientName' , CL.net_hostname as '@hostName', CL.cvdPort as '@cvdPort', CL.evmgrcPort as '@evmgrcPort', SIS.engineType as '@idxDbEngineType',
CASE WHEN (MmHostSoftState < 1 OR MmHostEnabled < 1 OR ((Attribute & 16) = 16)) THEN 1 ELSE 0 END as '@isOffline', MMHost.OfflineReason as '@offlineReason',
CASE WHEN ((Attribute & 32768) = 32768) THEN 1 ELSE 0 END AS '@isPowerManagedVM',CL.id as '@clientId', SIS.cloudName as '@cloudName', SIS.pseudoClientId as '@pseudoClientId', SIS.cloudId as '@cloudId'
	from  App_client as CL WITH(NOLOCK) , @secondaryIdxServers AS SIS, MMHost WITH(NOLOCK) WHERE CL.id = SIS.clientId AND MMHost.ClientId = SIS.clientId
	FOR XML PATH ('idxSrvrClientInfos'), type)
SET @outXml  = (
	SELECT @primarySrvrXml, @secondarySrvrXml
	FOR XML PATH('App_SetIdxSrvrForDbResp'), TYPE)
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
select @xmlText = @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxSrvrForDBReq')
	delete from GxQscripts where name = 'AppSetIdxSrvrForDBReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxSrvrForDBReq')
	delete from GXDBVersions where aliasname = 'AppSetIdxSrvrForDBReq'
GO

insert into GXDBVersions values(2, 'AppSetIdxSrvrForDBReq',  '00000000000000000000', 'AppSetIdxSrvrForDBReq', '00000000000000000000')
GO

