

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxServerLoadMetrics.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetIdxServerLoadMetrics')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIdxServerLoadMetrics <<<'
	drop procedure AppSetIdxServerLoadMetrics
END
IF EXISTS (select * from GxQscripts where name='AppSetIdxServerLoadMetrics')
	delete from GxQscripts where name = 'AppSetIdxServerLoadMetrics'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxServerLoadMetrics')
	delete from GXDBVersions where aliasname = 'AppSetIdxServerLoadMetrics'
GO
print '... Creating Procedure: AppSetIdxServerLoadMetrics'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetIdxServerLoadMetrics
  @xmlText XML
AS
DECLARE @curtime INT = DBO.GetUnixTime(getdate())
DECLARE @clname NVARCHAR(max) = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@clientName)[1]', 'NVARCHAR(max)')
DECLARE @capacity FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@capacity)[1]', ' FLOAT')
DECLARE @load FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@load)[1]', ' FLOAT')
DECLARE @avgHistLoad FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@avgHistory)[1]', 'FLOAT')
DECLARE @avgPredLoad FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@avgPredicted)[1]', 'FLOAT')
DECLARE @classification FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@classification)[1]', ' INT')
DECLARE @trend FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@trend)[1]', ' FLOAT')
DECLARE @k FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@k)[1]', ' FLOAT')
DECLARE @predictedCapacity FLOAT = @xmlText.value('(/Indexing_SetIdxServerLoadMetrics/@predictedCapacity)[1]', ' FLOAT')
DECLARE @diskSize BIGINT = @xmlText.value('(Indexing_SetIdxServerLoadMetrics/@totalDiskMB)[1]', 'BIGINT')
DECLARE @freeSize BIGINT = @xmlText.value('(Indexing_SetIdxServerLoadMetrics/@freeDiskMB)[1]', 'BIGINT')
DECLARE @clId INT = (SELECT id FROM app_client(NOLOCK) WHERE name = @clname)
DECLARE @assignCount INT = 0 -- Always zero the assign count to reset the round robin index server distribution
IF NOT EXISTS (SELECT * FROM IdxServerLoad WHERE clientId = @clId)
BEGIN
	-- Delete if there is any other entry.
	DELETE FROM IdxServerLoad WHERE clientId = @clId
	INSERT INTO IdxServerLoad (clientId, capacity, load, averageHistoryLoad, averagePredictLoad, classification, trend, k, predictedCapacity, diskSizeMB, freeSizeMB, entryTime, assignCount)
		VALUES (@clId, @capacity, @load, @avgHistLoad, @avgPredLoad, @classification, @trend, @k, @predictedCapacity, @diskSize, @freeSize, @curtime, @assignCount)
END
ELSE
BEGIN
	UPDATE IdxServerLoad
	SET capacity = @capacity,
		load = @load,
		averageHistoryLoad = @avgHistLoad,
		averagePredictLoad = @avgPredLoad,
		classification = @classification,
		trend = @trend,
		k = @k,
		predictedCapacity = @predictedCapacity,
		diskSizeMB = @diskSize,
		freeSizeMB = @freeSize,
		entryTime = @curtime,
		assignCount = @assignCount
		WHERE clientId = @clId
END
DECLARE @outXml XML = '<Common_Ack errorCode="0"/>'
SELECT @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxServerLoadMetrics')
	delete from GxQscripts where name = 'AppSetIdxServerLoadMetrics'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxServerLoadMetrics')
	delete from GXDBVersions where aliasname = 'AppSetIdxServerLoadMetrics'
GO

insert into GXDBVersions values(2, 'AppSetIdxServerLoadMetrics',  '00000000000000000000', 'AppSetIdxServerLoadMetrics', '00000000000000000000')
GO

