

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxServer.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetIdxServer')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIdxServer <<<'
	drop procedure AppSetIdxServer
END
IF EXISTS (select * from GxQscripts where name='AppSetIdxServer')
	delete from GxQscripts where name = 'AppSetIdxServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxServer')
	delete from GXDBVersions where aliasname = 'AppSetIdxServer'
GO
print '... Creating Procedure: AppSetIdxServer'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetIdxServer
  @xmlText XML
AS
  DECLARE @outXml XML
DECLARE @dbGuid nvarchar(max) =  @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/@dbGuid)[1]', 'nvarchar(max)')
DECLARE @bsGuid nvarchar(max) = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/@backupSetGuid)[1]', 'nvarchar(max)')
DECLARE @clname nvarchar(max) = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/indexServer/@clientName)[1]', 'nvarchar(max)')
DECLARE @type int = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/@appType)[1]', 'integer')
DECLARE @engineType INT = @xmlText.value('(/App_SetIdxSrvrForDbReq/idxDbProp/indexServer/@idxDbEngineType)[1]', 'integer')
DECLARE @clId int
DECLARE @indexServerClientId int
DECLARE @indexServerPhysicalClientId INT = 0
DECLARE @bsId int
DECLARE @errString	NVARCHAR(MAX)=N''
DECLARE @errCode		INT = 0
DECLARE @oldIndexServer INT = 0
DECLARE @workQueueXML	XML
DECLARE @workTokenParams	NVARCHAR(MAX) = ''
DECLARE @localeId  INT = ISNULL(@xmlText.value('(App_SetIdxSrvrForDbReq/processinginstructioninfo/locale)[1]', 'integer'), 0)
DECLARE @solrServerType INT = 1 -- Standalone
IF ( @dbGuid='' or @dbGuid is null or @bsGuid='' or @bsGuid is null or @clname='' or @clname is null or @engineType is null)
BEGIN
	SET @errCode = 1
	SET @errString = 'Either DbGuid or bsGuid or clientName or engineType is null'
	GOTO CX_EXIT
END
select @clId = id from app_client(NOLOCK) where name = @clname
select @bsId = BS.id from APP_BackupSetName(NOLOCK) as BS where BS.GUID = @bsGuid
DECLARE @idxServerChanged INT = 0
DECLARE @oldIdxServerName NVARCHAR(1024)
SELECT @oldIdxServerName = name FROM App_IndexDBInfo A WITH (NOLOCK) JOIN APP_Client B WITH (NOLOCK) ON a.currentIdxServer = B.id
WHERE dbName=@dbGuid and backupSetGUID=@bsGuid
IF(@engineType = 2/*LUCENE*/)
BEGIN
	SET @solrServerType = (SELECT cloudType FROM Dm2Cloud WITH(NOLOCK) WHERE pseudoClientId = @clId)
	SET @indexServerClientId = (SELECT TOP 1 core.ClientId FROM Dm2Cloud c, DM2SearchServerCoreInfo core WHERE c.pseudoClientId = @clId AND c.cloudId = core.CloudId
								AND c.CloudType = core.CloudType AND C.CloudType IN (1,4,5))
	SET @indexServerPhysicalClientId = @indexServerClientId
	IF @solrServerType IN (4,5) OR
@type = 139 OR
@type = 200127 OR -- populate the Pseudo clientId.
@type = 200128 OR -- populate the Pseudo clientId.
@type = 200118 OR
@type = 78 	OR
@type = 33  OR
@type = 29
		SET @indexServerClientId = @clId
	IF(@indexServerClientId IS NULL)
	BEGIN
SET @errCode =	(3332 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errCode, 0, 2)
		GOTO CX_EXIT
	END
	IF NOT EXISTS (select * from App_IndexDBInfo where dbName = @dbGuid and backupSetGuid = @bsGuid and currentIdxServer = @indexServerClientId)
	BEGIN
		SET @idxServerChanged = 1
		-- Delete if there is any other entry.
		delete from App_IndexDBInfo where dbName=@dbGuid and backupSetGUID=@bsGuid and idxDbEngineType = @engineType
		insert into App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
			SELECT @dbGuid, @type,  @engineType, @bsId, @indexServerClientId, @bsGuid, NULL, 1, 0 WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @dbGuid and backupSetGuid = @bsGuid AND isPrimary = 1)
		IF( 0 <> @@ERROR)
		BEGIN
SET @errCode = (3324 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errCode, 0, 2)
			GOTO CX_EXIT
		END
		IF EXISTS(SELECT top 1 jobId FROM JMBkpStats(NOLOCK) bkpStats, App_Application(NOLOCK) sc WHERE bkpStats.appId = sc.id AND sc.backupSet = @bsId)
		BEGIN
			-- Submit index reconstruction request for backedup subclient only.
			SET @workQueueXML =
								(
									SELECT 1 AS '@status',
									(
										SELECT @type AS '@appType',
										@engineType AS '@idxDbEngineType',
										@bsGuid AS '@backupSetGUID',
										(
											SELECT id AS '@subclientId',
											GUID AS '@subclientGUID' FROM App_Application WHERE backupSet = @bsId FOR XML PATH('subclient'), TYPE
										),
										(
											SELECT @bsGuid AS '@DbIdentifer' FOR XML PATH('dbInfo'), TYPE
										)
										FOR XML PATH('info'), TYPE
									)
									FOR XML PATH('Indexing_LuceneIndexServerReq'), TYPE
								)
			SET @workTokenParams = CAST(@workQueueXML AS NVARCHAR(MAX))
			-- WorkQueue request for the new IndexServer to add the LuceneIndexServer registry key.
			EXEC AppWorkQueueSubmitRequest 23 /*WORK_TOKEN_LUCENE_INDEX_SERVER*/, 0, 0, @indexServerPhysicalClientId, 0, @workTokenParams
		END
	END
END
ELSE
IF NOT EXISTS (select * from App_IndexDBInfo where dbName = @dbGuid and backupSetGuid = @bsGuid and currentIdxServer = @clId)
BEGIN
	SET @idxServerChanged = 1
	SET @oldIndexServer = ISNULL((SELECT top 1 currentIdxServer FROM APP_IndexDBInfo WHERE backupSetGUID=@bsGuid and idxDbEngineType = @engineType), 0)
	-- Delete if there is any other entry.
	delete from App_IndexDBInfo where dbName=@dbGuid and backupSetGUID=@bsGuid and idxDbEngineType = @engineType
	insert into App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
			SELECT @dbGuid, @type,  @engineType, @bsId, @clId, @bsGuid, NULL, 1, 0 WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @dbGuid and backupSetGuid = @bsGuid AND isPrimary = 1)
	SET @outXml = (
		select(
			select CL.name as '@clientName' , CL.net_hostname as '@hostName', CL.cvdPort as '@cvdPort', CL.evmgrcPort as '@evmgrcPort', IDP.idxDbEngineType as '@idxDbEngineType'
			from  App_client as CL WITH(NOLOCK) , App_IndexDBInfo AS IDP WHERE CL.id = IDP.currentIdxServer AND IDP.dbName = @dbGuid AND IDP.backupSetGuid = @bsGuid AND IDP.idxDbEngineType = @engineType
			FOR XML PATH ('idxSrvrClientInfos'), type
		) FOR XML PATH('App_SetIdxSrvrForDbResp'), type)
END
-- For creating exchange client do not audit indexserver name change. Since it is causing lock timeout while
-- auditing task schedules on client being created. Correct fix is to pass transaction object to module
-- which audits task schedules. Madhu is working on to fix this in SP15.
-- Please remove below check once Madhu's changes are in.
IF(@type = 137 AND (@oldIdxServerName = '' OR @oldIdxServerName IS NULL))
	SET @idxServerChanged = 0
IF @idxServerChanged = 1
BEGIN
	DECLARE @dbId INT = (SELECT id FROM App_IndexDBInfo WITH(NOLOCK) WHERE dbName = @dbGuid AND backupSetGUID = @bsGuid AND idxDbEngineType = @engineType)
	IF @dbId IS NOT NULL
		INSERT INTO IdxServerMigrations(indexId, fromClientId, toClientId, isMigrated, jobId, startTime, endTime, reason)
VALUES (@dbId, @oldIndexServer, @clId, 1, -1, dbo.GetUnixTime(GETUTCDATE()), dbo.GetUnixTime(GETUTCDATE()), 2)
	EXEC AppAuditIdxServerChange @oldIdxServerName, @clname
END
CX_EXIT:
IF(0 <> @errCode)
BEGIN
	SET @outXml = (
	select(
		select  '' as '@clientName', '' as '@hostName', '' as '@cvdPort', '' as '@evmgrcPort', @errCode as '@errorCode', @errString as '@errorString'
		FOR XML PATH ('idxSrvrClientInfos'), type
	) FOR XML PATH('App_SetIdxSrvrForDbResp'), type)
END
select @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxServer')
	delete from GxQscripts where name = 'AppSetIdxServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxServer')
	delete from GXDBVersions where aliasname = 'AppSetIdxServer'
GO

insert into GXDBVersions values(2, 'AppSetIdxServer',  '00000000000000000000', 'AppSetIdxServer', '00000000000000000000')
GO

