

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxDbStatusForCheckPoint.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetIdxDbStatusForCheckPoint')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIdxDbStatusForCheckPoint <<<'
	drop procedure AppSetIdxDbStatusForCheckPoint
END
IF EXISTS (select * from GxQscripts where name='AppSetIdxDbStatusForCheckPoint')
	delete from GxQscripts where name = 'AppSetIdxDbStatusForCheckPoint'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxDbStatusForCheckPoint')
	delete from GXDBVersions where aliasname = 'AppSetIdxDbStatusForCheckPoint'
GO
print '... Creating Procedure: AppSetIdxDbStatusForCheckPoint'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetIdxDbStatusForCheckPoint
  @inxml XML
AS
DECLARE @curtime INT = DBO.GetUnixTime(getdate())
DECLARE @dbcount int = @inxml.value('count(/Indexing_SetIdxDbStatusForCheckPoint/dbs)','int')
while @dbcount > 0
BEGIN
	declare @indbxml xml = @inxml.query('(/Indexing_SetIdxDbStatusForCheckPoint/dbs)[sql:variable("@dbcount")]')
	SET @dbcount = @dbcount-1
	DECLARE @dbName VARCHAR(36) = @indbxml.value('(/dbs/@dbName)[1]','VARCHAR(36)')
	IF(LEN(@dbName) > 36)--We are checkpointing pruned db also so skip for those in this loop
		CONTINUE;
	DECLARE @dbId INT = ISNULL((select ID from App_IndexDBInfo WITH (NOLOCK) where dbName = @dbName AND idxDbEngineType = 1),0)
	DECLARE @errcode INT = @indbxml.value('(/dbs/@errorLvl)[1]','INT')
	DECLARE @errordesc varchar(2048) = @indbxml.value('(/dbs/@errorDesc)[1]','VARCHAR(2048)')
	DECLARE @orgdbxml XML = (select properties from IdxDbState WITH (NOLOCK) where dbId = @dbId)
	DECLARE @outdbxml XML = @orgdbxml
	IF(@orgdbxml IS NULL)
	BEGIN
		DECLARE @apps XML = @indbxml.query('(/dbs/apps)')
		SET @outdbxml = '<Indexing_DbStats/>'
		IF datalength(@apps) < 10
			SET @outdbxml.modify('insert sql:variable("@apps") into (/Indexing_DbStats)[1]')
	END
	ELSE
	BEGIN
		DECLARE @appcount int = @indbxml.value('count(/dbs/apps)','int')
		WHILE @appcount > 0
		BEGIN
			DECLARE @app xml = @indbxml.query('(/dbs/apps)[sql:variable("@appcount")]')
			DECLARE @appGUID varchar(36) = @app.value('(/apps/@appGUID)[1]','VARCHAR(36)')
			DECLARE @lastCheckpointedBkpJobId INT = @app.value('(/apps/@lastCheckpointedBkpJobId)[1]','INT')
			DECLARE @appGUID1 varchar(36) = (SELECT @outdbxml.value('(/Indexing_DbStats/apps[@appGUID=(sql:variable("@appGUID"))]/@appGUID)[1]','varchar(36)'))
			DECLARE @lastCheckpointedBkpJobIdOld varchar(36) = (SELECT @outdbxml.value('(/Indexing_DbStats/apps[@appGUID=(sql:variable("@appGUID"))]/@lastCheckpointedBkpJobId)[1]','varchar(36)'))
			IF @appGUID1 IS NULL
				SET @outdbxml.modify('insert sql:variable("@app") into (/Indexing_DbStats)[1]')
			ELSE
			BEGIN
				IF @lastCheckpointedBkpJobIdOld IS NULL
					SET @outdbxml.modify('insert attribute lastCheckpointedBkpJobId {sql:variable("@lastCheckpointedBkpJobId")} into (/Indexing_DbStats/apps[@appGUID=(sql:variable("@appGUID"))])[1]')
				ELSE
					SET @outdbxml.modify('replace value of (/Indexing_DbStats/apps[@appGUID=(sql:variable("@appGUID"))]/@lastCheckpointedBkpJobId)[1] with sql:variable("@lastCheckpointedBkpJobId")')
			END
			SET @appcount = @appcount -1
		END
		DECLARE @errcodeOld INT = (SELECT errorLvl from idxdbstate WITH (NOLOCK) where dbId = @dbId)
		IF @errcodeOld > @errcode
		BEGIN
			set @errCode = @errcodeOld
			set @errordesc = (SELECT errorDesc from idxdbstate WITH (NOLOCK) WHERE dbId = @dbId)
			-- No need to modify lastIdxErrorTime as its already set in @orgdbxml
		END
		ELSE IF @errcode IS NULL AND @errcodeOld > 0
		BEGIN
			set @errCode = 0
			set @errordesc = ''
			IF @orgdbxml.value('(/Indexing_DbStats/@lastIdxErrorTime)[1]','INT') IS NOT NULL
				SET @outdbxml.modify('delete (/Indexing_DbStats/@lastIdxErrorTime)[1]')
			IF @orgdbxml.value('(/Indexing_DbStats/@lastFailedPlaybackJobId)[1]','INT') IS NOT NULL
				SET @outdbxml.modify('delete (/Indexing_DbStats/@lastFailedPlaybackJobId)[1]')
		END
		ELSE IF @errcode > 0
		BEGIN
			IF @orgdbxml.value('(/Indexing_DbStats/@lastIdxErrorTime)[1]','INT') IS NULL
				SET @outdbxml.modify('insert attribute lastIdxErrorTime {sql:variable("@curtime")} into (/Indexing_DbStats)[1]')
		END
	END
	IF @orgdbxml IS NULL
		INSERT INTO IdxDbState(dbId, errorLvl, errorDesc, modified, properties) values (@dbId, @errcode, @errordesc, @curtime, @outdbxml)
	ELSE
		UPDATE IdxDbState SET errorlvl = @errcode, errorDesc = @errordesc, properties = @outdbxml, modified = @curtime where dbid = @dbId
	--Remove the flag once the checkpoint is done
UPDATE App_IndexDBInfo SET flags = flags & ~2 WHERE Id = @dbId
	SET @dbcount = @dbcount-1
END
-- Update pruned checkpoint details in App_IndexCheckpointInfo
EXEC UpdateCheckPointInfo @inxml
DECLARE @outXml XML = '<Common_Ack errorCode="0"/>'
select @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxDbStatusForCheckPoint')
	delete from GxQscripts where name = 'AppSetIdxDbStatusForCheckPoint'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxDbStatusForCheckPoint')
	delete from GXDBVersions where aliasname = 'AppSetIdxDbStatusForCheckPoint'
GO

insert into GXDBVersions values(2, 'AppSetIdxDbStatusForCheckPoint',  '00000000000000000000', 'AppSetIdxDbStatusForCheckPoint', '00000000000000000000')
GO

