

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxDbStatistics.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetIdxDbStatistics')
BEGIN
	print '>>> Drop Stored Procedure: AppSetIdxDbStatistics <<<'
	drop procedure AppSetIdxDbStatistics
END
IF EXISTS (select * from GxQscripts where name='AppSetIdxDbStatistics')
	delete from GxQscripts where name = 'AppSetIdxDbStatistics'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxDbStatistics')
	delete from GXDBVersions where aliasname = 'AppSetIdxDbStatistics'
GO
print '... Creating Procedure: AppSetIdxDbStatistics'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetIdxDbStatistics
  @inxml XML
AS
DECLARE @curtime INT = DBO.GetUnixTime(getdate())
DECLARE @idxSrvrId INT = (SELECT id from APP_Client WITH (NOLOCK) where name = @inxml.value('(/Indexing_SetIdxDbStatistics/@clientName)[1]','nvarchar(max)'))
IF object_id('tempdb.dbo.#input_dbstat') is not null
	DROP TABLE #input_dbstat
CREATE TABLE #input_dbstat ( tempdbid INT, dbName VARCHAR(40), dbSize BIGINT, logsSize BIGINT, reportsSize BIGINT, maintenanceSize BIGINT, lastCompactionTime BIGINT, idxDbEngineType INT)
INSERT INTO #input_dbstat
SELECT dbinfo.id,ISNULL(N.value(N'@dbName', 'VARCHAR(36)'),''),
N.value(N'@dbSize', N'BIGINT'),
N.value(N'@logsSize', N'BIGINT'),
N.value(N'@reportsSize', N'BIGINT'),
N.value(N'@maintenanceSize', N'BIGINT'),
N.value(N'@lastCompactionTime', N'BIGINT'),
ISNULL(N.value(N'@idxDbEngineType', N'INT'),0)
FROM @inxml.nodes(N'Indexing_SetIdxDbStatistics/dbs') AS T(N)
cross apply
App_IndexDBInfo dbinfo
where dbinfo.currentIdxServer = @idxSrvrId AND dbinfo.dbName = N.value(N'@dbName', N'VARCHAR(36)') AND N.value(N'@idxDbEngineType', N'INT') <> 0
IF object_id('tempdb.dbo.#original_dbstat') is not null
	DROP TABLE #original_dbstat
CREATE TABLE #original_dbstat ( tempdbid INT, creationId VARCHAR(40), apps xml, lastCompletedBkpTime BIGINT, lastPlayedBkpTime BIGINT, lastCheckPointBkpTime BIGINT,
	itemsAddedSinceCheckPoint BIGINT, itemsAddedThreadsholdForCheckpoint BIGINT, afilesAgedSinceCheckPoint BIGINT, afilesAgedThresholdForCompaction BIGINT,
	failedCheckPointAttempts  BIGINT, uptodateThresholdSecs BIGINT, daysThresholdForCheckpoint BIGINT, triggerCheckpoint INT, triggerCompaction INT,
	dbSize BIGINT, logsSize BIGINT, reportsSize BIGINT, maintenanceSize BIGINT, lastCompactionTime BIGINT, lastIdxErrorTime BIGINT, lastFailedPlaybackJobId BIGINT)
INSERT INTO #original_dbstat
select DS.dbid, T.N.value('@creationId', 'VARCHAR(40)'), T.N.query('./apps')
, T.N.value('@lastCompletedBkpTime','BIGINT') , T.N.value('@lastPlayedBkpTime','BIGINT'), T.N.value('@lastCheckPointBkpTime','BIGINT')
, T.N.value('@itemsAddedSinceCheckPoint','BIGINT'), T.N.value('@itemsAddedThreadsholdForCheckpoint','BIGINT'), T.N.value('@afilesAgedSinceCheckPoint','BIGINT')
, T.N.value('@afilesAgedThresholdForCompaction','BIGINT'), T.N.value('@failedCheckPointAttempts','BIGINT'), T.N.value('@uptodateThresholdSecs','BIGINT')
, T.N.value('@daysThresholdForCheckpoint','BIGINT'), T.N.value('@triggerCheckpoint','int'), T.N.value('@triggerCompaction','int')
, T.N.value('@dbSize','BIGINT'), T.N.value('@logsSize','BIGINT'), T.N.value('@reportsSize','BIGINT'), T.N.value('@maintenanceSize','BIGINT'), T.N.value('@lastCompactionTime','BIGINT'), T.N.value('@lastIdxErrorTime','BIGINT'), T.N.value('@lastFailedPlaybackJobId','BIGINT')
from IdxDbState DS JOIN #input_dbstat temp ON DS.dbId = temp.tempdbid
cross apply properties.nodes('(/Indexing_DbStats)') AS T(N)
MERGE IdxDbState AS T
USING (
SELECT temp.tempdbid, (
SELECT org.creationId AS '@creationId', org.lastCompletedBkpTime AS '@lastCompletedBkpTime'
, org.lastPlayedBkpTime AS '@lastPlayedBkpTime', org.lastCheckPointBkpTime AS '@lastCheckPointBkpTime'
, org.itemsAddedSinceCheckPoint AS '@itemsAddedSinceCheckPoint', org.itemsAddedThreadsholdForCheckpoint AS '@itemsAddedThreadsholdForCheckpoint'
, org.afilesAgedSinceCheckPoint AS '@afilesAgedSinceCheckPoint', org.afilesAgedThresholdForCompaction AS '@afilesAgedThresholdForCompaction'
, org.failedCheckPointAttempts AS '@failedCheckPointAttempts', org.uptodateThresholdSecs AS '@uptodateThresholdSecs'
, org.daysThresholdForCheckpoint AS '@daysThresholdForCheckpoint', org.triggerCheckpoint AS '@triggerCheckpoint'
, ISNULL(temp.dbSize, ISNULL(org.dbSize, 0)) AS '@dbSize', ISNULL(temp.reportsSize, ISNULL(org.reportsSize, 0)) AS '@reportsSize'
, ISNULL(temp.maintenanceSize, ISNULL(org.maintenanceSize, 0)) AS '@maintenanceSize'
, ISNULL(temp.logsSize, ISNULL(org.logsSize, 0)) AS '@logsSize'
, ISNULL(temp.lastCompactionTime, ISNULL(org.lastCompactionTime, 0)) as '@lastCompactionTime'
, ISNULL(org.lastIdxErrorTime, -1) as '@lastIdxErrorTime'
, ISNULL(org.lastFailedPlaybackJobId, 0) as '@lastFailedPlaybackJobId',
( SELECT org.apps )
FOR XML PATH('Indexing_DbStats')
) AS properties
FROM #input_dbstat temp LEFT JOIN #original_dbstat org ON temp.tempdbid = org.tempdbid
) AS S
ON T.dbid = S.tempdbid
WHEN MATCHED THEN
UPDATE SET T.properties = S.properties
WHEN NOT MATCHED BY TARGET THEN
INSERT (dbId, modified, properties)
VALUES(S.tempdbid, @curtime, S.properties)
;
IF object_id('tempdb.dbo.#input_dbstat') is not null
	DROP TABLE #input_dbstat
IF object_id('tempdb.dbo.#original_dbstat') is not null
	DROP TABLE #original_dbstat
DECLARE @outXml XML = '<Common_Ack errorCode="0"/>'
select @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxDbStatistics')
	delete from GxQscripts where name = 'AppSetIdxDbStatistics'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxDbStatistics')
	delete from GXDBVersions where aliasname = 'AppSetIdxDbStatistics'
GO

insert into GXDBVersions values(2, 'AppSetIdxDbStatistics',  '00000000000000000000', 'AppSetIdxDbStatistics', '00000000000000000000')
GO

