

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetIdxDBPropertyReq.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetIdxDBPropertyReq <<<'

IF EXISTS (select * from sysobjects where name='AppSetIdxDBPropertyReq')
	drop procedure AppSetIdxDBPropertyReq
IF EXISTS (select * from GxQscripts where name='AppSetIdxDBPropertyReq')
	delete from GxQscripts where name = 'AppSetIdxDBPropertyReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxDBPropertyReq')
	delete from GXDBVersions where aliasname = 'AppSetIdxDBPropertyReq'
GO
print '... Creating Procedure: AppSetIdxDBPropertyReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetIdxDBPropertyReq
  @xmlText XML
AS
DECLARE @outXml XML
DECLARE @dbGuid nvarchar(max) =  @xmlText.value('(/App_SetIdxDBPropertyReq/idxDbProps/@dbGuid)[1]', 'nvarchar(max)')
DECLARE @bsGuid nvarchar(max) = @xmlText.value('(/App_SetIdxDBPropertyReq/idxDbProps/@backupSetGuid)[1]', 'nvarchar(max)')
DECLARE @clname nvarchar(max) = @xmlText.value('(/App_SetIdxDBPropertyReq/idxDbProps/indexServer/@clientName)[1]', 'nvarchar(max)')
DECLARE @type int = @xmlText.value('(/App_SetIdxDBPropertyReq/idxDbProps/@appType)[1]', 'integer')
DECLARE @clId int
DECLARE @bsId int
DECLARE @errString	NVARCHAR(MAX)=N''
DECLARE @errCode		INT = 0
IF ( @dbGuid='' or @dbGuid is null or @bsGuid='' or @bsGuid is null or @clname='' or @clname is null)
BEGIN
	SET @errCode = 1
	SET @errString = 'Either DbGuid or bsGuid or clientName is null'
	SET @outXml = (
	select(
		select  '' as '@clientName', '' as '@hostName', '' as '@cvdPort', '' as '@evmgrcPort', @errCode as '@errorCode', @errString as '@errorString'
		FOR XML PATH ('idxSrvrInfo'), type
	) FOR XML PATH('App_SetIdxDBPropertyResp'), type)
	GOTO CX_EXIT
END
--if first insert or existing one is not valid anymore
IF NOT EXISTS (select * from App_IndexDBInfo where dbName = @dbGuid and backupSetGuid = @bsGuid)
   OR
   NOT EXISTS (select CL.name as '@clientName' , CL.net_hostname as '@hostName', CL.cvdPort as '@cvdPort', CL.evmgrcPort as '@evmgrcPort'
		from App_IndexDBInfo AS IDP inner join App_client as CL on CL.id = IDP.currentIdxServer where IDP.dbName = @dbGuid AND IDP.backupSetGuid = @bsGuid)
BEGIN
	DECLARE @oldIdxServerName NVARCHAR(1024)
	SELECT @oldIdxServerName = name FROM App_IndexDBInfo A WITH (NOLOCK) JOIN APP_Client B WITH (NOLOCK) ON a.currentIdxServer = B.id
	WHERE dbName=@dbGuid and backupSetGUID=@bsGuid
	--cleanup record if exist. Could be the result of uninstallation of MA which was assigned as IdxServer for the given DB
	delete from App_IndexDBInfo where dbName=@dbGuid and backupSetGUID=@bsGuid
	select @bsId = BS.id from APP_BackupSetName as BS where BS.GUID = @bsGuid
	select @clId = id from app_client where name = @clname
	insert into App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
		SELECT @dbGuid, @type,  1, @bsId, @clId, @bsGuid, NULL, 1, 0  WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @dbGuid and backupSetGuid = @bsGuid AND isPrimary = 1)
	SET @outXml = (
		select(
			select name as '@clientName' , net_hostname as '@hostName', cvdPort as '@cvdPort', evmgrcPort as '@evmgrcPort', @errCode as '@errorCode', @errString as '@errorString'
			from App_client where id = @clId FOR XML PATH ('idxSrvrInfo'), type
		) FOR XML PATH('App_SetIdxDBPropertyResp'), type)
	EXEC AppAuditIdxServerChange @oldIdxServerName, @clname
END
ELSE
BEGIN
	SET @outXml = (
	select(
		select CL.name as '@clientName' , CL.net_hostname as '@hostName', CL.cvdPort as '@cvdPort', CL.evmgrcPort as '@evmgrcPort', @errCode as '@errorCode', @errString as '@errorString'
		from App_IndexDBInfo AS IDP inner join App_client as CL on CL.id = IDP.currentIdxServer where IDP.dbName = @dbGuid AND IDP.backupSetGuid = @bsGuid
		FOR XML PATH ('idxSrvrInfo'), type
	) FOR XML PATH('App_SetIdxDBPropertyResp'), type)
END
CX_EXIT:
select @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetIdxDBPropertyReq')
	delete from GxQscripts where name = 'AppSetIdxDBPropertyReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetIdxDBPropertyReq')
	delete from GXDBVersions where aliasname = 'AppSetIdxDBPropertyReq'
GO

insert into GXDBVersions values(2, 'AppSetIdxDBPropertyReq',  '00000000000000000000', 'AppSetIdxDBPropertyReq', '00000000000000000000')
GO

