

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetGlobalParamsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Prasad Nara
--	Date:   12/12/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetGlobalParamsXML.sp,v $ $Id: AppSetGlobalParamsXML.sp,v 1.1.2.3 2018/06/29 01:04:45 pnara Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetGlobalParamsXML <<<'

IF EXISTS (select * from sysobjects where name='AppSetGlobalParamsXML')
	drop procedure AppSetGlobalParamsXML
IF EXISTS (select * from GxQscripts where name='AppSetGlobalParamsXML')
	delete from GxQscripts where name = 'AppSetGlobalParamsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetGlobalParamsXML')
	delete from GXDBVersions where aliasname = 'AppSetGlobalParamsXML'
GO
print '... Creating Procedure: AppSetGlobalParamsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetGlobalParamsXML
  @i_inXml xml
AS
SET NOCOUNT ON
DECLARE @l_now int = dbo.GetUnixTime(GETUTCDATE())
IF OBJECT_ID('tempdb..#lt_Params') IS NOT NULL DROP TABLE #lt_Params
CREATE TABLE #lt_Params (name nvarchar(256), value nvarchar(max), oldValue nvarchar(max))
INSERT INTO #lt_Params
SELECT 	Col.value('@name', 'nvarchar(256)'), Col.value('@value', 'nvarchar(max)'), ISNULL(G.value, '')
FROM	@i_inXml.nodes('/App_SetGlobalParamsReq/globalParams') Params(Col)
		LEFT OUTER JOIN GXGlobalParam G WITH(READUNCOMMITTED)
		ON G.name = Col.value('@name', 'nvarchar(256)') AND G.modified = 0
WHERE	G.name IS NULL OR G.value <> Col.value('@value', 'nvarchar(max)')
IF @@ROWCOUNT > 0
BEGIN
	--Update/Insert params
	MERGE GXGlobalParam AS DEST
	USING #lt_Params AS SRC ON SRC.name = DEST.name AND DEST.modified = 0
	WHEN MATCHED THEN
		UPDATE SET value=SRC.value
	WHEN NOT MATCHED THEN
		INSERT (name, value, created, modified)
		VALUES(SRC.name, SRC.value, @l_now, 0);
	--
	-- GAT
	--
	DECLARE @userId INTEGER = ISNULL((SELECT C.value('@userId', 'int') FROM @i_inXml.nodes('App_SetGlobalParamsReq/processinginstructioninfo/user') R ( C )), 0)
DECLARE @evOperation BIGINT = (600 | (CAST(POWER(2, 24) AS BIGINT) * 84))
DECLARE @evParam BIGINT = (1691 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	DECLARE @opEvMsgId INTEGER
	DECLARE @opId INTEGER
	-- Set Audit Operation
	EXEC EvGuiAuditSetOperation @evOperation, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- Iterate through params
	DECLARE @name varchar(256)
	DECLARE @newValue  nvarchar(max)
	DECLARE @oldValue  nvarchar(max)
	DECLARE PARAMCURSOR CURSOR READ_ONLY
	FOR SELECT name, value, oldValue FROM #lt_Params
	OPEN PARAMCURSOR
	FETCH NEXT FROM PARAMCURSOR INTO @name, @newValue, @oldValue
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Set Audit Param Args
		EXEC EvGuiAuditSetParamData @opId, @name, 0 /*dataIsEvent*/
		EXEC EvGuiAuditSetParamData @opId, @oldValue, 0 /*dataIsEvent*/
		EXEC EvGuiAuditSetParamData @opId, @newValue, 0 /*dataIsEvent*/
		-- Set Audit Param
		EXEC EvGuiAuditSetParameter @opId, @evParam, @userId
		FETCH NEXT FROM PARAMCURSOR INTO @name, @newValue, @oldValue
	END
	CLOSE PARAMCURSOR
	DEALLOCATE PARAMCURSOR
END
DROP TABLE #lt_Params
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetGlobalParamsXML')
	delete from GxQscripts where name = 'AppSetGlobalParamsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetGlobalParamsXML')
	delete from GXDBVersions where aliasname = 'AppSetGlobalParamsXML'
GO

insert into GXDBVersions values(2, 'AppSetGlobalParamsXML',  '00010001000200030000', 'AppSetGlobalParamsXML', '00010001000200030000')
GO

