

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetFirewallTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
IF not EXISTS (SELECT * FROM sys.types WHERE is_user_defined = 1 AND name = 'NWTopoGroupInfoTableType')
CREATE TYPE NWTopoGroupInfoTableType AS TABLE ( clientGroupId int, fwGroupType int, fwConfig xml DEFAULT '')
GO
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetFirewallTopology')
BEGIN
	print '>>> Drop Stored Procedure: AppSetFirewallTopology <<<'
	drop procedure AppSetFirewallTopology
END
IF EXISTS (select * from GxQscripts where name='AppSetFirewallTopology')
	delete from GxQscripts where name = 'AppSetFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppSetFirewallTopology'
GO
print '... Creating Procedure: AppSetFirewallTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetFirewallTopology
  @topologyXML XML
AS
  DECLARE @o_topologyId INT
  DECLARE @o_exist INT
  DECLARE @o_duplicateGroups INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @topologyId INT = @topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/topologyEntity/@topologyId)[1]', 'int')
DECLARE @topologyName nvarchar(256) = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/topologyEntity/@topologyName)[1]', 'nvarchar(256)'), '')
DECLARE @description nvarchar(max) = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@description)[1]', 'nvarchar(max)'), '')
DECLARE @topologyType INT = @topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@topologyType)[1]', 'int')
DECLARE	@created	INT = DATEDIFF(SECOND, '1970-1-1',CURRENT_TIMESTAMP)
DECLARE @modified	INT = 0
DECLARE @extendedProperties XML = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@extendedProperties)[1]','nvarchar(max)'),N'<App_TopologyExtendedProperties displayType="0" encryptTraffic="0" connectionProtocol ="2" numberOfStreams="1"/>')
DECLARE @clientGroupId INT = 0
DECLARE @fwGroupType INT = 0
DECLARE @exist INT = 0
DECLARE @firewallGroups NWTopoGroupInfoTableType
DECLARE @duplicateGroups INT = 0
DECLARE @isSmartTopology BIT = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@isSmartTopology)[1]', 'bit'),0)
DECLARE @isTopologyForCSFailover BIT = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@isTopologyForCSFailover)[1]', 'bit'),0)
DECLARE @iFlag INT = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@flags)[1]', 'INT'),0)
DECLARE @flag	INT	=	0
DECLARE @useWildCardProxy INT = ISNULL(@topologyXML.value('(/App_CreateFirewallTopologyReq/firewallTopology/@useWildcardProxy)[1]', 'int'), 0)
DECLARE @prevTranCount INT = 0
DECLARE @encryptTraffic INT = ISNULL(@extendedProperties.value('(/App_TopologyExtendedProperties/@encryptTraffic)[1]', 'int'), 0)
BEGIN
	--	For qcommands, only the client group names are provided and not the Ids.
	--	In case of smart topologies, there is no client group name which is matched by the mnemonics, and hence ID is not populated.
	--	So, we have to replace them manually
	INSERT INTO @firewallGroups (clientGroupId, fwGroupType, fwConfig)
	SELECT	CASE
			WHEN T.c.value('(clientGroup/@clientGroupId)[1]', 'int') IS NULL OR  T.c.value('(clientGroup/@clientGroupId)[1]', 'int') = -32000 THEN dbo.GetSmartTopologyMnemonicID(T.c.value('(clientGroup/@clientGroupName)[1]', 'NVARCHAR(255)'))
			ELSE T.c.value('(clientGroup/@clientGroupId)[1]', 'int') END
			, T.c.value('(@fwGroupType)[1]', 'int')
			, T.c.query('options')
	FROM @topologyXML.nodes('/App_CreateFirewallTopologyReq/firewallTopology/firewallGroups') T(c)
	IF @topologyType IN (2,3)
	BEGIN
		SET @duplicateGroups =  (SELECT COUNT(1)
								FROM APP_FirewallTopology AFT
								WHERE NOT EXISTS (
													(
														SELECT groupId
														FROM APP_FirewallTopologyAssoc AFTA
														WHERE AFTA.topologyId = AFT.topologyId AND (AFTA.fwGroupType IN (1,2))
													)
													EXCEPT
													(
														SELECT clientGroupId FROM @firewallGroups FG WHERE FG.fwGroupType IN (1,2)
													)
												)
								)
	END
	IF @topologyType in (1,4)
	BEGIN
		SET @duplicateGroups = (SELECT COUNT(1)
							   FROM APP_FirewallTopology AFT
							   WHERE AFT.topologyType IN (2,3) AND NOT EXISTS(
																			(
																				SELECT groupId
																				FROM APP_FirewallTopologyAssoc AFTA
																				WHERE AFTA.topologyId = AFT.topologyId
																			)
																			EXCEPT
																			(
																				SELECT clientGroupId FROM @firewallGroups FG WHERE FG.fwGroupType IN (1,2)
																			)
																		)
								)
	END
	IF @duplicateGroups = 0
	BEGIN
			SET @duplicateGroups = (SELECT COUNT(1)
								   FROM APP_FirewallTopology AFT
								   WHERE AFT.topologyType = @topologyType AND NOT EXISTS(
																				(
																					SELECT groupId
																					FROM APP_FirewallTopologyAssoc AFTA
																					WHERE AFTA.topologyId = AFT.topologyId
																				)
																				EXCEPT
																				(
																					SELECT clientGroupId FROM @firewallGroups
																				)
																			)
									)
	END
	IF @duplicateGroups = 0
	BEGIN
		BEGIN TRY
			SET @prevTranCount = @@TRANCOUNT
			IF @prevTranCount > 0 -- We have an active transaction. SAVE TRANSACTION so that the transaction can be rolled back in case of an exception.
				SAVE TRANSACTION TRAN_CREATE_FWTOPO
			ELSE -- No transaction was started before calling this SP. BEGIN TRANSACTION so that the transaction can be rolled back in case of an exception.
				BEGIN TRANSACTION TRAN_CREATE_FWTOPO
SELECT @flag = @flag | 1 WHERE @isSmartTopology = 1
SELECT @flag = @flag | 2 WHERE @isTopologyForCSFailover = 1
			SELECT @flag = @flag | @iFlag
			-- If @encryptTraffic is set, ensure we set the connectionProtocol to https
			IF @encryptTraffic = 1
SET @extendedProperties.modify('replace value of (/App_TopologyExtendedProperties/@connectionProtocol)[1] with "1"')
			INSERT INTO APP_FirewallTopology (topologyName, description, topologyType, created, modified, extendedProperties, flag)
			VALUES (@topologyName, @description, @topologyType, @created, @modified, @extendedProperties, @flag)
			SET @topologyId = SCOPE_IDENTITY()
			IF @prevTranCount = 0 -- COMMIT the transaction we started.
				COMMIT TRANSACTION TRAN_CREATE_FWTOPO
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			ROLLBACK TRANSACTION TRAN_CREATE_FWTOPO
			IF ERROR_NUMBER() = 2627
				SET @exist = 1
			ELSE
				THROW;
		END CATCH
		IF @exist = 0
		BEGIN
			INSERT INTO APP_FirewallTopologyAssoc(topologyId, groupId, fwGroupType)
			SELECT @topologyId, clientGroupId, fwGroupType
			FROM @firewallGroups
			EXEC populateTopology @topologyId, @firewallGroups, @topologyType, @useWildCardProxy, @extendedProperties
		END
	END
	SELECT @topologyId, @exist, @duplicateGroups
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetFirewallTopology')
	delete from GxQscripts where name = 'AppSetFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppSetFirewallTopology'
GO

insert into GXDBVersions values(2, 'AppSetFirewallTopology',  '00000000000000000000', 'AppSetFirewallTopology', '00000000000000000000')
GO

