

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetFirewallOption.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetFirewallOption.sp,v $ $Id: AppSetFirewallOption.sp,v 1.1.4.4 2020/07/31 20:13:05 sneralla Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppSetFirewallOption()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetFirewallOption')
BEGIN
	print '>>> Drop Stored Procedure: AppSetFirewallOption <<<'
	drop procedure AppSetFirewallOption
END
IF EXISTS (select * from GxQscripts where name='AppSetFirewallOption')
	delete from GxQscripts where name = 'AppSetFirewallOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetFirewallOption')
	delete from GXDBVersions where aliasname = 'AppSetFirewallOption'
GO
print '... Creating Procedure: AppSetFirewallOption'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetFirewallOption
  @i_clientId INT,
  @i_isDmz INT
AS
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorMessage VARCHAR(MAX) = 'Success'
DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @isTrivialConfig INT = 0
IF @i_clientId <= 0
	BEGIN
		SET @o_errorMessage = 'Invalid Client id'
		SET @o_errorCode = 1
		GOTO PROC_END
	END
IF @i_isDmz >= 1
	BEGIN
		SET @i_isDmz = 1
SET @isTrivialConfig = 2
	END
ELSE
	SET @i_isDmz = 0
IF EXISTS(SELECT 1 FROM App_FirewallOptions WITH(NOLOCK) WHERE clientId = @i_clientId)
	BEGIN
		UPDATE App_FirewallOptions
		SET isDMZ = @i_isDmz
		WHERE clientId = @i_clientId
	END
ELSE
	BEGIN
		DECLARE @tunnelPort INT = 8403
		SET @tunnelPort =ISNULL(( SELECT    cvdPort
                              FROM     APP_Client WITH(NOLOCK)
                              WHERE     id = @i_clientId
                             )+3, 8403)
		INSERT App_FirewallOptions(clientId, clientGroupId, isDMZ, tunnelconnectionPort, keepAliveSeconds, tunnelInitSeconds, foreceSSL, lockDown, bindOpenPortsOnly, isRoamingClient, extendedProperties)
VALUES(@i_clientId, 0, @i_isDmz, @tunnelPort, 180, 30 , 0, 0, 0, 0, '<App_FirewallExtendedProperties configureAutomatically="1" defaultOutgoingProtocol="2" />')
	END
IF @isTrivialConfig>0
	BEGIN
		IF EXISTS(SELECT 1 FROM App_FWTrivialConfig WITH(NOLOCK) WHERE clientId = @i_clientId)
			BEGIN
				UPDATE App_FWTrivialConfig
				SET isTrivialConfig = @isTrivialConfig
				WHERE clientId=@i_clientId and clientGroupId = 0
			END
		ELSE
			BEGIN
				INSERT App_FWTrivialConfig(clientId, clientGroupId, isTrivialConfig,networkWithCS,connectionWithCS,proxyClientIdCS, networkWithMA,connectionWithMA,proxyClientIdMA)
				VALUES(@i_clientId, 0,@isTrivialConfig, 0, 0, 0, 0, 0, 0)
			END
	END
PROC_END:
SELECT @o_errorCode, @o_errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetFirewallOption')
	delete from GxQscripts where name = 'AppSetFirewallOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetFirewallOption')
	delete from GXDBVersions where aliasname = 'AppSetFirewallOption'
GO

insert into GXDBVersions values(2, 'AppSetFirewallOption',  '00010001000400040000', 'AppSetFirewallOption', '00010001000400040000')
GO

