

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetFailedJobOccuranceForClientsAndMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: AppSetFailedJobOccuranceForClientsAndMA
--
--
--		  input:
--				 1. jobTypes
--                  (1 - bkp,2 - restore,4 - admin,8 -laptopbackup)
--
--        output: 0/1
--
--
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetFailedJobOccuranceForClientsAndMA')
BEGIN
	print '>>> Drop Stored Procedure: AppSetFailedJobOccuranceForClientsAndMA <<<'
	drop procedure AppSetFailedJobOccuranceForClientsAndMA
END
IF EXISTS (select * from GxQscripts where name='AppSetFailedJobOccuranceForClientsAndMA')
	delete from GxQscripts where name = 'AppSetFailedJobOccuranceForClientsAndMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetFailedJobOccuranceForClientsAndMA')
	delete from GXDBVersions where aliasname = 'AppSetFailedJobOccuranceForClientsAndMA'
GO
print '... Creating Procedure: AppSetFailedJobOccuranceForClientsAndMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSetFailedJobOccuranceForClientsAndMA
  @jobTypes INT = 15
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInDay INT = 24 * 60 *60
	DECLARE @currentDate INT = (@time / @secondsInDay) * @secondsInDay
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
	CREATE TABLE #jobTable
	(
	    occurance INT,
		clientId INT
	)
	-- Calculating and setting failed job count for clients
IF @jobTypes & 1 <> 0 OR @jobTypes & 8 <> 0
	INSERT INTO #jobTable
	 SELECT
		COUNT(jobID), App.clientId
		FROM JMBkpStats JM WITH (NOLOCK)
		INNER JOIN APP_Application  APP WITH (NOLOCK) ON JM.appID = APP.id
		INNER JOIN APP_Client CL WITH (NOLOCK) ON APP.clientId = Cl.id AND CL.status & 0x1000 <> 0x1000 AND CL.status & 0x10000000 <> 0x10000000
		WHERE  JM.servEndDate > @currentDate AND JM.status IN (2,3,4,14,15) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
		GROUP BY App.clientId
IF @jobTypes & 2 <> 0
	INSERT INTO #jobTable
	 SELECT
		COUNT(jobID), srcClientId
		FROM JMRestoreStats JM WITH (NOLOCK)
		INNER JOIN APP_Client CL WITH (NOLOCK) ON JM.srcClientId = Cl.id AND CL.status & 0x1000 <> 0x1000 AND CL.status & 0x10000000 <> 0x10000000
		WHERE  JM.servEndTime > @currentDate AND JM.status IN (2,3,4,14,15)
		GROUP BY srcClientId
IF @jobTypes & 4 <> 0
	INSERT INTO #jobTable
	 SELECT
		COUNT(jobID), App.clientId
		FROM JMAdminJobStatsTable JM WITH (NOLOCK)
		INNER JOIN APP_Application APP WITH (NOLOCK) ON JM.appID = APP.id
		INNER JOIN APP_Client CL WITH (NOLOCK) ON APP.clientId = Cl.id AND CL.status & 0x1000 <> 0x1000 AND CL.status & 0x10000000 <> 0x10000000
		WHERE JM.servEnd > @currentDate AND JM.status IN (2,3,4,14,15)
		GROUP BY App.clientId
	UPDATE CP SET CP.attrVal = CAST(JT.occurance AS NVARCHAR(128)), CP.created = @time FROM
	(
		SELECT SUM(occurance) AS occurance, clientId AS clientId
		FROM #jobTable GROUP BY clientId
	) JT
	INNER JOIN APP_ClientProp CP ON JT.clientId = CP.componentNameId AND CP.attrName = N'Client Failed Job Count For Today' AND modified = 0
	INSERT INTO APP_ClientProp
	SELECT componentNameId, N'Client Failed Job Count For Today', 2, attrVal, @time, 0, 0 FROM
	(
		SELECT JT.clientId AS componentNameId, CAST(occurance AS NVARCHAR(128)) AS attrVal, CP.attrVal AS oldEntry FROM
		(
			SELECT SUM(occurance) AS occurance, clientId AS clientId
			FROM #jobTable GROUP BY clientId
		) JT
		LEFT OUTER JOIN APP_ClientProp CP ON JT.clientId = CP.componentNameId AND CP.attrName = N'Client Failed Job Count For Today' AND CAST(attrVal AS INT) = JT.occurance AND modified = 0
	) ClientProp
	WHERE ClientProp.oldEntry IS NULL
	DELETE FROM #jobTable
	-- Calculating and setting failed job count for media agents
IF @jobTypes & 1 <> 0 OR @jobTypes & 8 <> 0
	INSERT INTO #jobTable
	 SELECT
		COUNT(DISTINCT JM.jobID), JRH.clientId
		FROM JMBkpStats JM WITH (NOLOCK)
		INNER JOIN JMJobResourceHistory JRH WITH (NOLOCK) ON JRH.jobId = JM.jobId
		WHERE  JM.servEndDate > @currentDate AND JM.status IN (2,3,4,14,15)
		GROUP BY JRH.clientId
IF @jobTypes & 2 <> 0
	INSERT INTO #jobTable
	 SELECT
		COUNT(DISTINCT JM.jobID), JRH.clientId
		FROM JMRestoreStats JM WITH (NOLOCK)
		INNER JOIN JMJobResourceHistory JRH WITH (NOLOCK) ON JRH.jobId = JM.jobId
		WHERE  JM.servEndTime > @currentDate AND JM.status IN (2,3,4,14,15)
		GROUP BY JRH.clientId
IF @jobTypes & 4 <> 0
	INSERT INTO #jobTable
	 SELECT
		COUNT(DISTINCT JM.jobID), JRH.clientId
		FROM JMAdminJobStatsTable JM WITH (NOLOCK)
		INNER JOIN JMJobResourceHistory JRH WITH (NOLOCK) ON JRH.jobId = JM.jobId
		WHERE JM.servEnd > @currentDate AND JM.status IN (2,3,4,14,15)
		GROUP BY JRH.clientId
	UPDATE CP SET CP.attrVal = CAST(JT.occurance AS NVARCHAR(128)), CP.created = @time FROM
	(
		SELECT SUM(occurance) AS occurance, clientId AS clientId
		FROM #jobTable GROUP BY clientId
	) JT
	INNER JOIN APP_ClientProp CP ON JT.clientId = CP.componentNameId AND CP.attrName = N'Media Agent Failed Job Count For Today' AND modified = 0
	INSERT INTO APP_ClientProp
	SELECT componentNameId, N'Media Agent Failed Job Count For Today', 2, attrVal, @time, 0, 0 FROM
	(
		SELECT JT.clientId AS componentNameId, CAST(occurance AS NVARCHAR(128)) AS attrVal, CP.attrVal AS oldEntry FROM
		(
			SELECT SUM(occurance) AS occurance, clientId AS clientId
			FROM #jobTable GROUP BY clientId
		) JT
		LEFT OUTER JOIN APP_ClientProp CP ON JT.clientId = CP.componentNameId AND CP.attrName = N'Media Agent Failed Job Count For Today' AND CAST(attrVal AS INT) = JT.occurance AND modified = 0
	) ClientProp
	WHERE ClientProp.oldEntry IS NULL
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetFailedJobOccuranceForClientsAndMA')
	delete from GxQscripts where name = 'AppSetFailedJobOccuranceForClientsAndMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetFailedJobOccuranceForClientsAndMA')
	delete from GXDBVersions where aliasname = 'AppSetFailedJobOccuranceForClientsAndMA'
GO

insert into GXDBVersions values(2, 'AppSetFailedJobOccuranceForClientsAndMA',  '00000000000000000000', 'AppSetFailedJobOccuranceForClientsAndMA', '00000000000000000000')
GO

