

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetExchangeMbBackupRefTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetExchangeMbBackupRefTime.sp,v $ $Id: AppSetExchangeMbBackupRefTime.sp,v 1.1.2.3 2020/02/18 20:06:06 nuppu Exp $";
--	+===================================================================+
--	|  				AppSetExchangeMbBackupRefTime				    	|
--	| Procedure for Set backup reference time for exchange mailbox	    |
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetExchangeMbBackupRefTime')
BEGIN
	print '>>> Drop Stored Procedure: AppSetExchangeMbBackupRefTime <<<'
	drop procedure AppSetExchangeMbBackupRefTime
END
IF EXISTS (select * from GxQscripts where name='AppSetExchangeMbBackupRefTime')
	delete from GxQscripts where name = 'AppSetExchangeMbBackupRefTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetExchangeMbBackupRefTime')
	delete from GXDBVersions where aliasname = 'AppSetExchangeMbBackupRefTime'
GO
print '... Creating Procedure: AppSetExchangeMbBackupRefTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetExchangeMbBackupRefTime
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @MAILBOXTYPE_USER	INT = 1
	DECLARE @MAILBOXTYPE_MS_JOURNAL	INT = 2
	IF OBJECT_ID('tempdb.dbo.#mailboxAssociation') IS NOT NULL
       DROP TABLE #mailboxAssociation
CREATE TABLE #mailboxAssociation (mbGuid varchar(40), subclientId INT, backupRefTime INT, indexCollectionTime INT, nEmails BIGINT, mbSize BIGINT)
	CREATE CLUSTERED INDEX #mailboxAssociation_userGuid_subclientId_Index ON #mailboxAssociation ([mbGuid],[subclientId])
	INSERT INTO #mailboxAssociation(mbGuid, subclientId, backupRefTime, indexCollectionTime, nEmails, mbSize)
	SELECT MB.value('(user[1]/@userGUID)', 'NVARCHAR(MAX)'),
			MB.value('(../../subclientEntity[1]/@subclientId)','INT'),
			CASE WHEN MB.value('(lastArchiveJobRanTime[1]/@time)','INT') IS NULL
				 THEN MB.value('(lastArchiveJobRanTime[1]/@timeValue)', 'VARCHAR(30)') --check if other field is set and read from it
			ELSE MB.value('(lastArchiveJobRanTime[1]/@time)','INT') END,
			CASE WHEN MB.value('(IdxCollectionTime[1]/@time)','INT') IS NULL
				 THEN MB.value('(IdxCollectionTime[1]/@timeValue)', 'VARCHAR(30)') --check if other field is set and read from it
			ELSE MB.value('(IdxCollectionTime[1]/@time)','INT') END,
			MB.value('@numberOfEmails','BIGINT'),
			MB.value('@mailboxSize','BIGINT')
	FROM @i_xmlString.nodes('Ida_SetExchangeMbBackupRefTime/emailAssociation/emailDiscoverinfo/mailBoxes') M(MB)
	--Check if received input has valid values
	IF EXISTS(SELECT TOP 1 1 FROM #mailboxAssociation WHERE backupRefTime IS NULL OR backupRefTime <0 OR subclientId <=0 OR mbGuid IS NULL)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input received. Check input request. Exiting'
		GOTO ERROR_EXIT
	END
	BEGIN TRANSACTION
		UPDATE APP_EmailConfigPolicyAssoc
		SET backupReferenceTime =  MB.backupRefTime,
		/*set index collection time only if present in request*/
		idxCollectionTime = CASE WHEN MB.indexCollectionTime IS NOT NULL AND  MB.indexCollectionTime != 0 THEN MB.indexCollectionTime
							ELSE idxCollectionTime  END ,
		/*set number of emails only if present in request*/
		numberOfEmails = CASE WHEN MB.nEmails IS NOT NULL AND MB.nEmails != 0 THEN MB.nEmails
						ELSE numberOfEmails END,
		/*set number of emails only if present in request*/
		mailboxSize = CASE WHEN MB.mbSize IS NOT NULL AND MB.mbSize != 0 THEN MB.mbSize
					  ELSE mailboxSize END
		FROM #mailboxAssociation MB
		WHERE APP_EmailConfigPolicyAssoc.userGuid = MB.mbGuid AND APP_EmailConfigPolicyAssoc.subClientId = MB.subclientId
		AND APP_EmailConfigPolicyAssoc.mailBoxType in (1,2,3) AND APP_EmailConfigPolicyAssoc.deleted != 1 AND APP_EmailConfigPolicyAssoc.modified=0 AND MB.backupRefTime <> 0
		SET @errorCode = @@ERROR
	ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH ('Ida_GenericResp'), TYPE )
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetExchangeMbBackupRefTime')
	delete from GxQscripts where name = 'AppSetExchangeMbBackupRefTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetExchangeMbBackupRefTime')
	delete from GXDBVersions where aliasname = 'AppSetExchangeMbBackupRefTime'
GO

insert into GXDBVersions values(2, 'AppSetExchangeMbBackupRefTime',  '00010001000200030000', 'AppSetExchangeMbBackupRefTime', '00010001000200030000')
GO

