

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetExchangeIdxMailboxStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetExchangeIdxMailboxStats.sp,v $ $Id: AppSetExchangeIdxMailboxStats.sp,v 1.1.2.2 2019/03/28 22:54:01 jraju Exp $";
--	+===================================================================+
--	|  				AppSetExchangeIdxMailboxStats				    	|
--	| Procedure for Set mailbox level stats							    |
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetExchangeIdxMailboxStats')
BEGIN
	print '>>> Drop Stored Procedure: AppSetExchangeIdxMailboxStats <<<'
	drop procedure AppSetExchangeIdxMailboxStats
END
IF EXISTS (select * from GxQscripts where name='AppSetExchangeIdxMailboxStats')
	delete from GxQscripts where name = 'AppSetExchangeIdxMailboxStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetExchangeIdxMailboxStats')
	delete from GXDBVersions where aliasname = 'AppSetExchangeIdxMailboxStats'
GO
print '... Creating Procedure: AppSetExchangeIdxMailboxStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetExchangeIdxMailboxStats
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	IF OBJECT_ID('tempdb.dbo.#mailboxAssociation') IS NOT NULL
       DROP TABLE #mailboxAssociation
CREATE TABLE #mailboxAssociation (mbxGuid varchar(40), subclientId INT, mailboxSize BIGINT, itemsIndexed BIGINT, itemsCIed BIGINT, collectionTime INT)
	CREATE CLUSTERED INDEX #mailboxAssociation_userGuid_subclientId_Index ON #mailboxAssociation ([mbxGuid],[subclientId])
	INSERT INTO #mailboxAssociation(mbxGuid, subclientId, mailboxSize, itemsIndexed, itemsCIed, collectionTime)
	SELECT MB.value('@mbxGUID', 'NVARCHAR(MAX)'),
			MB.value('(../@subclientId)','INT'),
			MB.value('@size', 'BIGINT'),
			MB.value('@itemsIndexed', 'BIGINT'),
			MB.value('@itemsContentIndexed', 'INT'),
			MB.value('(../@collectionTime)','INT')
	FROM @inXml.nodes('Indexing_SetExchangeMailboxIdxStats/stats') M(MB)
	--Check if received input has valid values
	IF EXISTS(SELECT TOP 1 1 FROM #mailboxAssociation WHERE subclientId <=0 OR mbxGuid IS NULL)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input received. Check input request. Exiting'
		GOTO ERROR_EXIT
	END
	BEGIN TRANSACTION
		UPDATE APP_EmailConfigPolicyAssoc
		SET mailBoxSize =  MB.mailboxSize, numberOfEmails = MB.itemsIndexed, IdxCollectionTime = MB.collectionTime
		FROM #mailboxAssociation MB
		WHERE APP_EmailConfigPolicyAssoc.userGuid = MB.mbxGuid AND APP_EmailConfigPolicyAssoc.subClientId = MB.subclientId
		AND APP_EmailConfigPolicyAssoc.mailBoxType in (1,2,3) AND APP_EmailConfigPolicyAssoc.modified=0
		SET @errorCode = @@ERROR
	ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
	ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH ('App_GenericResp'), TYPE )
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetExchangeIdxMailboxStats')
	delete from GxQscripts where name = 'AppSetExchangeIdxMailboxStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetExchangeIdxMailboxStats')
	delete from GXDBVersions where aliasname = 'AppSetExchangeIdxMailboxStats'
GO

insert into GXDBVersions values(2, 'AppSetExchangeIdxMailboxStats',  '00010001000200020000', 'AppSetExchangeIdxMailboxStats', '00010001000200020000')
GO

