

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetExchangeIdxDbStats.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppSetExchangeIdxDbStats()
--  | Description:  To update indexing stats for Exchange mailbox agent.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetExchangeIdxDbStats.sp,v $ $Id: AppSetExchangeIdxDbStats.sp,v 1.1.2.2 2020/11/24 19:13:24 jraju Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetExchangeIdxDbStats')
BEGIN
	print '>>> Drop Stored Procedure: AppSetExchangeIdxDbStats <<<'
	drop procedure AppSetExchangeIdxDbStats
END
IF EXISTS (select * from GxQscripts where name='AppSetExchangeIdxDbStats')
	delete from GxQscripts where name = 'AppSetExchangeIdxDbStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetExchangeIdxDbStats')
	delete from GXDBVersions where aliasname = 'AppSetExchangeIdxDbStats'
GO
print '... Creating Procedure: AppSetExchangeIdxDbStats'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetExchangeIdxDbStats
  @inxml XML
AS
DECLARE @curtime INT = DBO.GetUnixTime(getdate())
DECLARE @dbcount INT = ISNULL(@inxml.value('count(/Indexing_SetExchangeIdxStats/idxStats)','int'), 0)
WHILE @dbcount > 0
BEGIN
    DECLARE @indbxml XML = @inxml.query('(/Indexing_SetExchangeIdxStats/idxStats)[sql:variable("@dbcount")]')
    DECLARE @appId INT = @indbxml.value('(/idxStats/@subclientId)[1]','INT')
	DECLARE @backupsetID INT = ISNULL((Select backupset From App_Application(NOLOCK) Where id = @appId), 0)
    DECLARE @dbId INT = (select ID from App_IndexDBInfo WITH (NOLOCK) where backupSetId = @backupsetID AND idxDbEngineType = 2 AND isPrimary = 1)
	DECLARE @statsXML XML = @indbxml.query('(/idxStats/stat)')
	DECLARE @appSize BIGINT
    IF @dbId IS NOT NULL AND @statsXML IS NOT NULL
    BEGIN
        DECLARE @orgdbxml XML = (select properties from IdxDbState WITH (NOLOCK) where dbId = @dbId)
        IF @orgdbxml.exist('(/Indexing_DbStats/apps/stat)[1]') = 1
			SET @orgdbxml.modify('delete /Indexing_DbStats/apps/stat')
        -- Update the dbSize also as this is used in the report.
		SET @appSize = (select @statsXML.value('(/Indexing_DbStats/apps/stat/@applicationSize)[1]', 'bigint'))
		SET @orgdbxml.modify('delete /Indexing_DbStats/@dbSize');
		SET @orgdbxml.modify('insert attribute dbSize {sql:variable("@appSize")} into (/Indexing_DbStats)[1]');
        SET @orgdbxml.modify('insert sql:variable("@statsXML") into (/Indexing_DbStats/apps)[1]')
        UPDATE IdxDbState SET properties = @orgdbxml, modified = @curtime WHERE dbid = @dbId
    END
    SET @dbcount = @dbcount-1
END
DECLARE @outXml XML = '<App_GenericResp errorCode="0"/>'
select @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetExchangeIdxDbStats')
	delete from GxQscripts where name = 'AppSetExchangeIdxDbStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetExchangeIdxDbStats')
	delete from GXDBVersions where aliasname = 'AppSetExchangeIdxDbStats'
GO

insert into GXDBVersions values(2, 'AppSetExchangeIdxDbStats',  '00010001000200020000', 'AppSetExchangeIdxDbStats', '00010001000200020000')
GO

