

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEntityClientAssoc.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetEntityClientAssoc.sp,v $ $Id: AppSetEntityClientAssoc.sp,v 1.7.34.7 2018/03/27 08:46:24 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppSetEntityClientAssoc   - Set Entity client association details
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetEntityClientAssoc <<<'

IF EXISTS (select * from sysobjects where name='AppSetEntityClientAssoc')
	drop procedure AppSetEntityClientAssoc
IF EXISTS (select * from GxQscripts where name='AppSetEntityClientAssoc')
	delete from GxQscripts where name = 'AppSetEntityClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEntityClientAssoc')
	delete from GXDBVersions where aliasname = 'AppSetEntityClientAssoc'
GO
print '... Creating Procedure: AppSetEntityClientAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetEntityClientAssoc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT = 1,
  @i_archGroupId INT,
  @i_clientList NVARCHAR(MAX) = N'',
  @i_entityIdList NVARCHAR(4000) = N'',
  @i_contentAnalyzerClientId INT 
AS
  DECLARE @o_lastError INT =0
DECLARE @nowTime DATETIME = GETUTCDATE()
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
DECLARE @userGUID		VARCHAR(64)= ISNULL((SELECT userGuid FROM UMUSERS WITH (NOLOCK) WHERE ID = @i_userId),'')
DECLARE @cloudClientAssoc TABLE (t_archGroupId INT, t_CloudId INT, t_nodeClientId INT)
IF object_id('tempdb.dbo.#clientDetails') IS NOT NULL DROP TABLE #clientDetails
CREATE TABLE #clientDetails (t_commcellId INT, t_ClientId INT, t_instanceId INT, t_appTypeId INT, t_bkpSetId INT,  t_subClientId INT)
IF object_id('tempdb.dbo.#subClientDetails') IS NOT NULL DROP TABLE #subClientDetails
CREATE TABLE #subClientDetails (t_commcellId INT, t_ClientId INT, t_instanceId INT, t_appTypeId INT, t_bkpSetId INT,  t_subClientId INT, t_spId INT)
IF object_id('tempdb.dbo.#entityDetails') IS NOT NULL DROP TABLE #entityDetails
CREATE TABLE #entityDetails (t_entityId INT, t_subClientId INT)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
BEGIN TRY
BEGIN TRAN
	--IF DECONFIGURED, DELETE DATA
	IF @i_clientList =N''
	begin
		DELETE ES
		FROM  EntitySelection ES
			INNER JOIN APP_Application AP WITH (NOLOCK) ON ES.SubclientID = AP.ID
		WHERE dataArchGrpID = @i_archGroupId
		DELETE  EP
		FROM EntityProcessor EP
		  LEFT OUTER JOIN EntitySelection ES	WITH (NOLOCK) ON EP.EntityRulerId = ES.EntityRulerId
		  WHERE ES.EntityRulerId IS NULL
		SET @o_lastError = @@ERROR
		GOTO TRANS_EXIT
	end
	--CLOUD-CLIENT-SPid ASSOC
	INSERT INTO @cloudClientAssoc (t_archGroupId , t_CloudId , t_nodeClientId )
	SELECT R.archGroupId, S.CloudId, S.clientID
	FROM  archContentIndexingRules R  WITH (NOLOCK)
		INNER JOIN DM2SearchServerCoreInfo S  WITH (NOLOCK) ON S.CloudId = R.cloudId
WHERE R.archGroupId = @i_archGroupId AND R.operationType = 1
	--insert input into temp table
	INSERT INTO #clientDetails(t_commcellId, t_ClientId, t_instanceId, t_appTypeId, t_bkpSetId,  t_subClientId)
	EXECUTE sp_executeSql @i_clientList
	SET @o_lastError = @@ERROR
	IF @o_lastError <> 0
		GOTO TRANS_EXIT
	--get all valid subclient details
	INSERT INTO #subClientDetails (t_commcellId, t_ClientId, t_instanceId, t_appTypeId, t_bkpSetId,  t_subClientId, t_spId)
	SELECT  DISTINCT 2,  clientId, instance, appTypeId, backupSet, id, dataArchGrpID
	FROM APP_Application AP WITH (NOLOCK)
		INNER JOIN #clientDetails T ON AP.clientId = T.t_ClientId OR T.t_ClientId = 0
		WHERE dataArchGrpID = @i_archGroupId
		AND 	(subclientStatus & 2) = 0 AND (subclientStatus & 4) = 0
		AND   ((subclientStatus & 32) = 0 AND (subclientStatus & 16) = 0 OR (subclientStatus & 64) > 0)
		AND ( ( T.t_instanceId = 0 AND t_appTypeId = 0 AND  t_bkpSetId= 0 AND t_subClientId=0)
				OR (AP.instance = T.t_instanceId AND t_appTypeId = 0 AND  t_bkpSetId= 0 AND t_subClientId=0)
				OR  ( AP.instance = T.t_instanceId AND  AP.appTypeId = t_appTypeId  AND  t_bkpSetId= 0 AND t_subClientId=0)
				OR ( AP.instance = T.t_instanceId AND  AP.appTypeId = t_appTypeId  AND   AP.backupSet = t_bkpSetId AND t_subClientId=0)
				OR ( AP.id = t_subClientId)
		)
AND (AP.subclientstatus & 0x20000) = 0
	--delete temp table, as no more required
	IF object_id('tempdb.dbo.#clientDetails') IS NOT NULL DROP TABLE #clientDetails
	--get all entity details
	INSERT INTO #entityDetails (t_entityId, t_subClientId )
	SELECT _id , t_subClientId
	from dbo.SplitIDs(@i_entityIdList) CROSS JOIN #subClientDetails
	----if clients or entities are changed
	---update status of data which not selected in the recent selection
	UPDATE ES
SET enabled = 0
	FROM EntitySelection ES
	 INNER JOIN APP_Application AP WITH (NOLOCK) ON ES.SubclientID = AP.ID
	WHERE dataArchGrpID = @i_archGroupId
	 and ( ES.SubclientID NOT IN (SELECT DISTINCT t_subClientId FROM  #entityDetails)
	 OR ES.EntityID NOT IN (SELECT DISTINCT t_entityId FROM  #entityDetails))
--	UPDATE EP
--	SET FLAGS = CVCI_ENGINE_FLAG_NONE
--	FROM EntityProcessor EP
--		LEFT OUTER JOIN EntitySelection ES	WITH (NOLOCK) ON EP.EntityRulerId = ES.EntityRulerId
--		WHERE ES.EntityRulerId IS NULL
	----
	--delete rows from #entityDetails which already present into entityselection table
	IF EXISTS (SELECT * FROM EntitySelection ES WITH (NOLOCK) INNER JOIN #entityDetails ED ON ES.SubclientID = ED.t_subClientId AND ES.EntityID = ED.t_entityId AND ES.Enabled = 1)
	begin
		DELETE ED
		FROM #entityDetails ED
			INNER JOIN EntitySelection ES WITH (NOLOCK) ON ES.SubclientID = ED.t_subClientId  AND ES.EntityID = ED.t_entityId AND ES.Enabled = 1
	end
	--
	IF NOT EXISTS (SELECT * FROM EntitySelection ES WITH (NOLOCK) INNER JOIN #entityDetails ED ON ES.SubclientID = ED.t_subClientId AND ES.EntityID = ED.t_entityId)
	BEGIN
		--finally insert rows into EntityExtractionRule table.
		INSERT INTO EntitySelection (EntityRulerId, RuleType, EntityID, commcellId , ClientId , subClientId , appTypeId, UserGUID,  CreationTime, NumItemsProcessed, TotalEntitiesFound, TotalDocsFound, SearchQuery, Enabled, Flags, ModiFiedTime)
SELECT newID(), 1, E.t_entityId, C.t_commcellId , t_ClientId , C.t_subClientId , t_appTypeId , @userGUID,  @nowTIme, 0, 0, 0, '', 1, 0x0, 0
		FROM #subClientDetails C
		INNER JOIN #entityDetails E ON C.t_subClientId = E.t_subClientId
		INSERT INTO EntityProcessor (EntityRulerId, NodeClientId, CloudID, ExtractingClientID, ForwardRefTime, BackwardRefTime, Flags)
SELECT ES.EntityRulerId, R.t_nodeClientId, R.t_CloudId, @i_contentAnalyzerClientId, 0, 0, 0x1
		FROM EntitySelection ES
		LEFT OUTER JOIN   EntityProcessor EP ON ES.EntityRulerId = EP.EntityRulerId
		INNER JOIN #subClientDetails C ON ES.subClientId = C.t_subClientId
		INNER JOIN @cloudClientAssoc R  ON R.t_archGroupId = C.t_spId
		WHERE EP.EntityRulerId IS NULL
	END
	ELSE
	BEGIN
		UPDATE ES
		SET Enabled = 1
		FROM EntitySelection ES
			INNER JOIN #entityDetails ED ON ES.EntityID = ED.t_entityId
		WHERE Enabled = 0
	END
	IF object_id('tempdb.dbo.#entityDetails') IS NOT NULL DROP TABLE #entityDetails
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ERROR_PROCEDURE() + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_lastError = @@ERROR
END CATCH
TRANS_EXIT:
IF @o_lastError <> 0
	ROLLBACK TRAN
ELSE
BEGIN
		--add auditing for Entity extraction configuration and deconfiguration
	DECLARE @spName nvarchar(1024)=ISNULL((SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId),N'')
	DECLARE @entityNameList nvarchar(2048)	=N''
	DECLARE @clientList nvarchar(MAX)	=N''
	DECLARE @AnalyzerClientName nvarchar(1024)=ISNULL((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @i_contentAnalyzerClientId),N'') +'<BR>'
	SELECT @entityNameList =  COALESCE( @entityNameList + N',', N'') + CONVERT(NVARCHAR(32),a.name)
							from dbo.SplitIDs(@i_entityIdList) t
								inner join entityAnnotator a  WITH (NOLOCK) on t._id = a.EntityID
	SELECT @clientList =  COALESCE( @clientList + N'(', N'') + CONVERT(NVARCHAR(64),a.name) + ':' +  CONVERT(NVARCHAR(64),ap.subClientName) + '),'
							from #subClientDetails t
							inner join APP_Application ap with (nolock) on t.t_subClientId = ap.id
								inner join app_client a with (nolock)  on ap.clientId = a.id
	IF @i_clientList =N'' AND @i_entityIdList =N''
	BEGIN
SET @opMsgId = (448 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	END
	ELSE
	BEGIN
SET @opMsgId = (447 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @paramMsgId = (1392 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	END
	EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 17 /*STORAGE_POLICY_ENTITY*/, @i_archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- SET GUI AUDIT PARAMETER
	IF @clientList <>'' AND @entityNameList <>''
	begin
		set  @clientList= SUBSTRING(@clientList,0,len(@clientList)-0) +'<BR>'
		set  @entityNameList=SUBSTRING(@entityNameList,2,len(@entityNameList))	+'<BR>'
		EXEC EvGuiAuditSetParamData @opId, @entityNameList, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @clientList, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @AnalyzerClientName, @dataIsEvent
	END
		EXEC EvGuiAuditSetParamData @opId, @spName, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		COMMIT TRAN
END
IF object_id('tempdb.dbo.#subClientDetails') IS NOT NULL DROP TABLE #subClientDetails
  --------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT @o_lastError
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEntityClientAssoc')
	delete from GxQscripts where name = 'AppSetEntityClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEntityClientAssoc')
	delete from GXDBVersions where aliasname = 'AppSetEntityClientAssoc'
GO

insert into GXDBVersions values(2, 'AppSetEntityClientAssoc',  '00010007003400070000', 'AppSetEntityClientAssoc', '00010007003400070000')
GO

