

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEncryptionSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Shilpa Nagendra
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetEncryptionSettings')
BEGIN
	print '>>> Drop Stored Procedure: AppSetEncryptionSettings <<<'
	drop procedure AppSetEncryptionSettings
END
IF EXISTS (select * from GxQscripts where name='AppSetEncryptionSettings')
	delete from GxQscripts where name = 'AppSetEncryptionSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEncryptionSettings')
	delete from GXDBVersions where aliasname = 'AppSetEncryptionSettings'
GO
print '... Creating Procedure: AppSetEncryptionSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetEncryptionSettings
  @entityId INT,
  @entityType INT,
  @localeId INT,
  @userId INT,
  @encryptionSettings INT,
  @encryptionKeyLength INT, 
  @directMediaAccess INT,
  @cipherType INT,
  @isOutputRequired INT,
  @isFromCPP INT,
  @o_errorCode INT OUTPUT,
  @o_errorString nvarchar(MAX) OUTPUT
AS
  DECLARE @scgId INT
  DECLARE @errorCode INT
  DECLARE @errorString nvarchar(MAX)
  DECLARE @o_beforeUpdateXML XML
  DECLARE @o_afterUpdateXML XML
BEGIN
	-- Include Security check and set encryption settings for a plan at the smart client group.
	DECLARE @i_companyId INT = -1
	DECLARE @i_planId INT= -1
	SET @errorString = N''
	SET @scgId = 0
IF @entityType = 28
	BEGIN
		SET  @scgId = @entityId
	END
ELSE IF @entityType = 158
	BEGIN
		SET  @scgId =  dbo.AppPlanGetEntityValueV2(@entityId, 'Assigned client group', 2)
		SET @i_planId = @entityId
	END
ELSE IF @entityType = 61
	BEGIN
		SET @scgId = ISNULL((SELECT attrValInt FROM App_CompanyProp WHERE componentNameId = @entityId
AND attrName = 'Associated Smart Client Group'  AND modified = 0
AND cs_attrName = CHECKSUM('Associated Smart Client Group')),0)
		SET @i_companyId = @entityId
	END
	DECLARE @userHasPermission INT = 0
	IF  @i_companyId <> 0
	BEGIN
		IF @scgId = 0
		BEGIN
SET @errorCode = (3515 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ENDSP
		END
EXEC sec_checkPermissionOnEntity @userId, 2,
@userHasPermission OUTPUT,  28, @scgId
	END
	ELSE
	BEGIN
EXEC sec_checkPermissionOnEntity @userId, 2,
@userHasPermission OUTPUT,   1, 2
	END
	IF @userHasPermission = 0
	BEGIN
SET @errorCode = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
        SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
        SET @errorString = REPLACE(@errorString, '^1%s', 'EV_MANAGE_APPLICATION')
		GOTO ENDSP
	END
	IF @isOutputRequired = 1
	BEGIN
		EXEC AppGetEncryptionSettings @entityId, @entityType, @localeId, @userId, 0, @o_beforeUpdateXML OUTPUT
	END
DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @firstTime INT = 0
DECLARE @syncClientsEncXML XML
DECLARE @workQueueParam NVARCHAR(MAX) = ''
-- Set ComponentName property only when scgId is present.
IF @scgId <> 0
BEGIN
	-- '@EncryptKeyLength'
	UPDATE APP_COMPONENTPROP
	SET longVal = @encryptionSettings
WHERE propertyTypeId = 3601
	AND componentId = @scgId
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @scgId,  3601,8,  @encryptionSettings,0,  '',  @currentTime,0)
	END
	-- '@EncryptKeyLength'
	UPDATE APP_COMPONENTPROP
	SET longVal = @encryptionKeyLength
WHERE propertyTypeId = 3603
	AND componentId = @scgId
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @scgId,  3603,8,  @encryptionKeyLength,0,  '',  @currentTime,0)
	END
	-- '@cipherType'
	UPDATE APP_COMPONENTPROP
	SET longVal = @cipherType
WHERE propertyTypeId = 3602
	AND componentId = @scgId
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @scgId,  3602,8,  @cipherType,0,  '',  @currentTime,0)
	END
	-- '@directMediaAccess'
	UPDATE APP_COMPONENTPROP
	SET longVal = @directMediaAccess
WHERE propertyTypeId = 3604
	AND componentId = @scgId
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @scgId,  3604,8,  @directMediaAccess,0,  '',  @currentTime,0)
	END
END
-- Insert the props into App_company prop and use checksum for faster access.
-- Company ID 0 is Commcell
IF @i_companyId <> -1
BEGIN
	UPDATE App_CompanyProp
	SET attrval = @encryptionSettings
WHERE attrName = 'Encryption Settings'
	AND componentNameId = @i_companyId
and modified = 0 AND cs_attrName = CHECKSUM('Encryption Settings')
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Encryption Settings', 7, @encryptionSettings, @currentTime, 0)
		SET @firstTime = 1
	END
	UPDATE App_CompanyProp
	SET attrval = @cipherType
WHERE attrName = 'Encrypt: Type'
	AND componentNameId = @i_companyId
and modified = 0 AND cs_attrName = CHECKSUM('Encrypt: Type')
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Encrypt: Type', 7, @cipherType, @currentTime, 0)
	END
	UPDATE App_CompanyProp
	SET attrval = @encryptionKeyLength
WHERE attrName = 'Encrypt: Key Length'
	AND componentNameId = @i_companyId
and modified = 0 AND cs_attrName = CHECKSUM('Encrypt: Key Length')
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Encrypt: Key Length', 7, @encryptionKeyLength, @currentTime, 0)
	END
	UPDATE App_CompanyProp
	SET attrval = @directMediaAccess
WHERE attrName = 'Encrypt: drToolAccess'
	AND componentNameId = @i_companyId
and modified = 0 AND cs_attrName = CHECKSUM('Encrypt: drToolAccess')
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Encrypt: drToolAccess', 7, @directMediaAccess, @currentTime, 0)
	END
	IF @firstTime = 1
	BEGIN
SET @syncClientsEncXML = ( SELECT 61 '@entityType', @i_companyId '@entityId', 1 '@operationType'
								FOR XML PATH('Api_SyncEncryptionSettingsReq')
							  )
	END
END
-- Insert the props into App_PlanProp
IF @i_planId > 0
BEGIN
IF NOT EXISTS ( SELECT 1 FROM App_PlanProp PP WITH(NOLOCK) WHERE PP.componentNameId = @i_planId AND PP.attrName = 'Encryption Settings')
	BEGIN
		SET @firstTime = 1
	END
EXEC AppPlanSetEntityValueV2 @i_planId, 'Encryption Settings', @encryptionSettings, @errorCode OUTPUT, @errorString OUTPUT
	IF (@errorCode = 0)
	BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Encrypt: Type', @cipherType , @errorCode OUTPUT, @errorString OUTPUT
	END
	IF (@errorCode = 0)
	BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Encrypt: Key Length', @encryptionKeyLength , @errorCode OUTPUT, @errorString OUTPUT
	END
	IF (@errorCode = 0)
	BEGIN
EXEC AppPlanSetEntityValueV2 @i_planId, 'Encrypt: drToolAccess', @directMediaAccess  , @errorCode OUTPUT, @errorString OUTPUT
	END
	IF @firstTime = 1
	BEGIN
SET @syncClientsEncXML = ( SELECT 158 '@entityType', @i_planId '@entityId', 1 '@operationType'
								FOR XML PATH('Api_SyncEncryptionSettingsReq')
							  )
	END
END
-- If the company or plan has an encryption setting set
-- Then clients where encryption is not set does not override.
IF @encryptionSettings <> 2 --OFF
BEGIN
	-- Insert the property iff the property does not exist on client; default is NOT_SET
	MERGE  App_ClientProp as Dest
	USING (SELECT distinct C.id as clientId FROM App_client C JOIN App_clientProp cprop
			ON C.id = cprop.componentNameId
WHERE cprop.attrName = 'Installation Company ID' and cprop.attrval = @i_companyId) AS Src
	on  Dest.componentNameId = Src.clientId
AND Dest.attrName = 'Override Global Encryption Settings'
	WHEN MATCHED THEN
		UPDATE SET dest.attrval = N'0'
	WHEN NOT MATCHED THEN
		INSERT  (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
Values( Src.clientId, 'Override Global Encryption Settings', 7, N'0', @currentTime, 0, 0);  --OFF
END
IF @firstTime = 1
BEGIN
	IF @syncClientsEncXML IS NOT NULL
	BEGIN
		IF OBJECT_ID('tempdb..#lt_SyncSettingsOutput') IS NOT NULL DROP TABLE #lt_SyncSettingsOutput
        CREATE TABLE #lt_SyncSettingsOutput (o_xml xml)
        EXEC AppSyncEncryptionSettings @syncClientsEncXML
        IF OBJECT_ID('tempdb..#lt_SyncSettingsOutput') IS NOT NULL DROP TABLE #lt_SyncSettingsOutput
	END
END
	IF @isOutputRequired = 1
	BEGIN
		EXEC AppGetEncryptionSettings @entityId, @entityType, @localeId, @userId, 0, @o_afterUpdateXML OUTPUT
	END
	ENDSP:
	IF @errorString = N''
	BEGIN
		SET @errorString =(SELECT Message
						from EvLocaleMsgs
						where EvLocaleMsgs.MessageId = @errorCode
						AND [localeId] = @localeId)
	END
	SET @o_errorCode = @errorCode
	SET @o_errorString = @errorString
	IF @isFromCPP = 1
	BEGIN
		SELECT  @scgId as scgId, @errorCode as errorCode,@errorString as errorString, @o_beforeUpdateXML AS beforeUpdateXML, @o_afterUpdateXML AS afterUpdateXML
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEncryptionSettings')
	delete from GxQscripts where name = 'AppSetEncryptionSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEncryptionSettings')
	delete from GXDBVersions where aliasname = 'AppSetEncryptionSettings'
GO

insert into GXDBVersions values(2, 'AppSetEncryptionSettings',  '00000000000000000000', 'AppSetEncryptionSettings', '00000000000000000000')
GO

