

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEmailConfigDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetEmailConfigDetails.sp,v $ $Id: AppSetEmailConfigDetails.sp,v 1.2.34.7 2020/11/27 17:00:08 kbora Exp $";
-- =============================================
-- Author:		Jaya Rama Raju Inavolu
-- Create date: 08/19/2013
-- Description:	To get the email server details
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetEmailConfigDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppSetEmailConfigDetails <<<'
	drop procedure AppSetEmailConfigDetails
END
IF EXISTS (select * from GxQscripts where name='AppSetEmailConfigDetails')
	delete from GxQscripts where name = 'AppSetEmailConfigDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEmailConfigDetails')
	delete from GXDBVersions where aliasname = 'AppSetEmailConfigDetails'
GO
print '... Creating Procedure: AppSetEmailConfigDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetEmailConfigDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inputXml xml
AS
  DECLARE @o_responseXML xml
BEGIN
	DECLARE @emailMaxMesgSize	bigint	--EVSMTPMaxMessKB
	declare @smtpServer nvarchar(256)
	declare @smtpPort int
	declare @displayName nvarchar(max)
	declare @strFrom nvarchar(max)
	declare @smtpPassword nvarchar(max)
	declare @smtpUserName nvarchar(max)
	declare @smtpSSL int
	declare @reqCred int
	declare @o_xmlMsg xml
	DECLARE @startTLS INT
	declare @errorCode  int
	set @errorCode = 0
	declare @errorMessage nvarchar(max)
	set @errorMessage = ''
	declare @userId int
	DECLARE @workTokenId INT = 48 -- WORK_TOKEN_REFRESH_SMTP_CONFIG
	SET @userId = isnull((select  ref.value('@userId', 'int') AS col1
         from @inputXml.nodes('App_SetSMTPInfo/processinginstructioninfo/user') R ( ref )),0)
	declare @userHasCapability int = 0
EXEC sec_checkPermissionOnEntity @userId, 1, @userHasCapability OUTPUT, 1, 2	-- commcell entity. commcellid =2
	if(@userHasCapability = 0)
	begin
		set @errorCode	= 1
set @errorMessage = ( select message from EvLocaleMsgs where messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and [localeId] = 0 )
		SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString' FOR XML PATH ( 'App_GenericEntityResponse' ))
		goto SEND_RESPONSE
	end
begin try
	begin tran
	SET @smtpServer = (SELECT  ref.value('@smtpServer', 'nvarchar(256)') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo') R ( ref ))
	SET @smtpPort = (SELECT  ref.value('@smtpPort', 'int') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo') R ( ref ))
	SET @emailMaxMesgSize = (SELECT  ref.value('@maxMailServerSize', 'bigint') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo') R ( ref ))
	SET @displayName = (SELECT  ref.value('@senderName', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo/senderInfo') R ( ref ))
	SET @strFrom = (SELECT  ref.value('@senderAddress', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo/senderInfo') R ( ref ))
	SET @reqCred = (SELECT  ref.value('@useAuthentication', 'int') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo') R ( ref ))
	SET @smtpSSL = (SELECT  ref.value('@enableSSL', 'int') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo') R ( ref ))
	SET @smtpUserName = (SELECT  ref.value('@userName', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo/userInfo') R ( ref ))
	SET @smtpPassword = (SELECT  ref.value('@password', 'nvarchar(max)') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo/userInfo') R ( ref ))
	if @smtpPassword is not null and len(@smtpPassword)>0
	begin
		IF((CHARINDEX('|#',@smtpPassword, 1)) >0 )
		BEGIN
			SET @smtpPassword = dbo.DecodeInvalidXMLChar(@smtpPassword)
			SET @smtpPassword = SUBSTRING(@smtpPassword,2,LEN(@smtpPassword))
			SET  @smtpPassword = dbo.base64decode(@smtpPassword)
		END
		ELSE
		BEGIN
			SET  @smtpPassword = dbo.EncodeSecretCLR(@smtpPassword)
		END
	end
	SET @startTLS = (SELECT  ref.value('@startTLS', 'int') AS Agent
      FROM    @inputXml.nodes('App_SetSMTPInfo/smtpInfo') R ( ref ))
	if @smtpServer is not null and len(@smtpServer)>0
	begin
		update App_commcell
		set smtpServer=@smtpServer
		where id = 2
	end
	/*
	delete from GxGlobalParam
	where modified=0 and name in
	(
		'EVSMTPport','EVSMTPDisplayName','EVSMTPSender','EVSMTPUsername','EVSMTPSSL','EVSMTPIsCredentialRequired','EVSMTPMaxMessKB'
	)
	*/
	if @smtpPort is not null
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPport'
		Insert into GxGlobalParam
		select 'EVSMTPport',@smtpPort,dbo.GetUnixTime(GETutcDATE()),0
	end
	if @displayName is not null and len(@displayName)>0
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPDisplayName'
		Insert into GxGlobalParam
		select 'EVSMTPDisplayName',@displayName,dbo.GetUnixTime(GETutcDATE()),0
	end
	if @strFrom is not null and len(@strFrom)>0
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPSender'
		Insert into GxGlobalParam
		select 'EVSMTPSender',@strFrom,dbo.GetUnixTime(GETutcDATE()),0
	end
	if @smtpPassword is not null and len(@smtpPassword)>0
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPPassword'
		Insert into GxGlobalParam
		select 'EVSMTPPassword',@smtpPassword,dbo.GetUnixTime(GETutcDATE()),0
	end
	if @smtpUserName is not null and len(@smtpUserName)>0
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPUsername'
		Insert into GxGlobalParam
		select 'EVSMTPUsername',@smtpUserName,dbo.GetUnixTime(GETutcDATE()),0
	end
	IF @startTLS IS NOT NULL
	BEGIN
		DELETE FROM GxGlobalParam
		WHERE modified=0 AND name='EVSMTPTLS'
		INSERT INTO GxGlobalParam
		SELECT 'EVSMTPTLS',@startTLS,dbo.GetUnixTime(GETutcDATE()),0
	END
	ELSE
		SELECT @startTLS = CAST(value AS INT) FROM GxGlobalParam WHERE modified = 0 AND name='EVSMTPTLS'
	if @smtpSSL IS NOT NULL AND NOT(@smtpSSL = 1 AND @startTLS = 1)
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPSSL'
		Insert into GxGlobalParam
		select 'EVSMTPSSL',@smtpSSL,dbo.GetUnixTime(GETutcDATE()),0
	end
	if @reqCred  is not null
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPIsCredentialRequired'
		Insert into GxGlobalParam
		select 'EVSMTPIsCredentialRequired',@reqCred,dbo.GetUnixTime(GETutcDATE()),0
	end
	if @emailMaxMesgSize is not null
	begin
		delete from GxGlobalParam
		where modified=0 and name='EVSMTPMaxMessKB'
		Insert into GxGlobalParam
		select 'EVSMTPMaxMessKB',@emailMaxMesgSize,dbo.GetUnixTime(GETutcDATE()),0
	end
	-- Submit workqueue request to all failover nodes to refresh SMTP config.
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT C.Id,
		@workTokenId,
		'',
		dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1
		FROM SimInstalledPackages WITH (READUNCOMMITTED)
        INNER JOIN App_client C WITH (READUNCOMMITTED) on SimInstalledPackages.clientId = C.Id
and (C.status&2)=0 and simPackageID IN (24, 1024)
	commit tran
	SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString' FOR XML PATH ( 'App_GenericEntityResponse' ))
End Try
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRANSACTION
    SET @errorCode = 1
    set @errorMessage = 'Error in setting smtp properties'
    SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString' FOR XML PATH ( 'App_GenericEntityResponse' ))
END CATCH
SEND_RESPONSE:
select @o_xmlMsg as o_responseXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEmailConfigDetails')
	delete from GxQscripts where name = 'AppSetEmailConfigDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEmailConfigDetails')
	delete from GXDBVersions where aliasname = 'AppSetEmailConfigDetails'
GO

insert into GXDBVersions values(2, 'AppSetEmailConfigDetails',  '00010002003400070000', 'AppSetEmailConfigDetails', '00010002003400070000')
GO

