

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEdgeWebServerUrl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetEdgeWebServerUrl.sp,v $ $Id: AppSetEdgeWebServerUrl.sp,v 1.3 2014/04/03 21:17:51 gpattabiraman Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Constructs the edge web server URl for an edge subclient
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetEdgeWebServerUrl <<<'

IF EXISTS (select * from sysobjects where name='AppSetEdgeWebServerUrl')
	drop procedure AppSetEdgeWebServerUrl
IF EXISTS (select * from GxQscripts where name='AppSetEdgeWebServerUrl')
	delete from GxQscripts where name = 'AppSetEdgeWebServerUrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEdgeWebServerUrl')
	delete from GXDBVersions where aliasname = 'AppSetEdgeWebServerUrl'
GO
print '... Creating Procedure: AppSetEdgeWebServerUrl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetEdgeWebServerUrl
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inAppId INT,
  @inClientId INT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET @errorCode = 0
DECLARE @memberServerList NVARCHAR(MAX) = ''
DECLARE @memberServerTbl TABLE
( rowId INT,
  clientId INT)
DECLARE @numServers INT = 0
DECLARE @memberRow INT = 0
DECLARE @webServerClientId INT = 0
DECLARE @hostname NVARCHAR(MAX) = ''
DECLARE @portNum NVARCHAR(MAX) = ''
DECLARE @webServerAlias NVARCHAR(MAX) = ''
DECLARE @webServerUrl NVARCHAR(MAX) = ''
DECLARE @currentTime INT  = dbo.GetUnixTime(GETUTCDATE())
SET @memberServerList = ISNULL((SELECT attrVal FROM APP_ClientProp
								WHERE componentNameId = @inClientId
								AND modified = 0
								AND attrName = 'Object Server Member Servers List'), '')
IF @memberServerList = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Member Server List is empty.'
	GOTO PROC_END
END
INSERT INTO @memberServerTbl
SELECT ROW_NUMBER() OVER(ORDER BY data ASC), data
FROM dbo.SplitString(@memberServerList, ',')
SET @numServers = (SELECT COUNT(*) FROM @memberServerTbl)
IF @numServers > 1
	SET @memberRow = (@inAppId % @numServers)
IF @memberRow = 0 SET @memberRow = @numServers
SET @webServerClientId = (SELECT clientId FROM @memberServerTbl WHERE rowId = @memberRow)
-- DM2WebService Web Site Port
-- DM2WebService Search Web Alias
IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id= @webServerClientId)
BEGIN
	SET @errorCode = 2
	SET @errorString = 'Invalid Member Server property in client.'
	GOTO PROC_END
END
SELECT @hostname = net_hostname
FROM APP_Client
WHERE id = @webServerClientId
SET @portNum = ISNULL((SELECT attrVal
					  FROM APP_ClientProp
					  WHERE componentNameId = @webServerClientId
					  AND attrName = 'DM2WebService Web Site Port'
					  AND modified = 0), 0)
SET @webServerAlias = ISNULL((SELECT attrVal
							  FROM APP_ClientProp
							  WHERE componentNameId = @webServerClientId
							  AND attrName = 'DM2WebService Search Web Alias'
					          AND modified = 0), 0)
-- For Safety
UPDATE APP_SubClientProp
SET modified = @currentTime
WHERE componentNameId = @inAppId
AND attrName IN ('Edge Web Server URL', 'Edge Web Server')
AND modified = 0
SET @webServerUrl = 'http://' + @hostname + ':' + @portNum + '/' + @webServerAlias + '/'
INSERT INTO APP_SubClientProp
VALUES(@inAppId, 'Edge Web Server URL', 1, @webServerUrl, @currentTime, 0, 0)
INSERT INTO APP_SubClientProp
VALUES(@inAppId, 'Edge Web Server', 7, @webServerClientId, @currentTime, 0, 0)
PROC_END:
SELECT @errorCode, @errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEdgeWebServerUrl')
	delete from GxQscripts where name = 'AppSetEdgeWebServerUrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEdgeWebServerUrl')
	delete from GXDBVersions where aliasname = 'AppSetEdgeWebServerUrl'
GO

insert into GXDBVersions values(2, 'AppSetEdgeWebServerUrl',  '00010003000000000000', 'AppSetEdgeWebServerUrl', '00010003000000000000')
GO

