

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEdgeDriveExternalGroupForLaptopOEM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetEdgeDriveExternalGroupForLaptopOEM.sp,v $ $Id: AppSetEdgeDriveExternalGroupForLaptopOEM.sp,v 1.3.14.3 2018/07/05 16:32:58 nshah Exp $";
--	+===================================================================+
--	|  					  AppSetEdgeDriveExternalGroupForLaptopOEM							|
--	|          Procedure for associating external group associated with internal group Laptop Users to Edge Drive				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetEdgeDriveExternalGroupForLaptopOEM <<<'

IF EXISTS (select * from sysobjects where name='AppSetEdgeDriveExternalGroupForLaptopOEM')
	drop procedure AppSetEdgeDriveExternalGroupForLaptopOEM
IF EXISTS (select * from GxQscripts where name='AppSetEdgeDriveExternalGroupForLaptopOEM')
	delete from GxQscripts where name = 'AppSetEdgeDriveExternalGroupForLaptopOEM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEdgeDriveExternalGroupForLaptopOEM')
	delete from GXDBVersions where aliasname = 'AppSetEdgeDriveExternalGroupForLaptopOEM'
GO
print '... Creating Procedure: AppSetEdgeDriveExternalGroupForLaptopOEM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetEdgeDriveExternalGroupForLaptopOEM
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @externalGroupId INT
-----------------------------------------------------------
AS
  DECLARE @errorCode INT
  DECLARE @errorString nvarchar(max)
SET NOCOUNT ON
BEGIN
	DECLARE @clientId integer
	DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
	SET @errorCode = 0
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @clientId = ISNULL((SELECT id FROM APP_Client WHERE name = 'EdgeDrive') ,0)
	IF @clientId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = N'Invalid Client Id for Edge Drive'
	END
	IF NOT EXISTS (SELECT * FROM App_EdgeDriveAssociation
		WHERE clientId = @clientId AND entityType = 62 AND entityId = @externalGroupId )
	AND EXISTS (SELECT * FROM App_EdgeDriveAssociation WHERE clientId = @clientId AND entityType = 15
		AND entityId = (SELECT id FROM UMGroups WHERE name = 'Laptop Users'))
	BEGIN
		INSERT INTO App_EdgeDriveAssociation
           (clientId
           ,entityType
           ,entityId)
		 VALUES
		   (@clientId
		   ,62
		   ,@externalGroupId)
		   DELETE FROM UMGroupsProp WHERE componentNameId = @externalGroupId AND attrType = 130 AND attrName = @clientId
		   INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES(@externalGroupId, CAST(@clientId AS NVARCHAR(MAX)), 130, CAST(549755818032 AS NVARCHAR(MAX)), @nowTime, 0)
	END
	SELECT @errorCode, @errorString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEdgeDriveExternalGroupForLaptopOEM')
	delete from GxQscripts where name = 'AppSetEdgeDriveExternalGroupForLaptopOEM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEdgeDriveExternalGroupForLaptopOEM')
	delete from GXDBVersions where aliasname = 'AppSetEdgeDriveExternalGroupForLaptopOEM'
GO

insert into GXDBVersions values(2, 'AppSetEdgeDriveExternalGroupForLaptopOEM',  '00010003001400030000', 'AppSetEdgeDriveExternalGroupForLaptopOEM', '00010003001400030000')
GO

