

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEdgeDriveAndGroupsAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetEdgeDriveAndGroupsAssoc.sp,v $ $Id: AppSetEdgeDriveAndGroupsAssoc.sp,v 1.16.2.16 2019/12/27 12:22:17 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppSetEdgeDriveAndGroupsAssoc()
--  |
--  | Description:  SP for setting User Group associations for and edge drive client
--  |
--  |       Input:  XML containing client and User Groups(Internal/External) associations
--  |				opType - Type of operation to be performed on associations
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  riyer  	To Update Edge Drive user group associations for an Edge Drive Client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetEdgeDriveAndGroupsAssoc')
BEGIN
	print '>>> Drop Stored Procedure: AppSetEdgeDriveAndGroupsAssoc <<<'
	drop procedure AppSetEdgeDriveAndGroupsAssoc
END
IF EXISTS (select * from GxQscripts where name='AppSetEdgeDriveAndGroupsAssoc')
	delete from GxQscripts where name = 'AppSetEdgeDriveAndGroupsAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEdgeDriveAndGroupsAssoc')
	delete from GXDBVersions where aliasname = 'AppSetEdgeDriveAndGroupsAssoc'
GO
print '... Creating Procedure: AppSetEdgeDriveAndGroupsAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetEdgeDriveAndGroupsAssoc
  @opType INT,
  @i_xml XML	
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
--use CommServ
DECLARE @clientId integer
DECLARE @indexServerId int
DECLARE @i_umdsGroups XML
DECLARE @inputEntity XML
DECLARE @subclientPolicyAppId INT = 0
DECLARE @indexServerHostname NVARCHAR(MAX) = ''
DECLARE @indexServerPortNum NVARCHAR(MAX) = ''
DECLARE @indexServerWebServerAlias NVARCHAR(MAX) = ''
DECLARE @webserverId int = 0
DECLARE @webserverURL NVARCHAR(MAX) = ''
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @oldIndexServerId INT = 0
DECLARE @contentStoreClientType	 int = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/edgeDriveAssociations/clientEntity') R ( ref )),0)
DECLARE @clientName nvarchar(max)= ISNULL((SELECT  ref.value('@clientName', 'nvarchar(max)') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/edgeDriveAssociations/clientEntity') R ( ref )),'')
IF @clientId =0 AND LEN(@clientName) > 0
BEGIN
	SET @clientId = ISNULL((SELECT id FROM App_Client WHERE name = @clientName),0)
END
SET @indexServerId = ISNULL((SELECT  ref.value('@clientId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/edgeDriveAssociations/indexServer') R ( ref )),0)
SET @subclientPolicyAppId = ISNULL(( SELECT TOP 1 APP.id
									 FROM App_EdgeDriveAssociation EDA
									 INNER JOIN APP_Application APP ON EDA.entityType = 65 AND EDA.entityId = APP.backupSet --SUBCLIENT_POLICY_ENTITY
									 WHERE EDA.clientId = @clientId), 0)
DECLARE @adminUser INT = (SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE flags & 0x040 <> 0)
DECLARE @userTbl TABLE
(
	userId INT,
	capabilities BIGINT
)
DECLARE @internalGroupTbl TABLE
(
	groupId INT,
	groupName varchar(MAX),
	capabilities BIGINT
)
DECLARE @externalGroupTbl TABLE
(
	groupId		INT,
	groupName 	nvarchar(MAX),
	providerId	INT,
	mailId		nvarchar(MAX),
	capabilities BIGINT
)
DECLARE @contentStoreExternalGroups TABLE
(
	groupId		INT,
	groupName 	nvarchar(MAX),
	providerId	INT,
	mailId		nvarchar(MAX),
	capabilities BIGINT
)
DECLARE @oldEdgeDriveAssociations TABLE
(
	entityType INT,
	entityId   INT
)
DECLARE @usersToDecouple TABLE
(userId INT, subclientId INT, capabilities BIGINT)
DECLARE @inputCapabilities INT
DECLARE @inputUserId 	INT
DECLARE @inputExternalGrpName 	NVARCHAR(MAX)
DECLARE @inputProviderId 	INT
DECLARE @inputMailId 		NVARCHAR(MAX)
DECLARE @inputExternalGrpId			INT
DECLARE @inputInternalGrpId 	INT
INSERT INTO @userTbl
SELECT  IsNull(ref.value('user[1]/@userId', 'int'),0), ISNULL(ref.value('@capabilities','BIGINT'), 0)
FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/edgeDriveAssociations/userCapabilities') R ( ref )
INSERT INTO @internalGroupTbl
SELECT  IsNull(ref.value('group[1]/@userGroupId', 'int'),0),
IsNull(ref.value('group[1]/@userGroupName', 'varchar(MAX)'),''),
ISNULL(ref.value('@capabilities','BIGINT'), 0)
FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/edgeDriveAssociations/userGroupCapabilities') R ( ref )
UPDATE @internalGroupTbl
SET groupId = UMGroups.id
FROM UMGroups INNER JOIN @internalGroupTbl I ON UMGroups.name = I.groupName
WHERE groupId = 0
INSERT INTO @externalGroupTbl(groupName , providerId , mailId , capabilities)
SELECT  ISNULL(ref.value('externalGroup[1]/@name', 'NVARCHAR(MAX)'),''),
		ISNULL(ref.value('externalGroup[1]/@umdsProviderId', 'int'),0),
		ISNULL(ref.value('externalGroup[1]/@email', 'NVARCHAR(MAX)'),''),
		ISNULL(ref.value('@capabilities','BIGINT'), 0)
FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/edgeDriveAssociations/externalGroupCapabilities') R ( ref )
INSERT INTO @contentStoreExternalGroups(groupName , providerId , mailId , capabilities)
SELECT  ISNULL(ref.value('externalGroup[1]/@name', 'NVARCHAR(MAX)'),''),
		ISNULL(ref.value('externalGroup[1]/@umdsProviderId', 'int'),0),
		ISNULL(ref.value('externalGroup[1]/@email', 'NVARCHAR(MAX)'),''),
		ISNULL(ref.value('@capabilities','BIGINT'), 0)
FROM    @i_xml.nodes('App_EdgeDrivePseudoClientProperties/outlookAddinStoreInfo/userGroups') R ( ref )
SET @errorCode = 0
SET @errorString = ''
BEGIN TRY
IF (@clientId IS NULL OR
	@clientId = 0 OR
	NOT EXISTS (SELECT * FROM APP_Client with(nolock) WHERE id = @clientId))
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Given client is not valid'
	GOTO GENERATE_OUTPUT
END
	IF (@opType <> 1 AND @opType <> 2 AND @opType <> 3)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid Operation Type'
		GOTO GENERATE_OUTPUT
 	END
	-- Handle System drive
IF EXISTS(SELECT 1 FROM APP_Client with(nolock) WHERE id = @clientId AND status & 0x40000000 <> 0)
	BEGIN
		SET @contentStoreClientType =	ISNULL((SELECT CAST(attrVal AS INT)
												FROM App_ClientProp
												WHERE componentNameId = @clientId AND modified = 0 AND attrName = 'System Drive Type'), 0)
		UPDATE @userTbl
		SET capabilities = (SELECT dbo.BitwiseOR(CONVERT(BIGINT, POWER(2.0, capabilityId -1)))
							FROM UMDM2EntityCapability
							WHERE entityType = 9513)
	END
	-- Index server is mandatory for Add and Overwrite operations.
	--IF (@opType <> 3) AND (@indexServerId <= 0)
	--BEGIN
		--SET @errorCode = 3
		--SET @errorString = 'Invalid or missing Index server information in request.'
		--GOTO GENERATE_OUTPUT
	--END
	-- 1. OVERWRITE
	-- 2. ADD
	-- 3. DELETE
IF @opType = 1 OR @opType = 2	---ADD OR OVERWRITE
BEGIN
	IF @opType = 1     --Overwrite case we need to delete existing associations first
	BEGIN
		INSERT INTO @oldEdgeDriveAssociations
		SELECT entityType, entityId FROM App_EdgeDriveAssociation WHERE clientId = @clientId
		DELETE FROM App_EdgeDriveAssociation WHERE clientId = @clientId AND entityType IN (13, 15, 62) -- USER_ENTITY, USERGROUP_ENTITY, EXTERNAL_GROUP_ENTITY
		DELETE FROM UMUsersProp
		WHERE attrType = 130 AND attrName = CAST (@clientId AS NVARCHAR(10))
		AND componentNameId NOT IN (SELECT userId FROM @userTbl)
		DELETE FROM UMGroupsProp
		WHERE attrType = 130 AND attrName = CAST (@clientId AS NVARCHAR(10))
		AND componentNameId NOT IN (SELECT groupId FROM @internalGroupTbl)
		DELETE FROM APP_ClientProp
		WHERE componentNameId = @clientId
		AND attrName = 'OutlookAddin ContentStore UserGroups'
	END
	--***********************USER ASSOCIATION*******************************
	MERGE App_EdgeDriveAssociation AS ASSOC
	USING(SELECT userId FROM @userTbl) AS U(userId)
	ON (ASSOC.entityType = 13 AND ASSOC.entityId = U.userId AND ASSOC.clientId = @clientId)
	WHEN NOT MATCHED THEN
		INSERT (clientId, entityType, entityId)
		VALUES(@clientId, 13, userId);
	MERGE UMUsersProp AS UPROP
	USING(SELECT userId, capabilities FROM @userTbl) AS U(userId, capabilities)
	ON (UPROP.componentNameId = U.userId AND UPROP.attrType = 130 AND UPROP.modified = 0 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(10)) )
	WHEN MATCHED THEN
		UPDATE SET UPROP.attrVal = CAST(U.capabilities AS NVARCHAR(MAX))
	WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(U.userId, CAST(@clientId AS NVARCHAR(10)), 130, CAST(U.capabilities AS NVARCHAR(MAX)), @nowTime, 0);
	--***********************INTERNAL GROUP ASSOCIATION*******************************
	MERGE App_EdgeDriveAssociation AS ASSOC
	USING(SELECT DISTINCT groupId FROM @internalGroupTbl) AS GP(groupId)
	ON (ASSOC.entityType = 15 AND ASSOC.entityId = GP.groupId AND ASSOC.clientId = @clientId)
	WHEN NOT MATCHED THEN
		INSERT (clientId, entityType, entityId)
		VALUES(@clientId, 15, groupId);
	MERGE UMGroupsProp AS UPROP
	USING(SELECT groupId, capabilities FROM @internalGroupTbl) AS U(groupId, capabilities)
	ON (UPROP.componentNameId = U.groupId AND UPROP.attrType = 130 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(MAX)))
	WHEN MATCHED THEN
		UPDATE SET UPROP.attrVal = CAST(U.capabilities AS NVARCHAR(MAX))
	WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(U.groupId, CAST(@clientId AS NVARCHAR(MAX)), 130, CAST(U.capabilities AS NVARCHAR(MAX)), @nowTime, 0);
		--***********************EXTERNAL GROUP ASSOCIATION*******************************
	-- First check and insert groups if not exists.
	MERGE UMGroups AS UG
	USING(SELECT groupName, providerId, mailId FROM @externalGroupTbl WHERE providerId > 0 AND groupName != '') AS GP(groupName, providerId, mailId)
	ON (UG.name = GP.groupName AND UG.umdsProviderId = GP.providerId)
	WHEN MATCHED THEN
		UPDATE SET groupFlags = groupFlags & ~2 -- Enable and Undelete the group.
	WHEN NOT MATCHED THEN
		INSERT (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
		VALUES(1, 0, 0, 1, groupName, '', 2, NEWID(), providerId,  mailId, 0);
	-- Get the Ids and then insert them as associations
	UPDATE @externalGroupTbl
	SET groupId = UG.id
	FROM @externalGroupTbl G
	INNER JOIN UMGroups UG ON G.groupName = UG.name AND G.providerId = UG.umdsProviderId
	-- Create entries in UMDSGroup table also
	MERGE UMDSgroups AS UG
	USING(SELECT groupId, groupName, providerId, mailId FROM @externalGroupTbl WHERE providerId > 0 AND groupName != '') AS GP(groupId, groupName, providerId, mailId)
	ON (UG.id = GP.groupId AND UG.umdsProviderId = GP.providerId)
	WHEN MATCHED THEN
		UPDATE SET enabled = 1
	WHEN NOT MATCHED THEN
		INSERT (id, umdsProviderId, enabled, name, description, email, lastCredSetTime, oldId)
		VALUES(groupId, providerId, 1, groupName, '', mailId, 0, 0);
	MERGE App_EdgeDriveAssociation AS ASSOC
	USING(SELECT DISTINCT groupId FROM @externalGroupTbl) AS GP(groupId)
	ON (ASSOC.entityType = 62 AND ASSOC.entityId = GP.groupId AND ASSOC.clientId = @clientId)
	WHEN NOT MATCHED THEN
		INSERT (clientId, entityType, entityId)
		VALUES(@clientId, 62, groupId);
	MERGE UMGroupsProp AS UPROP
	USING(SELECT groupId, capabilities FROM @externalGroupTbl) AS U(groupId, capabilities)
	ON (UPROP.componentNameId = U.groupId AND UPROP.attrType = 130 AND UPROP.modified = 0 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(10)) )
	WHEN MATCHED THEN
		UPDATE SET UPROP.attrVal = CAST(U.capabilities AS NVARCHAR(MAX))
	WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(U.groupId, CAST(@clientId AS NVARCHAR(MAX)), 130, CAST(U.capabilities AS NVARCHAR(MAX)), @nowTime, 0);
	IF EXISTS(SELECT 1 FROM @contentStoreExternalGroups)
	BEGIN
		-- First check and insert groups if not exists.
		MERGE UMGroups AS UG
		USING(SELECT groupName, providerId, mailId FROM @contentStoreExternalGroups WHERE providerId > 0 AND groupName != '') AS GP(groupName, providerId, mailId)
		ON (UG.name = GP.groupName AND UG.umdsProviderId = GP.providerId)
		WHEN MATCHED THEN
			UPDATE SET groupFlags = groupFlags | 1 ^ 2 -- Enable and Undelete the group.
		WHEN NOT MATCHED THEN
			INSERT (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
			VALUES(1, 0, 0, 1, groupName, '', 2, NEWID(), providerId,  mailId, 0);
		-- Get the Ids and then insert them as associations
		UPDATE @contentStoreExternalGroups
		SET groupId = UG.id
		FROM @contentStoreExternalGroups G
		INNER JOIN UMGroups UG ON G.groupName = UG.name AND G.providerId = UG.umdsProviderId
		-- Create entries in UMDSGroup table also
		MERGE UMDSgroups AS UG
		USING(SELECT groupId, groupName, providerId, mailId FROM @contentStoreExternalGroups WHERE providerId > 0 AND groupName != '') AS GP(groupId, groupName, providerId, mailId)
		ON (UG.id = GP.groupId AND UG.umdsProviderId = GP.providerId)
		WHEN MATCHED THEN
			UPDATE SET enabled = 1
		WHEN NOT MATCHED THEN
		INSERT (id, umdsProviderId, enabled, name, description, email, lastCredSetTime, oldId)
		VALUES(groupId, providerId, 1, groupName, '', mailId, 0, 0);
		DECLARE @contentStoreGroups NVARCHAR(MAX) = (SELECT STUFF(( SELECT ':' + CAST(G.groupId AS NVARCHAR(MAX))
																	FROM @contentStoreExternalGroups G
																	FOR XML PATH('')),1,1,'') AS CSV)
		INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(@clientId, 'OutlookAddin ContentStore UserGroups', 1, @contentStoreGroups, @nowTime, 0)
	END
	--**********************************************************************************
	SET @oldIndexServerId = ISNULL((SELECT entityId FROM App_EdgeDriveAssociation WHERE clientId = @clientId AND entityType = 3), 0)
	-- Media Agent Overwrite
	IF @opType = 1 AND @indexServerId <> @oldIndexServerId
	BEGIN
		DELETE FROM App_EdgeDriveAssociation WHERE clientId = @clientId AND entityType = 3
		-- Remove the index server URL from the subclient policy subclient properties too
		DELETE APP_SubClientProp
		WHERE componentNameId = @subclientPolicyAppId
		AND attrName IN (N'Edge Web Server', N'Edge Web Server URL') AND modified = 0 AND cs_attrName IN (CHECKSUM(N'Edge Web Server'), CHECKSUM(N'Edge Web Server URL'))
	END
	IF @indexServerId <> @oldIndexServerId AND @indexServerId <> 0
	BEGIN
		INSERT INTO App_EdgeDriveAssociation(clientId , entityType , entityId)
		VALUES (@clientId, 3, @indexServerId)
		SELECT @webserverId = clientId, @webserverURL = webSvcUrl from dbo.AppGetWebSvcUrlForIndexServer(@indexServerId, 0, 0)
		IF @webserverId = 0 OR @webserverURL = ''
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Invalid index server [' + CAST(@indexServerId AS NVARCHAR(MAX)) + '] in Edge drive association. Failed to construct web server URL.'
			GOTO GENERATE_OUTPUT
		END
		-- Save the props on subclient policy
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES	(@subclientPolicyAppId, 'Edge Web Server', 7, CAST(@webserverId as NVARCHAR(10)), @nowTime, 0, 0),
				(@subclientPolicyAppId, 'Edge Web Server URL', 1, @webserverURL, @nowTime, 0, 0)
	END
	-----------------------------------------------------------------------------------
	------------------------ Capability for Edge Drive --------------------------------
	-----------------------------------------------------------------------------------
	DECLARE @allEdgeCapabilities TABLE
	(capabilityId INT, capabilityValue BIGINT)
	INSERT INTO @allEdgeCapabilities
	SELECT id, CAST(POWER(2.0, id - 1) AS BIGINT)
	FROM UMCapability
	WHERE name in ('Upload', 'Download', 'Browse', 'In Place Recover', 'Out of Place Recover', 'Sharing')
	AND (name <> 'Upload' OR @contentStoreClientType <> 3) -- RECORDS_MANAGER in App.x. No edit rights.
	DECLARE @edgeAppIdInfo TABLE
	(edgeSubClientId INT, edgeUserId INT, capabilities BIGINT)
	DECLARE @edgeCapabilities TABLE
	(edgeUserId INT, capabilties BIGINT)
	DECLARE @oldEdgeCapabilities TABLE
	(edgeUserId INT, capabilities BIGINT)
	INSERT INTO @edgeAppIdInfo
	SELECT APP.id, ABP.attrVal, 0
	FROM App_Application APP
	INNER JOIN APP_BackupSetProp ABP ON ABP.componentNameId = APP.backupset AND ABP.attrName = 'Edge Drive User Id' AND ABP.modified = 0
WHERE clientId = @clientId AND subclientStatus & 0x20000 <> 0
	INSERT INTO @oldEdgeCapabilities
	SELECT EA.edgeUserId, dbo.BitwiseOR(EC.capabilityValue)
	FROM UMSecurityAssociations USA
	INNER JOIN @edgeAppIdInfo EA ON USA.entityId5 = EA.edgeSubClientId	AND USA.entityType5 = 7
	INNER JOIN @allEdgeCapabilities EC ON EC.capabilityId = USA.permissionId -- only add edge capabilities
	GROUP BY EA.edgeUserId
	IF EXISTS (SELECT 1 FROM @edgeAppIdInfo)
	BEGIN
		INSERT INTO @edgeCapabilities
		SELECT EA.edgeUserId, CAST(attrVal AS BIGINT)
		FROM UMUsersProp UPROP
		INNER JOIN  @edgeAppIdInfo EA ON UPROP.componentNameId = EA.edgeUserId
		WHERE UPROP.attrType = 130 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(MAX))
		UNION ALL
		SELECT EA.edgeUserId, CAST(attrVal AS BIGINT)
		FROM UMGroupsProp UPROP
		INNER JOIN @edgeAppIdInfo EA ON UPROP.componentNameId IN (SELECT groupId FROM UMUserGroup UG WHERE UG.userId = EA.edgeUserId)
		WHERE UPROP.attrType = 130 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(MAX))
		UPDATE @edgeAppIdInfo
		SET capabilities = CAP.capabilties
		FROM @edgeAppIdInfo EA
		INNER JOIN (SELECT dbo.BitwiseOR(capabilties) AS capabilties, edgeUserId
					FROM @edgeCapabilities
					GROUP BY edgeUserId) CAP ON EA.edgeUserId = CAP.edgeUserId
		-- If download capability is assigned, assign inplace and out of place
		UPDATE @edgeAppIdInfo
		SET capabilities = capabilities | 2621440
		WHERE capabilities & 32 = 32
		-- If browse capability is assigned, assign compliance search
		UPDATE @edgeAppIdInfo
		SET capabilities = capabilities | 16777216
		WHERE capabilities & 4096 = 4096
		INSERT INTO @usersToDecouple
		SELECT OC.edgeUserId, EA.edgeSubClientId, OC.capabilities
		FROM @oldEdgeCapabilities OC
		INNER JOIN @edgeAppIdInfo EA ON OC.edgeUserId = EA.edgeUserId
		WHERE OC.capabilities > 0
		AND NOT EXISTS(SELECT 1 FROM @edgeCapabilities C WHERE C.edgeUserId = OC.edgeUserId) -- No capabilities now
		AND NOT EXISTS(SELECT 1 FROM @oldEdgeDriveAssociations OEA WHERE OEA.entityId = OC.edgeUserId AND OEA.entityType = 13) -- He was not associated earlier at user level.
		IF EXISTS(SELECT 1 FROM @usersToDecouple)
		BEGIN
			-- This means user has his edge subclient here, but got removed from the group.
			-- Decouple the user association
			INSERT INTO App_EdgeDriveAssociation
			SELECT @clientId, 13, userId
			FROM @usersToDecouple
			-- Take old capabilities and assign to such users at user level
			INSERT UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT userId, CAST(@clientId AS NVARCHAR(MAX)), 130, CAST(capabilities AS NVARCHAR(MAX)), @nowTime, 0
			FROM @usersToDecouple
			-- Update our temp table
			UPDATE @edgeAppIdInfo
			SET capabilities = UD.capabilities
			FROM @usersToDecouple UD
			WHERE UD.userId = edgeUserId AND UD.subclientId = edgeSubClientId
		END
		-- Delete existing entries
		DELETE UMSecurityAssociations
		FROM UMSecurityAssociations USA
		INNER JOIN @edgeAppIdInfo EA ON USA.userOrGroupId = EA.edgeUserId AND USA.isUser = 1 AND USA.entityType5 = 7 AND USA.entityId5 = EA.edgeSubClientId
		-- Add new entries
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)
		SELECT 0, EAC.capabilityId, EA.edgeUserId, 1, 1, 1, 0, 0, 0, 3, APP.clientId, 4, APP.appTypeId, 5, APP.instance, 6, APP.backupSet, 7, APP.id, 0, 0, @adminUser
		FROM @edgeAppIdInfo EA
		INNER JOIN @allEdgeCapabilities EAC ON EA.capabilities & EAC.capabilityValue <> 0
		INNER JOIN APP_Application APP ON EA.edgeSubClientId = APP.id
	END
	------------------------------------------------------------------------------------
END
IF @opType = 3  --DELETE OPERATION
BEGIN
	--***********************USER ASSOCIATION*******************************
	DELETE FROM App_EdgeDriveAssociation
	WHERE clientId = @clientId
	AND entityType = 13
	AND entityId IN (SELECT userId FROM @userTbl)
	DELETE FROM UMUsersProp
	WHERE attrType = 130 AND attrName = CAST (@clientId AS NVARCHAR(MAX))
	AND componentNameId IN (SELECT userId FROM @userTbl)
--***********************INTERNAL GROUP ASSOCIATION*******************************
	DELETE FROM App_EdgeDriveAssociation
	WHERE clientId = @clientId
	AND entityType = 15
	AND entityId IN (SELECT groupId FROM @internalGroupTbl)
	DELETE FROM UMGroupsProp
	WHERE attrType = 130 AND attrName = CAST (@clientId AS NVARCHAR(MAX))
	AND componentNameId IN (SELECT groupId FROM @internalGroupTbl)
	--***********************EXTERNAL GROUP ASSOCIATION*******************************
	DELETE FROM App_EdgeDriveAssociation
	WHERE clientId = @clientId
	AND entityType = 62
	AND entityId IN (SELECT id
					 FROM UMDSGroups UG WITH(nolock)
					 INNER JOIN @externalGroupTbl E ON UG.name = E.groupName AND UG.umdsProviderId = E.providerId)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEdgeDriveAndGroupsAssoc')
	delete from GxQscripts where name = 'AppSetEdgeDriveAndGroupsAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEdgeDriveAndGroupsAssoc')
	delete from GXDBVersions where aliasname = 'AppSetEdgeDriveAndGroupsAssoc'
GO

insert into GXDBVersions values(2, 'AppSetEdgeDriveAndGroupsAssoc',  '00010016000200160000', 'AppSetEdgeDriveAndGroupsAssoc', '00010016000200160000')
GO

