

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetEDiscoveryClientProperties.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "EDiscoveryGetAllClients"
--	|	This Procedure is used to get user(s) details
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetEDiscoveryClientProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppSetEDiscoveryClientProperties <<<'
	drop procedure AppSetEDiscoveryClientProperties
END
IF EXISTS (select * from GxQscripts where name='AppSetEDiscoveryClientProperties')
	delete from GxQscripts where name = 'AppSetEDiscoveryClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEDiscoveryClientProperties')
	delete from GXDBVersions where aliasname = 'AppSetEDiscoveryClientProperties'
GO
print '... Creating Procedure: AppSetEDiscoveryClientProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetEDiscoveryClientProperties
  @xmlText XML
AS
	DECLARE @userId int = 0
	DECLARE @clientId int= 0
	DECLARE @timeNow int = dbo.GetUnixTime(GETUTCDATE())
    DECLARE  @errorCode int = 0
    DECLARE @errorString nvarchar(max) =''
    SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
    SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'int') AS client
                              FROM    @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClient') R ( ref )),0)
    DECLARE @dataSourcesOperationType	INT = 1 --OVERWRITE
	SET @dataSourcesOperationType = ISNULL((SELECT  ref.value('@dataSourcesOperationType', 'int') AS datasource
                              FROM    @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClientInfo') R ( ref )),@dataSourcesOperationType)
    BEGIN TRY
   IF OBJECT_ID('tempdb.dbo.#dataSources') IS NOT NULL
        DROP TABLE #dataSources
    CREATE TABLE #dataSources (dataSourceId INT)
    --Rights
	DECLARE @isAllowed INT = 0
	-- Create tempTable with permissionIds to be checked. Pass it to the SP.
	CREATE TABLE #permissionIdTbl
	(
		i_permissionId INT
	)
	INSERT INTO #permissionIdTbl
SELECT 2
	EXEC sec_checkPermissionOnEntity @userId = @userId ,
								@permissionIdList = '',
								@isAllowed = @isAllowed OUTPUT,
@entityType1 = 3,
								@entityId1 = @clientId,
								@AndOperation = 0				-- Check for any permission. If want to check for all permission, set it to 1.
	DROP TABLE #permissionIdTbl
    IF (@isAllowed = 0)
	    GOTO EXIT_OUT
DECLARE @tempSetTable table(componentId int, entityId int, attrName nvarchar(1024))
 INSERT INTO 	@tempSetTable (componentId ,  entityId, attrName)
 SELECT DISTINCT @clientId, CA.entityId, CA.attrName
  FROM @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClientInfo') R ( ref )
		OUTER APPLY ref.nodes('inventoryDataSource') U(ref5)
		OUTER APPLY ref.nodes('providers') V(ref6)
		OUTER APPLY ref.nodes('contentAnalyzerCloud') W(ref7)
		OUTER APPLY ref.nodes('indexServer') X(ref8)
		OUTER APPLY ref.nodes('federatedDataSource') Y(ref9)
CROSS APPLY (
SELECT U.ref5.value('@seaDataSourceId','INT') AS entityId, 'Inventory Datasource Id' as attrName  UNION ALL
SELECT Y.ref9.value('@seaDataSourceId','INT') AS entityId, 'Federated Datasource Id' as attrName UNION ALL
SELECT  W.ref7.value('@cloudId','INT') AS entityId, 'Content Analyzer cloud Id' as attrName  UNION ALL
SELECT  x.ref8.value('@clientId','INT') AS entityId, 'Analytics Index Server Id' as attrName UNION ALL
SELECT  V.ref6.value('@providerId','INT') AS entityId, 'Provider Id' as attrName
		) CA
		 WHERE CA.entityId is not null
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT source.componentId, source.attrName, 7, source.entityId,@timeNow,0
	FROM @tempSetTable source
	LEFT JOIN app_clientprop target
	ON (target.componentnameId = source.componentId
	AND  target.attrName = source.attrName AND  target.attrVal = CAST(source.entityId AS NVARCHAR(40)) AND modified=0)
	WHERE target.id IS NULL
--Data source operation
	INSERT INTO #dataSources
	SELECT DISTINCT  ref.value('@seaDataSourceId', 'int')
		FROM @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClientInfo/dataSources') R ( ref )
	IF (@dataSourcesOperationType = 3)--delete
	BEGIN
DELETE FROM APP_ClientProp where componentNameId=@clientId and attrName='Datasource Id' and modified=0 and attrVal in (select dataSourceId from #dataSources)
	END
	IF (@dataSourcesOperationType = 1) --  overwrite
	BEGIN
DELETE FROM APP_ClientProp where componentNameId=@clientId and attrName='Datasource Id' and modified=0
	END
	IF @dataSourcesOperationType = 2   or @dataSourcesOperationType = 1         --add or overwrite
	BEGIN
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT @clientId, 'Datasource Id' , 7, source.dataSourceId,@timeNow,0
		FROM #dataSources source
		LEFT JOIN app_clientprop target
		ON (
target.componentnameId = @clientId AND  target.attrName = 'Datasource Id' AND  target.attrVal = CAST(source.dataSourceId AS NVARCHAR(40)) AND modified=0)
		WHERE target.id IS NULL
	END
--Case Manager Case Type
	IF (EXISTS (SELECT ref.value('@caseType', 'int')
				FROM @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClientInfo') R ( ref )
				WHERE ref.value('@caseType', 'int') IS NOT NULL))
	BEGIN
		declare @caseType int
		SET @caseType =  ISNULL((SELECT  ref.value('@caseType', 'int')
							FROM @xmlText.nodes('App_SetEDiscoveryClientPropertiesRequest/eDiscoveryClientProp/eDiscoveryClientInfo') R ( ref )),0)
IF (EXISTS (select attrval from APP_ClientProp WITH (NOLOCK) where componentNameId=@clientId and attrName='Case Manager Case Type' and modified=0))
		BEGIN
			UPDATE APP_ClientProp
			SET attrval = @caseType
WHERE componentNameId=@clientId and attrName='Case Manager Case Type' and modified=0
		END
		ELSE
		BEGIN
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT @clientId, 'Case Manager Case Type' , 7, @caseType, @timeNow, 0
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
    EXIT_OUT:
	IF OBJECT_ID('tempdb.dbo.#dataSources') IS NOT NULL
		DROP TABLE #dataSources
    SET @xmlText = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
    SELECT @xmlText xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetEDiscoveryClientProperties')
	delete from GxQscripts where name = 'AppSetEDiscoveryClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetEDiscoveryClientProperties')
	delete from GXDBVersions where aliasname = 'AppSetEDiscoveryClientProperties'
GO

insert into GXDBVersions values(2, 'AppSetEDiscoveryClientProperties',  '00000000000000000000', 'AppSetEDiscoveryClientProperties', '00000000000000000000')
GO

