

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetDiscoveryContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |                       SP: "AppSetDiscoveryContent.sp"                           |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetDiscoveryContent')
BEGIN
	print '>>> Drop Stored Procedure: AppSetDiscoveryContent <<<'
	drop procedure AppSetDiscoveryContent
END
IF EXISTS (select * from GxQscripts where name='AppSetDiscoveryContent')
	delete from GxQscripts where name = 'AppSetDiscoveryContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDiscoveryContent')
	delete from GXDBVersions where aliasname = 'AppSetDiscoveryContent'
GO
print '... Creating Procedure: AppSetDiscoveryContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetDiscoveryContent
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xml XML,
  @isRemoteContent INT=0
AS
  DECLARE @o_xml XML
DECLARE  @subclientList TABLE
(
id int
)
DECLARE  @oldContent TABLE
(
scId int,
contentName nvarchar(2048),
contentType int
)
DECLARE  @newContent TABLE
(
scId int,
instId int,
contentName nvarchar(2048),
contentValue nvarchar(max),
contentType int
)
DECLARE  @newAccounts TABLE
(
scId int,
contentName nvarchar(2048),
contentValue nvarchar(max),
contentType int
)
DECLARE  @removedAccounts TABLE
(
scId int,
contentName nvarchar(2048),
contentValue nvarchar(max),
contentType int
)
DECLARE @backupSetId int = 0
DECLARE @appType int = 0
DECLARE @defaultSubclient INT
DECLARE @nowTime int = dbo.GetUnixTime(GETUTCDATE())
DECLARE @mode int = 0
/*If request is made not from GUI but after discovery. Associate all newly discovered account to default subclient.
NOTE: you need to figure out the default subclient from id of the subclient passed in the list */
BEGIN TRY
BEGIN TRANSACTION
IF (@isRemoteContent <> 0)
BEGIN
    INSERT INTO @newContent
    SELECT DISTINCT ISNULL(ref.value('(../scEntity/@subclientId)[1]','int'),0),
	  ISNULL(ref.value('(../scEntity/@instanceId)[1]','int'),0),
    ISNULL(ref.value('@contentName','nvarchar(2048)'),''),
    ISNULL(ref.value('@contentValue','nvarchar(max)'),''),
    ISNULL(ref.value('@contentType','int'),0)                                                           --Remote exe may not populate this field
    FROM  @i_xml.nodes('App_DiscoveryContent/scDiscoveryContent/contentInfo') R(ref)
    IF ((SELECT TOP 1 scId from @newContent) is null )
    BEGIN
        SET @o_xml = (SELECT  0 AS '@errorCode', 'Content List is Empty' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
		ROLLBACK TRANSACTION
        GOTO EXIT_PROC
    END
	-- TR 190106-45 Remove special character from record which causes issues while serializing to XML
	Update @newContent SET contentValue = REPLACE(contentValue, char(0x001F), '')
    SELECT @backupSetId = backupSet, @appType = appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = (SELECT TOP 1 scId FROM @newContent) --Assuming all content is of the same type i.e appType
SET @defaultSubclient = (SELECT id FROM App_Application WITH (NOLOCK) WHERE backupSet=@backupSetId AND (subclientStatus&0x00008 <> 0) AND (subclientStatus&0x00010 = 0))
    UPDATE @newContent SET scId = @defaultSubclient
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	SELECT scId,contentName,contentType,contentValue,@nowTime,0,0 FROM @newContent
	COMMIT  TRANSACTION
	GOTO EXIT_PROC
END
ELSE
	BEGIN
		INSERT INTO @newContent
		SELECT DISTINCT ISNULL(ref.value('(../scEntity/@subclientId)[1]','int'),0),
		ISNULL(ref.value('(../scEntity/@instanceId)[1]','int'),0),
		ISNULL(ref.value('@contentName','nvarchar(2048)'),''),
		ISNULL(ref.value('@contentValue','nvarchar(max)'),''),
		ISNULL(ref.value('@contentType','int'),0)
		FROM  @i_xml.nodes('App_DiscoveryContent/scDiscoveryContent/contentInfo') R(ref)
		IF ((SELECT TOP 1 scId from @newContent) is null )
		BEGIN
			SET @o_xml = (SELECT  0 AS '@errorCode', 'Content List is Empty' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
			ROLLBACK TRANSACTION
			GOTO EXIT_PROC
		END
		-- TR 190106-45 Remove special character from record which causes issues while serializing to XML
		Update @newContent SET contentValue = REPLACE(contentValue, char(0x001F), '')
		SET @mode = (SELECT ISNULL(ref.value('(@mode)[1]','int'),0) FROM @i_xml.nodes('App_DiscoveryContent') R(ref))
		-- Check mode to find if it is GUI update
		If ( @mode <> 0 )
		BEGIN
				 INSERT INTO @subclientList SELECT id FROM APP_Application WITH (NOLOCK) WHERE instance = (SELECT TOP 1 instId FROM @newContent WHERE instId <> 0)
				 UPDATE	APP_SubClientProp
					SET	modified = @nowTime FROM APP_SubClientProp ASP, @newContent R
					 WHERE	ASP.attrName = R.contentName AND ASP.attrType = R.contentType AND ASP.modified = 0
					 AND ASP.componentNameId in ( SELECT id from @subclientList )
				 INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					SELECT scId,contentName,contentType,contentValue,@nowTime,0,0 FROM @newContent WHERE scId <> 0
				 SET @o_xml = (SELECT 0 AS '@errorCode', 'Successfully updated the modified subclient content' FOR XML PATH ( 'App_GenericResp' ))
				 COMMIT TRANSACTION
				 GOTO EXIT_PROC
		END
		ELSE
		BEGIN
			--Extract list of subclients belonging to this backup set
			SELECT @backupSetId = backupSet, @appType = appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = (SELECT TOP 1 scId FROM @newContent WHERE scId <> 0)
			IF (@backupSetId=0 OR @appType=0)
			BEGIN
					DECLARE @propType int=0
					DECLARE @EmptySubclientID int = 0
					INSERT INTO @subclientList
						SELECT ISNULL(ref.value('(./scEntity/@subclientId)[1]','int'),0)
							FROM  @i_xml.nodes('App_DiscoveryContent/scDiscoveryContent') R(ref)
					SELECT TOP 1 @EmptySubclientID = id from @subclientList
					IF ( @EmptySubclientID=0)
					BEGIN
							SET @o_xml = (SELECT  1 AS '@errorCode', 'One or more subclientId could not be matched' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
							ROLLBACK TRANSACTION
							GOTO EXIT_PROC
					END
					SELECT TOP 1 @propType = contentType from @newContent --assuming content type is fixed
					INSERT INTO @removedAccounts
						SELECT componentNameId,attrName,attrVal,attrType FROM APP_SubClientProp WITH (NOLOCK)
							WHERE attrType = @propType AND componentNameId = @EmptySubclientID AND attrName IN (SELECT contentName from @newContent) and modified = 0
					UPDATE APP_SubClientProp SET modified = @nowTime
						FROM APP_SubClientProp ASP , @removedAccounts R
							WHERE ASP.attrName = R.contentName
								AND ASP.attrType = R.contentType
								AND ASP.componentNameId = R.scId
								AND ASP.modified = 0
					SET @o_xml = (SELECT 0 AS '@errorCode', 'Successfully updated subclient content' FOR XML PATH ( 'App_GenericResp' ))
					COMMIT TRANSACTION
					GOTO EXIT_PROC
			END
			INSERT INTO @subclientList SELECT id FROM APP_Application WITH (NOLOCK) WHERE backupSet = @backupSetId
			--FETCH old content association
				INSERT INTO @oldContent
				SELECT componentNameId, attrName, attrType FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId in (SELECT id FROM @subclientList) AND attrType IN (134, 135) AND modified=0
			--Extract the newly discovered accounts into a separate list
				INSERT INTO @newAccounts
				SELECT scId,contentName,contentValue,contentType FROM @newContent WHERE contentName NOT IN (SELECT contentName FROM @oldContent)
			--Remove newly discovered accounts from @newContent. Now @newContent will have only accounts for which associaton has changed
				DELETE FROM @newContent WHERE contentName in (SELECT contentName FROM @newAccounts)
			--Extract removed accounts into a separate list
				INSERT INTO @removedAccounts
				SELECT	scid, contentName, contentValue, contentType FROM @newContent WHERE scId = 0
			--Remove such removed accounts from @newContent. Now @newContent will have only accounts which are not removed
				DELETE FROM @newContent WHERE scId = 0
			-- UPDATE App_SubclientProp as follows:
			/*1. newly discovered subclients: create fresh entry*/
				INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				 SELECT scId,contentName,contentType,contentValue,@nowTime,0,0 FROM @newAccounts
			/*2. Mark modified timestamp of removed accounts */
				UPDATE	APP_SubClientProp
				 SET	modified = @nowTime
				 FROM	APP_SubClientProp ASP, @removedAccounts R
				 WHERE	ASP.attrName = R.contentName
					AND	ASP.attrType = R.contentType
					AND ASP.modified = 0
					AND	ASP.componentNameId IN (SELECT id FROM @subclientList)
			/*3. Association changed: mark modified time of old entry. Create fresh entry for new association */
				MERGE App_subclientProp ASP
				USING @newContent NC
					ON (ASP.attrName = NC.contentName AND ASP.attrType= NC.contentType and ASP.modified=0
					AND ASP.componentNameId IN (SELECT id FROM @subclientList))
				WHEN MATCHED THEN
				UPDATE SET ASP.modified = @nowTime;
				INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				SELECT scId,contentName,contentType,contentValue,@nowTime,0,0 FROM @newContent
				SET @o_xml = (SELECT 0 AS '@errorCode', 'Successfully updated all subclient content' FOR XML PATH ( 'App_GenericResp' ))
				COMMIT TRANSACTION
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_xml = (SELECT @@ERROR AS '@errorCode', 'Failed to update subclient content' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
	ROLLBACK TRANSACTION
END CATCH
EXIT_PROC:
SELECT @o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetDiscoveryContent')
	delete from GxQscripts where name = 'AppSetDiscoveryContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDiscoveryContent')
	delete from GXDBVersions where aliasname = 'AppSetDiscoveryContent'
GO

insert into GXDBVersions values(2, 'AppSetDiscoveryContent',  '00000000000000000000', 'AppSetDiscoveryContent', '00000000000000000000')
GO

