

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetDeleteProcessedForCompany.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppSetDeleteProcessedForCompany"
--  |   Description: Stored procedure to set Delete processed flag for company
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetDeleteProcessedForCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppSetDeleteProcessedForCompany <<<'
	drop procedure AppSetDeleteProcessedForCompany
END
IF EXISTS (select * from GxQscripts where name='AppSetDeleteProcessedForCompany')
	delete from GxQscripts where name = 'AppSetDeleteProcessedForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDeleteProcessedForCompany')
	delete from GXDBVersions where aliasname = 'AppSetDeleteProcessedForCompany'
GO
print '... Creating Procedure: AppSetDeleteProcessedForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetDeleteProcessedForCompany
  @companyId INTEGER
AS
  DECLARE @errorCode INT
SET NOCOUNT ON
set @errorCode = 0
BEGIN TRY
	UPDATE p
SET flags = flags | 0x0020
	FROM UMDSProviders P
	WHERE
	id = @companyId
	AND enabled=0
AND (flags & 0x0002) > 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = 1
END CATCH
SELECT @errorCode AS 'errorCode'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetDeleteProcessedForCompany')
	delete from GxQscripts where name = 'AppSetDeleteProcessedForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDeleteProcessedForCompany')
	delete from GXDBVersions where aliasname = 'AppSetDeleteProcessedForCompany'
GO

insert into GXDBVersions values(2, 'AppSetDeleteProcessedForCompany',  '00000000000000000000', 'AppSetDeleteProcessedForCompany', '00000000000000000000')
GO

