

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetDefaultPlansForClients.sp] ---------- 

--  +=====================================================================================================================+
--  |		 		 Name:  AppSetDefaultPlansForClients()
--  | Description:  Save Default Plans for the provided Clients.
--  |				Input allowed multiple clients and multiple plans at the same time.
--  |				In case of multiple plans being provided for same plan subctype, then first one will be selected
--  +=====================================================================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetDefaultPlansForClients.sp,v $ $Id: AppSetDefaultPlansForClients.sp,v 1.1.2.5.50.1 2021/04/05 22:43:06 sgoel Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetDefaultPlansForClients')
BEGIN
	print '>>> Drop Stored Procedure: AppSetDefaultPlansForClients <<<'
	drop procedure AppSetDefaultPlansForClients
END
IF EXISTS (select * from GxQscripts where name='AppSetDefaultPlansForClients')
	delete from GxQscripts where name = 'AppSetDefaultPlansForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDefaultPlansForClients')
	delete from GXDBVersions where aliasname = 'AppSetDefaultPlansForClients'
GO
print '... Creating Procedure: AppSetDefaultPlansForClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetDefaultPlansForClients
  @i_userId INT,
  @i_localeId INT,
  @i_clientIds VARCHAR(1024),
  @i_planIds VARCHAR(1024),
  @i_skipSecurityCheck INT = 0,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT,
  @i_opType INT
AS
  DECLARE @errCode INTEGER
  DECLARE @errString VARCHAR(1024)
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
    SET @o_errCode = 0 -- Optimism
    SET @o_errString = '' -- Optimism
	-- Read Input
    DECLARE @clientTBL TABLE (clientId INT PRIMARY KEY)
	DECLARE @planTBL TABLE (planId INT PRIMARY KEY, subType INT, attrName VARCHAR(128))
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	INSERT INTO @clientTBL
	SELECT DISTINCT _ID FROM dbo.SplitIDs(@i_clientIds)
	-- We will get only 1 type of plan for plan subtype
	INSERT INTO @planTBL (planId , subType, attrName)
	SELECT MIN(P._ID), AP.subType,
			CASE AP.subType
WHEN 33554437 THEN 'Default Server Plan'
WHEN 50331655 THEN 'Default File System Plan'
WHEN 33579013 THEN 'Default Database Plan'
WHEN 83886085 THEN 'Default Virtual Server Backup Plan'
WHEN 83918853 THEN 'Default Virtual Server Replication Plan'
WHEN 117506053 THEN 'Default Data classification Plan'
WHEN 100859937 THEN 'Default Office365 Plan'
WHEN 100859937 THEN 'Default Dynamics365 Plan'
			END
			FROM dbo.SplitIDs(@i_planIds) P
		INNER JOIN APP_Plan AP
			ON P._ID=AP.id
		GROUP BY AP.subType
	-- Security Check
	IF (@i_skipSecurityCheck = 0)
	BEGIN
		-- Get all client visible to provided user ID
		IF OBJECT_ID('tempdb.dbo.#VisibleEntity') IS NOT NULL DROP TABLE #VisibleEntity
        CREATE TABLE #VisibleEntity (entityID INT)
		-- Get Visible plans for this user and check all provided plans are part of that group
		-- If not, the return with error
		-- -- -- plans
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 0, '#VisibleEntity'
		IF EXISTS (SELECT 1 FROM @planTBL PT RIGHT JOIN #VisibleEntity VE ON VE.entityID=PT.planId WHERE PT.planId IS NULL)
		BEGIN
			SET @o_errCode = 5
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @i_localeId)
			GOTO SCRIPT_EXIT
		END
		TRUNCATE TABLE #VisibleEntity
		-- Get Visible plans for this user and check all provided plans are part of that group
		-- If not, the return with error
		-- -- -- plans
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 3, 0, '#VisibleEntity'
		IF EXISTS (SELECT 1 FROM @clientTBL PT RIGHT JOIN #VisibleEntity VE ON VE.entityID=PT.clientId WHERE PT.clientId IS NULL)
		BEGIN
			SET @o_errCode = 5
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @i_localeId)
			GOTO SCRIPT_EXIT
		END
		IF OBJECT_ID('tempdb.dbo.#VisibleEntity') IS NOT NULL DROP TABLE #VisibleEntity
	END
	IF(@i_opType=3)
	BEGIN
		DELETE cp
		FROM APP_ClientProp cp
INNER JOIN @clientTBL C ON C.clientId=CP.componentNameId AND CP.attrName IN ('Default Server Plan','Default File System Plan', 'Default Database Plan', 'Default Virtual Server Backup Plan', 'Default Virtual Server Replication Plan' ,  'Default Data classification Plan' , 'Default Office365 Plan', 'Default Dynamics365 Plan' ) AND CP.modified=0
		INNER JOIN @planTBL P ON CAST(P.planId AS VARCHAR) = CP.attrVal
	END
	ELSE
	BEGIN
		-- If we reach here. Just set the plan for the client for default mappings
		MERGE APP_ClientProp ACP
		USING (SELECT * from @clientTBL ct
				INNER JOIN @planTBL pt ON pt.attrName IS NOT NULL) Source
		ON ACP.componentnameId=Source.clientId AND ACP.attrname=Source.attrName AND ACP.modified=0
		WHEN MATCHED THEN
			UPDATE SET ACP.attrval=Source.planId
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
            Values( Source.clientId, Source.attrName, 7, Source.planId, @nowTime, 0, 0);
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errCode = ERROR_NUMBER()
    SET @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @errCode        = @o_errCode
SET @errString      = @o_errString
SELECT @o_errCode, @o_errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetDefaultPlansForClients')
	delete from GxQscripts where name = 'AppSetDefaultPlansForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDefaultPlansForClients')
	delete from GXDBVersions where aliasname = 'AppSetDefaultPlansForClients'
GO

insert into GXDBVersions values(2, 'AppSetDefaultPlansForClients',  'v1.1.2.5.50.1', 'AppSetDefaultPlansForClients', 'v1.1.2.5.50.1')
GO

