

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetDataSourceForIndexing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetDataSourceForIndexing.sp,v $ $Id: AppSetDataSourceForIndexing.sp,v 1.1.2.3 2020/06/23 12:59:05 jraju Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetDataSourceForIndexing')
BEGIN
	print '>>> Drop Stored Procedure: AppSetDataSourceForIndexing <<<'
	drop procedure AppSetDataSourceForIndexing
END
IF EXISTS (select * from GxQscripts where name='AppSetDataSourceForIndexing')
	delete from GxQscripts where name = 'AppSetDataSourceForIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDataSourceForIndexing')
	delete from GXDBVersions where aliasname = 'AppSetDataSourceForIndexing'
GO
print '... Creating Procedure: AppSetDataSourceForIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetDataSourceForIndexing
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @outXML XML
DECLARE @backupSetId		INT
DECLARE @dataSourceId		INT
DECLARE @metaDataSourceId	INT
DECLARE @dataSourceType		INT
DECLARE @errorCode			INT  = 0
DECLARE @errorMessage		VARCHAR(1024) = ''
DECLARE @recoveryPointXML	XML = '<databrowse_BrowseRequest/>'
DECLARE @recoveryPointID	INT = 0
DECLARE @backupsetGUID		VARCHAR(64) = ''
SET @backupSetId = ISNULL(( SELECT ref.value('@backupsetId', 'INTEGER')FROM @inXMl.nodes('Indexing_SetDataSourceInfoReq/bkpSetEntity') R(ref)), 0)
SET @backupsetGUID = ISNULL(( SELECT ref.value('@backupsetGUID', 'VARCHAR(64)')FROM @inXMl.nodes('Indexing_SetDataSourceInfoReq/bkpSetEntity') R(ref)), '')
SET @dataSourceId = ISNULL(( SELECT ref.value('@dataSourceId', 'INTEGER')FROM @inXMl.nodes('Indexing_SetDataSourceInfoReq') R(ref)), 0)
SET @metaDataSourceId = ISNULL(( SELECT ref.value('@metaDataSourceId', 'INTEGER')FROM @inXMl.nodes('Indexing_SetDataSourceInfoReq') R(ref)), 0)
SET @recoveryPointID = ISNULL(( SELECT ref.value('@recoveryPointId', 'INTEGER')FROM @inXMl.nodes('Indexing_SetDataSourceInfoReq') R(ref)), 0)
SET @dataSourceType = ISNULL(( SELECT ref.value('@type', 'INTEGER')FROM @inXMl.nodes('Indexing_SetDataSourceInfoReq') R(ref)), 0)
IF @dataSourceId = 0
BEGIN
	SET @errorCode = 1
	SET @errorMessage = 'DataSourceId is not set'
	GOTO FINISH
END
IF @backupSetId = 0 AND LEN(@backupsetGUID) > 0
BEGIN
	SET @backupSetId = (SELECT id FROM APP_BackupSetName WHERE GUID = @backupsetGUID)
END
IF @backupSetId = 0
BEGIN
	SET @errorCode = 1
	SET @errorMessage = 'BackupSetID/BackupSetGUID not set'
	GOTO FINISH
END
IF @dataSourceType IN (1,2/*IdxDataSourceType.ARCHIVE, IdxDataSourceType.CASEMANAGER*/)
BEGIN
	UPDATE APP_BackupSetProp SET modified = dbo.getunixtime(getutcdate())
	WHERE attrName IN('Indexing datasource id', 'Indexing metainfo datasource id')
	AND componentNameId = @backupSetId
	INSERT INTO APP_BackupSetProp
	VALUES(@backupSetId, 'Indexing datasource id', 7, @dataSourceId, dbo.getunixtime(getutcdate()), 0, 0)
	IF @metaDataSourceId > 0
	BEGIN
		INSERT INTO APP_BackupSetProp
		VALUES(@backupSetId, 'Indexing metainfo datasource id', 7, @metaDataSourceId, dbo.getunixtime(getutcdate()), 0, 0)
	END
END
ELSE IF @dataSourceType = 3 /*IdxDataSourceType.RECOVERY_POINT*/
BEGIN
	SET @recoveryPointXML = (SELECT initRequest FROM APP_LiveBrowseRecoveryPoints(NOLOCK) WHERE id = @recoveryPointID)
	IF @recoveryPointXML.exist('(/databrowse_BrowseRequest/advOptions/advConfig/applicationMining/connectionInfo/@dataSourceId)[1]') = 0
		SET @recoveryPointXML.modify('insert attribute dataSourceId{sql:variable("@dataSourceId")} into (/databrowse_BrowseRequest/advOptions/advConfig/applicationMining/connectionInfo)[1]')
	IF @metaDataSourceId > 0 AND @recoveryPointXML.exist('(/databrowse_BrowseRequest/advOptions/advConfig/applicationMining/connectionInfo/@metaDataSourceId)[1]') = 0
		SET @recoveryPointXML.modify('insert attribute metadataSourceId{sql:variable("@metaDataSourceId")} into (/databrowse_BrowseRequest/advOptions/advConfig/applicationMining/connectionInfo)[1]')
	UPDATE APP_LiveBrowseRecoveryPoints
	SET initRequest = @recoveryPointXML
	WHERE id = @recoveryPointID
END
FINISH:
SET @outXML = (
					SELECT
					@errorCode '@errorCode',
					@errorMessage '@errorMessage'
					FOR XML PATH('App_GenericResp')
				)
SELECT @outXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetDataSourceForIndexing')
	delete from GxQscripts where name = 'AppSetDataSourceForIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDataSourceForIndexing')
	delete from GXDBVersions where aliasname = 'AppSetDataSourceForIndexing'
GO

insert into GXDBVersions values(2, 'AppSetDataSourceForIndexing',  '00010001000200030000', 'AppSetDataSourceForIndexing', '00010001000200030000')
GO

