

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetDataSource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetDataSource.sp,v $ $Id: AppSetDataSource.sp,v 1.8.2.8 2018/03/27 07:58:23 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetDataSource <<<'

IF EXISTS (select * from sysobjects where name='AppSetDataSource')
	drop procedure AppSetDataSource
IF EXISTS (select * from GxQscripts where name='AppSetDataSource')
	delete from GxQscripts where name = 'AppSetDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDataSource')
	delete from GXDBVersions where aliasname = 'AppSetDataSource'
GO
print '... Creating Procedure: AppSetDataSource'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetDataSource
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_dataSourceId INT,
  @i_dataSourceName nvarchar(255),
  @i_dataSourceHost nvarchar(255),
  @i_description nvarchar(MAX),
  @i_connectionType INT,
  @i_endpoint INT,
  @i_flags INT,
  @i_guid nvarchar(256),
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_dataSourceId int
  DECLARE @o_version int
  DECLARE @o_ErrorCode int
  DECLARE @o_ErrorString nvarchar(max)
SET @o_ErrorCode = 0
SET @o_ErrorString = ''
DECLARE @offline INT = 0
DECLARE @revision nvarchar(255) = ''
IF ( @i_userId = 0 OR @i_userId IS null )
BEGIN
	SET @o_ErrorCode = 1
	SET	@o_ErrorString = 'User not provided'
	GOTO FINISH
END
DECLARE @hasRights INT = 0
DECLARE @origCCId int = 2
DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @i_userId , @origCCId, 2018, @origCCId
DECLARE @commCellCap bigint = 0
SELECT @commCellCap = ISNULL(nodeCap, 0) FROM @t_userCaps
IF (@commCellCap & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0)
	SET @hasRights = 1;
IF (@i_dataSourceId = 0)
BEGIN
	IF EXISTS(SELECT * FROM App_DataSource Where name = @i_dataSourceName and endpoint = @i_endpoint)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'data source already exists'
		GOTO FINISH
	END
	IF @hasRights = 0
	BEGIN
exec sec_userHasCapability @i_userId,0,@hasRights OUTPUT,0,0,'121'
	END
	IF @hasRights = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user does not have required capability to create data sources'
		GOTO FINISH
	END
	SET @o_version = 1
	INSERT INTO App_DataSource(name, host, description, connectionType, definition, version, deployed, offline, creationTime, userId, guid, revision, flags, endpoint)
	VALUES (
		@i_dataSourceName,
		@i_dataSourceHost,
		@i_description,
		@i_connectionType,
		@i_xmlText,
		@o_version,
		0,
		@offline,
		dbo.GetUnixTime(GETUTCDATE()),
		@i_userId,
		@i_guid,
		@revision,
		@i_flags,
		@i_endpoint
	)
	SELECT @i_dataSourceId = @@IDENTITY
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(122 AS NVARCHAR(10)) + ',' + CAST(123 AS NVARCHAR(10)) + ',' + CAST(124 AS NVARCHAR(10)) + ',' + CAST(107 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @i_userId, 0, @permissionsList, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 128, @i_dataSourceId
END
ELSE
BEGIN
	IF EXISTS(SELECT * FROM App_DataSource Where name = @i_dataSourceName and endpoint = @i_endpoint AND id <> @i_dataSourceId)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'data source already exists'
		GOTO FINISH
	END
	IF @hasRights = 0
	BEGIN
EXEC sec_checkPermissionOnEntity @i_userId,122,@hasRights OUTPUT,128,@i_dataSourceId
	END
	IF @hasRights = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user does not have required capability to edit data sources'
		GOTO FINISH
	END
	SELECT @o_version = version FROM App_DataSource Where id = @i_dataSourceId
	SET @o_version = @o_version + 1
	UPDATE App_DataSource
	SET name = @i_dataSourceName,
		host = @i_dataSourceHost,
		description = @i_description,
		connectionType = @i_connectionType,
		definition = @i_xmlText,
		version = @o_version,
		offline = @offline,
		guid = @i_guid,
		revision = @revision,
		flags = @i_flags,
		endpoint = @i_endpoint
	WHERE id = @i_dataSourceId
END
FINISH:
SELECT @i_dataSourceId AS o_dataSourceId, @o_version AS o_version, @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetDataSource')
	delete from GxQscripts where name = 'AppSetDataSource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDataSource')
	delete from GXDBVersions where aliasname = 'AppSetDataSource'
GO

insert into GXDBVersions values(2, 'AppSetDataSource',  '00010008000200080000', 'AppSetDataSource', '00010008000200080000')
GO

