

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetDataSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetDataSet.sp,v $ $Id: AppSetDataSet.sp,v 1.10.2.12 2018/11/29 20:33:07 csunderland Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetDataSet')
BEGIN
	print '>>> Drop Stored Procedure: AppSetDataSet <<<'
	drop procedure AppSetDataSet
END
IF EXISTS (select * from GxQscripts where name='AppSetDataSet')
	delete from GxQscripts where name = 'AppSetDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDataSet')
	delete from GXDBVersions where aliasname = 'AppSetDataSet'
GO
print '... Creating Procedure: AppSetDataSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetDataSet
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_dataSetId nvarchar(255),
  @i_dataSetName nvarchar(255),
  @i_description nvarchar(MAX),
  @i_dataSetType INT,
  @i_offline INT,
  @i_guid nvarchar(256),
  @i_revision nvarchar(255),
  @i_flags INT,
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int,
  @i_reportId int,
  @i_engineVersion int,
  @i_overrideReadOnly int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_version int
  DECLARE @o_ErrorCode int
  DECLARE @o_ErrorString nvarchar(max)
SET @o_ErrorCode = 0
SET @o_ErrorString = ''
IF ( @i_userId = 0 OR @i_userId IS null )
BEGIN
	SET @o_ErrorCode = 1
	SET	@o_ErrorString = 'User not provided'
	GOTO FINISH
END
IF (@i_reportId > 0)
BEGIN
	IF EXISTS(SELECT * FROM APP_DataSet Where name = @i_dataSetName AND reportId = @i_reportId)
	BEGIN
		SELECT @i_dataSetId = dataSetId FROM APP_DataSet Where name = @i_dataSetName AND reportId = @i_reportId
	END
	ELSE IF EXISTS(SELECT * FROM APP_DataSet Where guid = @i_guid AND reportId = @i_reportId)
	BEGIN
		SELECT @i_dataSetId = dataSetId FROM APP_DataSet Where guid = @i_guid AND reportId = @i_reportId
	END
	ELSE
	BEGIN
		SET @i_dataSetId = 0
	END
END
ELSE
BEGIN
	IF EXISTS(SELECT * FROM APP_DataSet Where guid = @i_guid AND reportId = 0)
	BEGIN
		SELECT @i_dataSetId = dataSetId FROM APP_DataSet Where guid = @i_guid AND reportId = 0
	END
	ELSE
	BEGIN
		SET @i_dataSetId = 0
	END
END
DECLARE @hasRights INT = 0
DECLARE @origCCId int = 2
DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @i_userId , @origCCId, 2018, @origCCId
DECLARE @commCellCap bigint = 0
SELECT @commCellCap = ISNULL(nodeCap, 0) FROM @t_userCaps
IF (@commCellCap & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0)
	SET @hasRights = 1;
IF (@i_dataSetId = 0)
BEGIN
	IF @hasRights = 0
	BEGIN
		IF @i_reportId = 0
exec sec_userHasCapability @i_userId,0,@hasRights OUTPUT,0,0,'125'
		ELSE
			SET @hasRights = 1
	END
	IF @hasRights = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user does not have required capability to create datasets'
		GOTO FINISH
	END
	IF EXISTS(SELECT * FROM APP_DataSet Where name = @i_dataSetName)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'data set [' + @i_dataSetName + '] already exists'
		GOTO FINISH
	END
	SET @o_version = 1
	INSERT INTO APP_DataSet(name, description, type, definition, version, deployed, offline, creationTime, userId, guid, revision, flags, reportId, engineVersion, deployedVersion)
	VALUES (
		@i_dataSetName,
		@i_description,
		@i_dataSetType,
		@i_xmlText,
		@o_version,
		0,
		0,
		dbo.GetUnixTime(GETUTCDATE()),
		@i_userId,
		@i_guid,
		@i_revision,
		@i_flags,
		@i_reportId,
		@i_engineVersion,
		0
	)
	SELECT @i_dataSetId = @@IDENTITY
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(126 AS NVARCHAR(10)) + ',' + CAST(127 AS NVARCHAR(10)) + ',' + CAST(128 AS NVARCHAR(10)) + ',' + CAST(107 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @i_userId, 0, @permissionsList, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, 129, @i_dataSetId
END
ELSE
BEGIN
	IF @hasRights = 0
	BEGIN
		IF @i_reportId = 0
EXEC sec_checkPermissionOnEntity @i_userId,126,@hasRights OUTPUT,129,@i_dataSetId
		ELSE
			SET @hasRights = 1
	END
	IF @hasRights = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'user does not have required capability to edit dataset'
		GOTO FINISH
	END
	IF EXISTS(SELECT * FROM APP_DataSet Where name = @i_dataSetName AND dataSetId <> @i_dataSetId)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'data set [' + @i_dataSetName + '] already exists'
		GOTO FINISH
	END
	DECLARE @currentFlags INT
	SELECT @o_version = version, @currentFlags = flags FROM APP_DataSet Where dataSetId = @i_dataSetId
	IF (@i_overrideReadOnly = 0 AND @currentFlags & 4 = 4)
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'data set is read only'
		GOTO FINISH
	END
	SET @o_version = @o_version + 1
	UPDATE APP_DataSet
	SET name = @i_dataSetName,
		description = @i_description,
		type = @i_dataSetType,
		definition = @i_xmlText,
		version = @o_version,
		guid = @i_guid,
		revision = @i_revision,
		flags = @i_flags,
		reportId = @i_reportId,
		engineVersion = @i_engineVersion
	WHERE dataSetId = @i_dataSetId
END
INSERT INTO APP_DataSetHistory (dataSetId, dataSetName, definition, version, deployed, creationTime, userId, engineVersion, offline)
VALUES (@i_dataSetId, @i_dataSetName, @i_xmlText, @o_version, 0, dbo.GetUnixTime(GETUTCDATE()), @i_userId, @i_engineVersion, @i_offline)
FINISH:
SELECT @i_dataSetId AS i_dataSetId, @o_version AS o_version, @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetDataSet')
	delete from GxQscripts where name = 'AppSetDataSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetDataSet')
	delete from GXDBVersions where aliasname = 'AppSetDataSet'
GO

insert into GXDBVersions values(2, 'AppSetDataSet',  '00010010000200120000', 'AppSetDataSet', '00010010000200120000')
GO

