

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCustomCalendar.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: AppSetCustomCalendar
--  |
--  | Description:
--  |  To validate and set custom calendars
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To validate and set custom calendars
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetCustomCalendar <<<'

IF EXISTS (select * from sysobjects where name='AppSetCustomCalendar')
	drop procedure AppSetCustomCalendar
IF EXISTS (select * from GxQscripts where name='AppSetCustomCalendar')
	delete from GxQscripts where name = 'AppSetCustomCalendar'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCustomCalendar')
	delete from GXDBVersions where aliasname = 'AppSetCustomCalendar'
GO
print '... Creating Procedure: AppSetCustomCalendar'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCustomCalendar
  @xmlText XML,
  @operationType INT
AS
  DECLARE @errorCode INT = 0
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @nowTime        INT = dbo.GetUnixTime (GetUTCdate())
    DECLARE @numberOfYear INT = 0
	DECLARE @beginYear INT = 0
	DECLARE @beginMonth INT
	DECLARE @calendarId INT = 0
	DECLARE @begindate INT
    DECLARE @CalendarName NVARCHAR(256)
	DECLARE @isDefault INT
	DECLARE @defineMonths INT
	DECLARE @customCalendarMonth TABLE( year INT, month INT, numberOfDays INT)
	SET @calendarId = ISNULL((SELECT  ref.value('@customCalendarId', 'INT')
                                      FROM    @xmlText.nodes('(/App_CustomCalendar/customCalendarEntity)[1]') R ( ref )),0)
  	IF @operationType = 2 -- DELETE Operation
    BEGIN
		-- Checking if calendar is standard
		IF @calendarId = 1
			GOTO ERROR_EXIT
		-- Checking if calendar is default
		IF EXISTS (SELECT 1 FROM APP_CustomCalendar WITH (NOLOCK) WHERE id = @calendarId AND isDefault = 1)
		BEGIN
SET @errorCode = (3267 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		--Checking if the calendar is associated with Schedule
		IF EXISTS (SELECT 1 FROM TM_Pattern WITH (NOLOCK) WHERE calendarId = @calendarId)
		BEGIN
SET @errorCode = (3271 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		--Checking if the calendar is associated with Copy
		IF EXISTS (SELECT 1 FROM ArchGroupCopy WITH (NOLOCK) WHERE calendarId = @calendarId)
		BEGIN
SET @errorCode = (3266 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		-- Removing calendar Month details
        DELETE FROM APP_CustomCalendarMonths WHERE calendarId = @calendarId
        --Removing calendar details.
        DELETE FROM APP_CustomCalendar WHERE id = @calendarId
		GOTO ERROR_EXIT
    END
	--Reading calendar data from XML.
	SET @isDefault = iSNULL((SELECT  ref.value('@isDefault', 'INT') FROM @xmlText.nodes('/App_CustomCalendar') R ( ref )), 0)
	IF @calendarId = 1
		GOTO SKIP_MORE_FIELDS
	SET @CalendarName = (SELECT  ref.value('@customCalendarName', 'NVARCHAR(256)') FROM @xmlText.nodes('(/App_CustomCalendar/customCalendarEntity)[1]') R ( ref ))
	SET @beginMonth = (SELECT  ref.value('@beginMonth', 'INT') FROM @xmlText.nodes('/App_CustomCalendar') R ( ref ))
	SET @defineMonths = (SELECT  ref.value('@defineCustomMonths', 'INT') FROM @xmlText.nodes('/App_CustomCalendar') R ( ref ))
	-- For Modify operation read type from DB
	IF @operationType = 3
		SELECT @defineMonths = CASE WHEN calType = 3 THEN 1 ELSE 0 END FROM APP_CustomCalendar WITH (NOLOCK) WHERE id = @calendarId
	-- If for add request defineCustomMonths is not set, consider it as basic
	IF @defineMonths IS NULL
		SET @defineMonths = 0
	-- If basic calendar then stop reading further
	IF @defineMonths = 0
		GOTO SKIP_MORE_FIELDS
	SET @beginYear = (SELECT  ref.value('@beginYear', 'INT') FROM @xmlText.nodes('/App_CustomCalendar') R ( ref ))
	SET @begindate = (SELECT  ref.value('@beginDate', 'INT') FROM @xmlText.nodes('/App_CustomCalendar') R ( ref ))
	SET @numberOfYear = (SELECT  ref.value('@numberOfYears', 'INT') FROM @xmlText.nodes('/App_CustomCalendar') R ( ref ))
	-- Inserting in calendar table from input XML
    INSERT INTO @customCalendarMonth ( year, month, numberOfDays)
        SELECT
        N.calendar.value('@year','INT') AS year,
        N.calendar.value('@month','INT') AS month,
        N.calendar.value('@numberOfDays','INT') AS numberOfDays
        FROM   @xmlText.nodes('/App_CustomCalendar/customCalendarMonths') AS N(calendar)
	-- Removing all incomplete entries from Month list.
	DELETE FROM @customCalendarMonth WHERE numberOfDays IS NULL OR year IS NULL or month IS NULL OR
		numberOfDays < 15 OR numberOfDays > 45
	SKIP_MORE_FIELDS:
    IF @operationType = 1 --ADD Operation
    BEGIN
		--Check if calendar name already exist
		IF EXISTS (SELECT 1 FROM APP_CustomCalendar WITH (NOLOCK) WHERE name = @CalendarName)
		BEGIN
SET @errorCode = (3268 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		-- If request contains default calendar then unset existing one.
		IF @isDefault = 1
		BEGIN
			UPDATE APP_CustomCalendar SET isDefault = 0 WHERE isDefault = 1
		END
		-- Inserting calendar details in table
		IF @defineMonths = 0
		BEGIN
			INSERT INTO APP_CustomCalendar(name, beginYear, beginMonth, beginDate, noOfyears, isDefault, calType, createdTime, modifiedTime)
			VALUES( @CalendarName, 1970, @beginMonth, 0, 0, @isDefault, 2, @nowTime, @nowTime)
			GOTO ERROR_EXIT
		END
		INSERT INTO APP_CustomCalendar(name, beginYear, beginMonth, beginDate, noOfyears, isDefault, calType, createdTime, modifiedTime)
		VALUES( @CalendarName, @beginYear, @beginMonth, @begindate, @numberOfYear, @isDefault, 3, @nowTime, @nowTime)
		-- Getting newly created calendars' Id.
		SELECT @calendarId = id FROM APP_CustomCalendar WITH (NOLOCK) WHERE name = @CalendarName
    END
    IF @operationType = 3 -- UPDATE Operation
    BEGIN
		--Checking if calendar name already exist
		IF EXISTS (SELECT 1 FROM APP_CustomCalendar WITH (NOLOCK) WHERE @CalendarName IS NOT NULL AND @calendarId > 1 AND name = @CalendarName AND id <> @calendarId)
		BEGIN
SET @errorCode = (3268 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ERROR_EXIT
		END
		-- If request contains default calendar then unset existing one.
		IF @isDefault = 1
		BEGIN
			UPDATE APP_CustomCalendar SET isDefault = 0 WHERE isDefault = 1
		END
		-- Updating basic properties
		UPDATE APP_CustomCalendar SET isDefault = 1, modifiedTime = @nowTime WHERE @isDefault IS NOT NULL AND @isDefault = 1 AND id = @calendarId AND isDefault = 0
		UPDATE APP_CustomCalendar SET name = @CalendarName, modifiedTime = @nowTime WHERE id > 1 AND @CalendarName IS NOT NULL AND id = @calendarId AND name <> @CalendarName
		-- Done with basic calendar properties.
		IF @defineMonths = 0
			GOTO ERROR_EXIT
		-- Updating advanced properties
		UPDATE APP_CustomCalendar SET noOfyears = @numberOfYear, modifiedTime = @nowTime WHERE @numberOfYear IS NOT NULL AND id = @calendarId AND noOfyears <> @numberOfYear
		UPDATE APP_CustomCalendar SET beginDate = @begindate, modifiedTime = @nowTime WHERE @begindate IS NOT NULL AND id = @calendarId AND beginDate <> @begindate
		-- Getting old values from DB for number of days
		INSERT INTO @customCalendarMonth(year, month, numberOfDays)
		SELECT CCM.year, CCM.month, daysCount FROM APP_CustomCalendarMonths CCM  WITH (NOLOCK)
			LEFT OUTER JOIN @customCalendarMonth CCMR
				ON CCM.year = CCMR.year AND CCM.month = CCMR.month
				WHERE CCMR.numberOfDays IS NULL AND CCM.calendarId = @calendarId
		--Deleting months from Calendar months table to regenrate after modification
		DELETE FROM APP_CustomCalendarMonths WHERE calendarId = @calendarId
		-- Settings unset values in request from DB to generate months.
		SELECT @beginYear = beginYear, @beginMonth = beginMonth, @begindate = beginDate, @numberOfYear= noOfyears FROM APP_CustomCalendar WITH (NOLOCK) WHERE id = @calendarId
    END
	-- Adding custom months to the table.
	DECLARE @yearCount INT
	DECLARE @monthCount INT
	DECLARE @startDate DATETIME
	DECLARE @endDate DATETIME
	DECLARE @numberOfDays INT
	DECLARE @startYear INT = @beginYear
	SET @startDate = dbo.UTCToCellLocalTime(dbo.GetDateTime(@begindate),2)
	SET @yearCount = 0
	WHILE @yearCount < @numberOfYear
	BEGIN
		SET @monthCount = 0
		WHILE @monthCount < 12
		BEGIN
			SET @numberOfDays = (SELECT numberOfDays FROM @customCalendarMonth WHERE year = @beginYear AND month = @beginMonth)
			IF @numberOfDays IS NULL
			BEGIN
				SET @numberOfDays = CASE
										WHEN @beginMonth IN (4,6,9,11) THEN 30
										WHEN @beginMonth = 2 THEN CASE
													WHEN @startYear % 4 = 0 THEN 29
													ELSE 28 END
										ELSE 31 END
			END
			SET @endDate = DATEADD(DAY, @numberOfDays-1, @startDate)
			INSERT INTO APP_CustomCalendarMonths(calendarId, year, month, offset, daysCount, startDate, endDate)
			VALUES
			(@calendarId, @beginYear, @beginMonth, DATEDIFF(DAY, CAST(@beginYear AS NVARCHAR) + '-' + CAST(@beginMonth AS NVARCHAR) +'-1', @startDate), @numberOfDays, @startDate, @endDate)
			SET @startDate = DATEADD(DAY, 1, @endDate)
			IF @beginMonth = 12
			BEGIN
				SET @beginMonth = 1
				SET @beginYear = @beginYear + 1
			END
			ELSE
				SET @beginMonth = @beginMonth + 1
			SET @monthCount = @monthCount + 1
		END
		SET @yearCount = @yearCount + 1
	END
    ERROR_EXIT:
   SELECT @errorCode AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCustomCalendar')
	delete from GxQscripts where name = 'AppSetCustomCalendar'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCustomCalendar')
	delete from GXDBVersions where aliasname = 'AppSetCustomCalendar'
GO

insert into GXDBVersions values(2, 'AppSetCustomCalendar',  '00000000000000000000', 'AppSetCustomCalendar', '00000000000000000000')
GO

