

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCredentialForReplicationGroup.sp] ---------- 

--  +===============================================================================================================================+
--  |                       Name: AppSetCredentialForReplicationGroup()
--  | Description: Create/Update/Delete credentials associated to a replication group
--  |
--  |       Input: repGroupId, operationId, userName, Passsword, credentialId, userId
--  |      Output: AppMsg.GenericResp XML (outputXML)
--  |      Author: sravanan
--  +================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCredentialForReplicationGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCredentialForReplicationGroup <<<'
	drop procedure AppSetCredentialForReplicationGroup
END
IF EXISTS (select * from GxQscripts where name='AppSetCredentialForReplicationGroup')
	delete from GxQscripts where name = 'AppSetCredentialForReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCredentialForReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppSetCredentialForReplicationGroup'
GO
print '... Creating Procedure: AppSetCredentialForReplicationGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCredentialForReplicationGroup
  @repGroupId INT,
  @operationId INT,
  @userName NVARCHAR(510),
  @password NVARCHAR(800),
  @credentialId INT,
  @userId INT,
  @outputXML XML OUTPUT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @credAssocId INT = 0
	DECLARE @tempUserName NVARCHAR(510) = ''
	DECLARE @tempPassword NVARCHAR(800) = ''
	DECLARE @currentTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @continue INT = 1
	DECLARE @planId INT = 0
	DECLARE @userHasCapabilityUpdate INT = 0
	DECLARE @userHasCapabilityInvite INT = 0
	-- Security begin
	-- To check if user has rights to set credentials, check if user has rights on replication group, meaning check if user has rights on replication plan modification
SET @planId = ISNULL((SELECT CONVERT(INT,attrVal) FROM APP_ReplicationGroupProp WITH(NOLOCK) WHERE componentNameId = @repGroupId AND attrName = 'Associated Plan'),0)
	IF(@planId = 0)
	BEGIN
		SET @continue = 0
	END
	IF @continue = 1
	BEGIN
EXEC sec_checkPermissionOnEntity @userId, 157, @userHasCapabilityUpdate OUTPUT, 158, @planId
EXEC sec_checkPermissionOnEntity @userId, 159, @userHasCapabilityInvite OUTPUT, 158, @planId
		IF (@userHasCapabilityUpdate = 0) AND (@userHasCapabilityInvite = 0) AND (NOT EXISTS (SELECT id FROM App_Plan WHERE id = @planId AND ownerId = @userId))
		BEGIN
			-- sec_checkPermissionOnEntity just checks for rights on the plan. For replication plans, you need some extra checks like checking rights on the Hypervisor
			-- associated with the plan
EXEC [dbo].[sec_CheckRepPlanEntitiesSecurity] @planId, 158,83918853, @userId,0, @continue OUTPUT
			IF(@continue = 1)
			BEGIN
				SET @userHasCapabilityUpdate = 1
				SET @userHasCapabilityInvite = 1
			END
			ELSE
			BEGIN
				SET @continue = 0
			END
		END
	END
	IF(@continue = 0)
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Access denied.'
	END
	-- Security end
	IF(@operationId = 1 OR @operationId = 2) -- CREATE OR EDIT CREDENTIALS
	BEGIN
		IF(@credentialId = 0) -- NOT using credential manager
		BEGIN
UPDATE App_ReplicationGroupProp SET attrVal = @userName WHERE attrName = 'VM Guest Credential User Name' AND componentNameId = @repGroupId
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES (@repGroupId, 'VM Guest Credential User Name', 1, @userName, '',@currentTime, 0 )
			END
UPDATE App_ReplicationGroupProp SET attrVal = @password WHERE attrName = 'VM Guest Credential Password' AND componentNameId = @repGroupId
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES (@repGroupId, 'VM Guest Credential Password', 1, @password, '',@currentTime, 0 )
			END
DELETE App_CredentialAssoc WHERE entityId = @repGroupId AND entityType = 193
DELETE App_ReplicationGroupProp WHERE componentNameId = @repGroupId AND attrName = 'Replication Group Credential Assoc Id'
		END
		ELSE  -- Credential manager is being used
		BEGIN
			SELECT @tempUserName = userName, @tempPassword = password FROM App_Credentials WITH(NOLOCK) WHERE credentialId = @credentialId
			IF @tempUserName <> ''
			BEGIN
				INSERT INTO APP_CredentialAssoc (credentialId, entityType, entityId)
VALUES(@credentialId, 193, @repGroupId)
				SET @credAssocId = SCOPE_IDENTITY()
UPDATE App_ReplicationGroupProp SET attrVal = CONVERT(NVARCHAR(MAX), @credAssocId) WHERE attrName = 'Replication Group Credential Assoc Id' AND componentNameId = @repGroupId
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES (@repGroupId, 'Replication Group Credential Assoc Id', 7, @credAssocId, '',@currentTime, 0 )
				END
UPDATE App_ReplicationGroupProp SET attrVal = @tempUserName WHERE attrName = 'VM Guest Credential User Name' AND componentNameId = @repGroupId
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES (@repGroupId, 'VM Guest Credential User Name', 1, @tempUserName, '',@currentTime, 0 )
				END
UPDATE App_ReplicationGroupProp SET attrVal = @tempPassword WHERE attrName = 'VM Guest Credential Password' AND componentNameId = @repGroupId
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO App_ReplicationGroupprop (componentNameId, attrName, attrType, attrVal, attrXML, created, ccpId)
VALUES (@repGroupId, 'VM Guest Credential Password', 1, @tempPassword, '',@currentTime, 0 )
				END
			END
		END
	END
	ELSE IF(@operationId = 3) -- DELETE CREDENTIALS
	BEGIN
DELETE App_CredentialAssoc WHERE entityId = @repGroupId AND entityType = 193
DELETE App_ReplicationGroupProp WHERE componentNameId = @repGroupId AND attrName IN ('Replication Group Credential Assoc Id', 'VM Guest Credential User Name', 'VM Guest Credential Password')
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid operation'
		GOTO PROC_EXIT
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @errorCode = 1205  --DEADLOCK error
	BEGIN
	    ;THROW;   -- rethrow the DEADLOCK so XE captures.
	END
END CATCH
PROC_EXIT:
	SET @outputXML = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCredentialForReplicationGroup')
	delete from GxQscripts where name = 'AppSetCredentialForReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCredentialForReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppSetCredentialForReplicationGroup'
GO

insert into GXDBVersions values(2, 'AppSetCredentialForReplicationGroup',  '00000000000000000000', 'AppSetCredentialForReplicationGroup', '00000000000000000000')
GO

