

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetContentGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetContentGroups.sp,v $ $Id: AppSetContentGroups.sp,v 1.2.60.2 2018/03/22 01:39:02 jiechen Exp $";
--  +==================================================================================+
--  |Description : Sets the monikers(content groups for subclient) and their contents in DB.
--  |              Overwrites the whole data in DB with the data in request XML.
--	|			   Changes are audited.
--  | Input		 : App::SetContentGroupsReq XML string
--	| Output	 : errorCode, errorString.  If success, errorCode = 0.
--  +==================================================================================+
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetContentGroups <<<'

IF EXISTS (select * from sysobjects where name='AppSetContentGroups')
	drop procedure AppSetContentGroups
IF EXISTS (select * from GxQscripts where name='AppSetContentGroups')
	delete from GxQscripts where name = 'AppSetContentGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetContentGroups')
	delete from GXDBVersions where aliasname = 'AppSetContentGroups'
GO
print '... Creating Procedure: AppSetContentGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetContentGroups
  @userId integer,
  @xmlText XML  
AS
  DECLARE @errorCode int = 0
  DECLARE @errorMessage varchar(max) = 'Success'
DECLARE @contentsTbl	TABLE( id int identity(1,1),content nvarchar(128) )
DECLARE @newData		TABLE( typeName        nvarchar(128),  extension       nvarchar(128))
DECLARE @added			TABLE( typeName        nvarchar(128),  extension       nvarchar(128))
DECLARE @deleted		TABLE( typeName        nvarchar(128),  extension       nvarchar(128))
DECLARE @contentsCombinedForAdded		TABLE(id int identity(1,1), typeName        nvarchar(128),  contentList       nvarchar(3999))
DECLARE @contentsCombinedForDeleted		TABLE(id int identity(1,1), typeName        nvarchar(128),  contentList       nvarchar(3999))
DECLARE @row			integer
DECLARE @maxId			integer
DECLARE @contentRow		integer
DECLARE @contentMaxId	integer
DECLARE	@length			integer
DECLARE @groupName		nvarchar(128)
DECLARE @tempContent	nvarchar(128)
DECLARE @contentsStr	nvarchar(3999)
DECLARE @tempString		nvarchar(128)
--------- Fill @newData table with the data in XML req--------------------------
INSERT INTO @newData
SELECT ref.value('../@fileType', 'nvarchar(128)') AS typeName ,ref.value('@val','nvarchar(128)') AS extension
FROM  @xmlText.nodes('App_SetContentGroupsReq/contentGroupsList/extensionList') R ( ref )
IF NOT EXISTS( SELECT * FROM @newData)
BEGIN
	SET @errorCode = 1
	SET @errorMessage = 'No data in the XML request.'
	GOTO PROC_EXIT
END
-- Add \/\/ at the end since GUI won't append it.
UPDATE @newData
SET extension = extension + '\/\/' WHERE extension <> ''
-----------------------------------------------------------------------------
------- Find the diff ----------------------------------------
INSERT INTO @added
SELECT newTable.typeName, newTable.extension
FROM @newData newTable LEFT OUTER JOIN App_FileTypeAndExtensions oldTable with(nolock)
ON (newTable.typeName = oldTable.typeName) AND  (newTable.extension = oldTable.extension COLLATE SQL_Latin1_General_CP1_CS_AS)
WHERE oldTable.typeName IS NULL AND oldTable.extension IS NULL
INSERT INTO @deleted
SELECT oldTable.typeName, oldTable.extension
FROM App_FileTypeAndExtensions oldTable with(nolock) LEFT OUTER JOIN @newData newTable
ON (newTable.typeName = oldTable.typeName) AND (newTable.extension = oldTable.extension COLLATE SQL_Latin1_General_CP1_CS_AS)
WHERE newTable.typeName IS NULL AND newTable.extension IS NULL
-----------------------------------------------------------------
IF NOT EXISTS(SELECT * FROM @added) AND NOT EXISTS (SELECT * FROM @deleted)
	GOTO PROC_EXIT
----Make contents a comma seperated list for each moniker in the diff----------------------------------
BEGIN --consider added entries
	DECLARE @tempGroupsAdded		TABLE(id int identity(1,1),groupName nvarchar(128) )
	INSERT INTO @tempGroupsAdded
	SELECT DISTINCT typeName FROM @added
	SET @row = 1
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @tempGroupsAdded) , 0)
	WHILE @row <= @maxId
	BEGIN
		SET @groupName = (SELECT groupName FROM @tempGroupsAdded WHERE id = @row)
		CREATE TABLE tempContents	(id int identity(1,1),content nvarchar(128) )
		SET @contentsStr = ''
		DELETE FROM tempContents
		INSERT INTO tempContents SELECT extension FROM @added WHERE typeName = @groupName
		SET @contentRow = 1
		SET @contentMaxId = ISNULL( (SELECT MAX(id) FROM tempContents) , 0)
		WHILE @contentRow <= @contentMaxId
		BEGIN
			SET @tempContent = ISNULL((SELECT content FROM tempContents WHERE id = @contentRow), '')
			IF @contentsStr <> ''
				SET @contentsStr = @contentsStr + ',  '
			SET @length = LEN(@tempContent)
			IF	@length > 4
				SET @tempContent = LEFT(@tempContent, @length-4)-- Remove \/\/ at the end since we don't want it in the audit
			SET @contentsStr = @contentsStr + @tempContent
			SET @contentRow = @contentRow + 1
		END
		INSERT INTO @contentsCombinedForAdded(typeName, contentList) SELECT @groupName, @contentsStr
		SET @row = @row + 1
		DROP TABLE tempContents
	END
END
BEGIN --consider removed entries
	DECLARE @tempGroupsRemoved		TABLE(id int identity(1,1),groupName nvarchar(128) )
	INSERT INTO @tempGroupsRemoved
	SELECT DISTINCT typeName FROM @deleted
	SET @row = 1
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @tempGroupsRemoved) , 0)
	WHILE @row <= @maxId
	BEGIN
		SET @groupName = (SELECT groupName FROM @tempGroupsRemoved WHERE id = @row)
		CREATE TABLE  tempContentsRemoved	(id int identity(1,1),content nvarchar(128) )
		SET @contentsStr = ''
		DELETE FROM tempContentsRemoved
		INSERT INTO tempContentsRemoved SELECT extension FROM @deleted WHERE typeName = @groupName
		SET @contentRow = 1
		SET @contentMaxId = ISNULL( (SELECT MAX(id) FROM tempContentsRemoved) , 0)
		WHILE @contentRow <= @contentMaxId
		BEGIN
			SET @tempContent = ISNULL((SELECT content FROM tempContentsRemoved WHERE id = @contentRow), '')
			IF @contentsStr <> ''
				SET @contentsStr = @contentsStr + ',  '
			SET @length = LEN(@tempContent)
			IF	@length > 4
				SET @tempContent = LEFT(@tempContent , @length-4)
			SET @contentsStr = @contentsStr + @tempContent
			SET @contentRow = @contentRow + 1
		END
		INSERT INTO @contentsCombinedForDeleted(typeName, contentList)  SELECT @groupName, @contentsStr
		SET @row = @row + 1
		DROP TABLE tempContentsRemoved
	END
END
-----------------------------------------------------------------
-- --- Do audit trail ------------------------------------------------
DECLARE @opId   integer
DECLARE @opMsgId integer
DECLARE @opEvMsgId integer
DECLARE @paramData nvarchar(3999)
DECLARE @dataIsEvent integer
DECLARE @paramMsgId integer
-- SET GUI AUDIT OPERATION
SET @opMsgId = (355 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @dataIsEvent = 0
--Case 1: Creation of moniker  OR  Addition of contents to a moniker
BEGIN
	SET @contentsStr = ''
	DECLARE @tempGroups		TABLE(id int identity(1,1),groupName nvarchar(128) )
	INSERT INTO @tempGroups(groupName)  SELECT DISTINCT typeName FROM @contentsCombinedForAdded
	DECLARE @groupsAdded		TABLE(id int identity(1,1),groupName nvarchar(128) )
	DECLARE @groupsEdited		TABLE(id int identity(1,1),groupName nvarchar(128) )--groups to which contents have been added
	INSERT INTO @groupsAdded
	SELECT groupName FROM @tempGroups
	WHERE groupName NOT IN (SELECT DISTINCT typeName FROM App_FileTypeAndExtensions with(nolock))
	INSERT INTO @groupsEdited
	SELECT groupName FROM @tempGroups EXCEPT SELECT groupName FROM @groupsAdded
	--Doing audit trail for the newly created monikers
	SET @row = 1
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @groupsAdded) , 0)
	WHILE @row <= @maxId
	BEGIN
		SET @groupName = (SELECT groupName FROM @groupsAdded WHERE id = @row)
		SET @contentsStr = (SELECT contentList FROM @contentsCombinedForAdded WHERE typeName = @groupName)
SET @paramMsgId = (924 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @groupName, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @contentsStr, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		SET @row = @row + 1
	END
	--Doing audit trail for adding contents to existing monikers
	SET @row = 1
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @groupsEdited) , 0)
	WHILE @row <= @maxId
	BEGIN
		SET @groupName = (SELECT groupName FROM @groupsEdited WHERE id = @row)
		SET @contentsStr = (SELECT contentList FROM @contentsCombinedForAdded WHERE typeName = @groupName)
		IF @contentsStr <> ''
		BEGIN
SET @paramMsgId = (926 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @contentsStr, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @groupName, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		SET @row = @row + 1
	END
END
--Case 2: Deletion of moniker  OR  Removing contents from moniker
BEGIN
	SET @contentsStr = ''
	DECLARE @tempGroupsDeleted		TABLE(id int identity(1,1),groupName nvarchar(128) )
	INSERT INTO @tempGroupsDeleted SELECT DISTINCT typeName FROM @contentsCombinedForDeleted
	DECLARE @groupsDeleted		TABLE(id int identity(1,1),groupName nvarchar(128) )
	DECLARE @groupsEdited1		TABLE(id int identity(1,1),groupName nvarchar(128) )--groups from which contents have been removed
	INSERT INTO @groupsDeleted
	SELECT groupName FROM @tempGroupsDeleted
	WHERE groupName NOT IN (SELECT DISTINCT typeName FROM @newData)
	INSERT INTO @groupsEdited1
	SELECT groupName FROM @tempGroupsDeleted EXCEPT SELECT groupName FROM @groupsDeleted
	--Doing audit trail for the deleted monikers
	SET @row = 1
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @groupsDeleted) , 0)
	WHILE @row <= @maxId
	BEGIN
		SET @groupName = (SELECT groupName FROM @groupsDeleted WHERE id = @row)
SET @paramMsgId = (925 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @groupName, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		SET @row = @row + 1
	END
	--Doing audit trail for removing contents from existing monikers
	SET @row = 1
	SET @maxId = ISNULL( (SELECT MAX(id) FROM @groupsEdited1) , 0)
	WHILE @row <= @maxId
	BEGIN
		SET @groupName = (SELECT groupName FROM @groupsEdited1 WHERE id = @row)
		SET @contentsStr = (SELECT contentList FROM @contentsCombinedForDeleted WHERE typeName = @groupName)
		IF @contentsStr <> ''
		BEGIN
SET @paramMsgId = (927 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @contentsStr, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @groupName, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		SET @row = @row + 1
	END
END
---------------------------------------------------------------------------------------------------------------------
---- Now edit the App_FileTypeAndExtensions table in DB-------------------------------------------
 BEGIN TRY
	BEGIN TRANSACTION UpdateApp_FileTypeAndExtensions
		--Delete the rows
		DECLARE @col1 nvarchar(128)
		DECLARE @col2 nvarchar(128)
		declare cur_del CURSOR LOCAL for select typeName, extension FROM @deleted
		open cur_del
        fetch next from cur_del into @col1, @col2
        WHILE @@FETCH_STATUS = 0
        BEGIN
			DELETE FROM App_FileTypeAndExtensions WHERE typeName = @col1 AND (extension = @col2	COLLATE SQL_Latin1_General_CP1_CS_AS)
			fetch next from cur_del into @col1, @col2
		END
		close cur_del
        deallocate cur_del
		--Insert the rows
		INSERT INTO App_FileTypeAndExtensions
		SELECT typeName, extension
		FROM @added
	COMMIT TRANSACTION UpdateApp_FileTypeAndExtensions
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRANSACTION UpdateApp_FileTypeAndExtensions
END CATCH
--------------------------------------------------------------------------------
PROC_EXIT:
SELECT @errorCode, @errorMessage
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetContentGroups')
	delete from GxQscripts where name = 'AppSetContentGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetContentGroups')
	delete from GXDBVersions where aliasname = 'AppSetContentGroups'
GO

insert into GXDBVersions values(2, 'AppSetContentGroups',  '00010002006000020000', 'AppSetContentGroups', '00010002006000020000')
GO

