

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyTenantOperatorRole.sp] ---------- 

--  +==============================================================================+
--  |		Name: AppSetCompanyTenantOperatorRole
--  |		Description: This will assign a global / user specified tenant operator
--	|					 role for the company in company properties table.
--	|					 Internally, tenant operator group and Commvault users configured
--	|					 as operators will get this role on the company.
--  |					 This is the old style blob. After SP17, we support different
--	|					 role for different operator. But if some one tries this old blob,
--	|					 then this operator role is applied on all the operators of that
--	|					 company (as the behavior of SP16).
--  |		Author: jswaminathan
--  +==============================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyTenantOperatorRole')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyTenantOperatorRole <<<'
	drop procedure AppSetCompanyTenantOperatorRole
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyTenantOperatorRole')
	delete from GxQscripts where name = 'AppSetCompanyTenantOperatorRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantOperatorRole')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantOperatorRole'
GO
print '... Creating Procedure: AppSetCompanyTenantOperatorRole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyTenantOperatorRole
  @userId INT,
  @localeId INT,
  @companyId INT,
  @operationType INT,
  @tenantOperatorRole INT = 0,
  @errorCode INT = 0 OUTPUT,
  @errorString VARCHAR(MAX) = '' OUTPUT,
  @shouldReturn INT = 0
AS
-- Outputs
  DECLARE @o_errorCode INT = 0					-- Be optimistic
  DECLARE @o_errorString VARCHAR(1024) = ''
SET NOCOUNT ON
DECLARE @nowTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @tenantOperatorRoleName VARCHAR(1024) = ''
		,@skipSecurityCheckInSETSecurity INT = 0
IF (@operationType = 1 AND @tenantOperatorRole = 0)			-- ADD. If there is no role specified, then take global tenant operator role.
BEGIN
	SELECT @tenantOperatorRole = id
		  ,@tenantOperatorRoleName = name
	FROM UMRoles (NOLOCK)
	WHERE
flags & 512 <> 0		-- 512
	-- During CREATE (ADD) operation, the creator user might not have permissions yet on the created company.
	-- So when assigning Tenant Operator role on the company, it would fail saying User himself does not have rights.
	-- We can skip doing security check in CREATE case.
	-- Since this is the user who is creating the company, and his Tenant Operator group only is going to get the role, there is no Security breach.
	SET @skipSecurityCheckInSETSecurity = 1
END
IF @tenantOperatorRole IS NULL OR @tenantOperatorRole = 0
BEGIN
SET @errorCode = (3762 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @errorCode AND localeID = @localeId)
	GOTO PROC_EXIT
END
DECLARE @oldTenantOperatorRole INT
SELECT @oldTenantOperatorRole = attrValInt
FROM APP_CompanyProp (NOLOCK)
WHERE
	componentNameId = @companyId
AND attrName = 'Operator Role'
	AND modified = 0
AND cs_attrName=checksum('Operator Role')
DECLARE @operatorRoleChanged BIT = 0
IF @oldTenantOperatorRole IS NULL OR @oldTenantOperatorRole = 0
BEGIN
	INSERT INTO APP_CompanyProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@companyId, 'Operator Role', 7, CAST(@tenantOperatorRole AS VARCHAR(32)), @nowTime, 0)
	SET @operatorRoleChanged = 1
END
ELSE IF @oldTenantOperatorRole <> @tenantOperatorRole
BEGIN
	SET @operatorRoleChanged = 1
	UPDATE APP_CompanyProp				-- Check if GAT is auditing it.
	SET attrVal = @tenantOperatorRole
	WHERE
		componentNameId = @companyId
AND attrName = 'Operator Role'
		AND attrVal = CAST(@oldTenantOperatorRole as NVARCHAR(10))
		AND modified = 0
AND cs_attrName=checksum('Operator Role')
END
IF @operatorRoleChanged = 1			-- Update the security table as well with this.
BEGIN								-- Tenant operator group and operators of this company would need to be updated with this new tenant operator role.
	DECLARE @errorTable TABLE
	(
		errorCode INT,
		errorString VARCHAR(MAX)
	)
	DECLARE @entriesToUpdate TABLE
	(
		userId INT,
		usergroupId INT
	)
	INSERT INTO @entriesToUpdate			-- Get the operator user and group Ids. Update their role accordingly.
		SELECT CASE WHEN isUser = 1 THEN userOrGroupId ELSE 0 END,
			   CASE WHEN isUser = 0 THEN userOrGroupId ELSE 0 END
		FROM UMOperators (NOLOCK)
		WHERE
			companyId = @companyID
	-- This role is applicable on all the operators of this company.
	UPDATE UMOperators
	SET roleId = @tenantOperatorRole
	WHERE
		companyId = @companyId
	-- Insert the new role into security associations.
	DECLARE @securityAssociationsXML XML
	SET @securityAssociationsXML =	(
										SELECT 2 AS '@associationsOperationType'
												,(
													SELECT
														(
															SELECT CASE WHEN userID > 0 THEN userId END AS '@userId',
																   CASE WHEN userGroupId > 0 THEN userGroupId END AS '@userGroupId',
CASE WHEN userId > 0 THEN 13 ELSE 15 END AS '@_type_'
															FOR XML PATH('userOrGroup'), TYPE
														)
														,(
															SELECT
																(
																	SELECT @tenantOperatorRole AS '@roleId'
																			,@tenantOperatorRoleName AS '@roleName'
																	FOR XML PATH ('role'), TYPE
																)
															FOR XML PATH ('properties'), TYPE
														)
													FROM @entriesToUpdate
													FOR XML PATH ('associations'), TYPE
												)
											   ,(
													SELECT @localeId AS '@localeId'
													FOR XML PATH('processinginstructioninfo'), TYPE
											    )
										FOR XML PATH('App_SecurityAssociationForEntityList')
									)
	INSERT INTO @errorTable
EXEC sec_setSecurityAssociationsFromEntity @securityAssociationsXML, @userID, 0, @skipSecurityCheckInSETSecurity, 61, @companyId, 0, 0, 0, 0, 0, 0, 0, 0
	SET @errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
	IF @errorCode <> 0
	BEGIN
		SET @errorString = (SELECT TOP 1 errorString FROM @errorTable)
		GOTO PROC_EXIT
	END
	-- Delete the old tenant operator role from security associations.
	SET @securityAssociationsXML =	(
										SELECT 3 AS '@associationsOperationType'
												,(
													SELECT
														(
															SELECT CASE WHEN userID > 0 THEN userId END AS '@userId',
																   CASE WHEN userGroupId > 0 THEN userGroupId END AS '@userGroupId',
CASE WHEN userId > 0 THEN 13 ELSE 15 END AS '@_type_'
															FOR XML PATH('userOrGroup'), TYPE
														)
														,(
															SELECT
																(
																	SELECT @oldTenantOperatorRole AS '@roleId'
																	FOR XML PATH ('role'), TYPE
																)
															FOR XML PATH ('properties'), TYPE
														)
													FROM @entriesToUpdate
													FOR XML PATH ('associations'), TYPE
												)
											   ,(
													SELECT @localeId AS '@localeId'
													FOR XML PATH('processinginstructioninfo'), TYPE
											    )
										FOR XML PATH('App_SecurityAssociationForEntityList')
									)
	INSERT INTO @errorTable
EXEC sec_setSecurityAssociationsFromEntity @securityAssociationsXML, @userID, 0, @skipSecurityCheckInSETSecurity, 61, @companyId, 0, 0, 0, 0, 0, 0, 0, 0
	SET @errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
	IF @errorCode <> 0
	BEGIN
		SET @errorString = (SELECT TOP 1 errorString FROM @errorTable)
		GOTO PROC_EXIT
	END
END
PROC_EXIT:
IF @shouldReturn = 1
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyTenantOperatorRole')
	delete from GxQscripts where name = 'AppSetCompanyTenantOperatorRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantOperatorRole')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantOperatorRole'
GO

insert into GXDBVersions values(2, 'AppSetCompanyTenantOperatorRole',  '00000000000000000000', 'AppSetCompanyTenantOperatorRole', '00000000000000000000')
GO

