

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyTenantOperatorGroup.sp] ---------- 

--  +==============================================================================+
--  |		Name: AppSetCompanyTenantOperatorGroup
--  |		Description: When creating company, we create default Tenant
--	|					 Operator group with the company.
--	|					 Going forward, all the reseller users will get a
--  |					 hidden impersonated user part of this group.
--  |		Author: jswaminathan
--  +==============================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyTenantOperatorGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyTenantOperatorGroup <<<'
	drop procedure AppSetCompanyTenantOperatorGroup
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyTenantOperatorGroup')
	delete from GxQscripts where name = 'AppSetCompanyTenantOperatorGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantOperatorGroup')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantOperatorGroup'
GO
print '... Creating Procedure: AppSetCompanyTenantOperatorGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyTenantOperatorGroup
  @companyId INT,
  @userId INT,
  @localeId INT
AS
-- Outputs
  DECLARE @errorCode INT = 0					-- Be optimistic
  DECLARE @errorString VARCHAR(1024) = ''
SET NOCOUNT ON
DECLARE @companyName NVARCHAR(MAX)
SELECT @companyName = domainName
FROM UMDSProviders (NOLOCK)
WHERE
	id = @companyId
DECLARE @tenantOperatorUserGroupname NVARCHAR(MAX) = @companyName + '\' + 'Tenant Operator'				-- Tenant Operator
DECLARE @tenantOperatorUserGroupID INT = 0
BEGIN
	-- Any change made to this: make it in UMGroups.script too for existing groups.
	-- We will call create user group SP itself instead of directly inserting into all the tables like UMGroups, UMSecurityAssociations, etc.
	-- This SP will just create the tenant operator group. Assigning role will be taken care of by set tenant operator role stored procedure.
	DECLARE @userGroupPropertiesXML XML
	SET @userGroupPropertiesXML = (
									SELECT
										(
											SELECT @tenantOperatorUserGroupname AS '@userGroupName'
											FOR XML PATH('userGroupEntity'), TYPE
										)
									FOR XML PATH(''), ROOT('App_GroupInfo')
								  )
	EXEC sec_performUserGroupOperation	@userId					-- userId
										,2						-- commcellId
										,@localeId				-- localeId
										,@userGroupPropertiesXML OUTPUT		-- XML
										,1					-- Create operation
										,0					-- isCmdLine
										,0				-- isSelectXML
	SET @errorCode = @userGroupPropertiesXML.value('(App_GenericEntityResponse/@errorCode)[1]', 'INT')
	SET @errorString = @userGroupPropertiesXML.value('(App_GenericEntityResponse/@errorString)[1]', 'VARCHAR(1024)')
	SET @tenantOperatorUserGroupID = @userGroupPropertiesXML.value('(App_GenericEntityResponse/entity/@userGroupId)[1]','INT')
	-- Update the flag with Tenant operator flag value.
DECLARE @tenantOperatorGroupFlag INT = CAST(0x40000 AS INT) | CAST(0x0001 AS INT) | CAST(0x0010 AS INT)
	UPDATE UMGroups
	SET groupFlags = groupFlags |  @tenantOperatorGroupFlag 				-- 262161
	WHERE
		id = @tenantOperatorUserGroupID
	-- From SP22, do NOT give any default Security associations for Tenant Operator group on the company. Neither add an entry in UMOperators as well.
END
PROC_EXIT:
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyTenantOperatorGroup')
	delete from GxQscripts where name = 'AppSetCompanyTenantOperatorGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantOperatorGroup')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantOperatorGroup'
GO

insert into GXDBVersions values(2, 'AppSetCompanyTenantOperatorGroup',  '00000000000000000000', 'AppSetCompanyTenantOperatorGroup', '00000000000000000000')
GO

