

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyTenantAdminProperties.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyTenantAdminProperties()
--  | Description:  This procedure will be used while creating a company. This will set the properties for a tenant admin.
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyTenantAdminProperties.sp,v $ $Id: AppSetCompanyTenantAdminProperties.sp,v 1.1.2.4 2020/02/04 17:16:16 njudge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyTenantAdminProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyTenantAdminProperties <<<'
	drop procedure AppSetCompanyTenantAdminProperties
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyTenantAdminProperties')
	delete from GxQscripts where name = 'AppSetCompanyTenantAdminProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantAdminProperties')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantAdminProperties'
GO
print '... Creating Procedure: AppSetCompanyTenantAdminProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyTenantAdminProperties
  @i_tenantAdminUserId INTEGER,
  @i_companyId INTEGER,
  @i_isCompanyReplicatedFromIDPCommcell INTEGER = 0
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(1024) =''
SET NOCOUNT ON
BEGIN TRY
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	--Set this user as owner of the company
	UPDATE UMDSProviders SET ownerId=@i_tenantAdminUserId WHERE id = @i_companyId
	IF @i_isCompanyReplicatedFromIDPCommcell = 0
	BEGIN
		-- Set 'Enforce Password Change', 'Primary Contact' and 'Invitatin Sent' for this user,
		INSERT INTO [dbo].[UMUsersProp]
			([componentNameId]
			,[attrName]
			,[attrType]
			,[attrVal]
			,[created]
			,[modified])
		VALUES
			(@i_tenantAdminUserId
			,'Invitation sent'
			,7
			,1
			,@nowTime
			,0),
			(@i_tenantAdminUserId
			,'Enforce Password Change'
			,7
			,1
			,@nowTime
			,0)
	END
	INSERT INTO [dbo].[UMUsersProp]
			([componentNameId]
			,[attrName]
			,[attrType]
			,[attrVal]
			,[created]
			,[modified])
		VALUES
			(@i_tenantAdminUserId
			,'Primary Contact'
			,7
			,'1'
			,@nowTime, 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	select @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyTenantAdminProperties')
	delete from GxQscripts where name = 'AppSetCompanyTenantAdminProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantAdminProperties')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantAdminProperties'
GO

insert into GXDBVersions values(2, 'AppSetCompanyTenantAdminProperties',  '00010001000200040000', 'AppSetCompanyTenantAdminProperties', '00010001000200040000')
GO

