

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyTenantAdminGroupPermission.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  SpAppSetCompanyTenantAdminGroupPermission()
--  | Description:  This procedure will be used while creating a company. This will set permissions on tenant admin user group.
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyTenantAdminGroupPermission.sp,v $ $Id: AppSetCompanyTenantAdminGroupPermission.sp,v 1.1.2.10 2020/08/21 08:15:54 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyTenantAdminGroupPermission')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyTenantAdminGroupPermission <<<'
	drop procedure AppSetCompanyTenantAdminGroupPermission
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyTenantAdminGroupPermission')
	delete from GxQscripts where name = 'AppSetCompanyTenantAdminGroupPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantAdminGroupPermission')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantAdminGroupPermission'
GO
print '... Creating Procedure: AppSetCompanyTenantAdminGroupPermission'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyTenantAdminGroupPermission
  @i_companyId INTEGER,
  @i_companyProperties XML,
  @i_localeId INTEGER
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(MAX) =''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
	DECLARE @tenantGrpId NVARCHAR(64) = ISNULL((SELECT id FROM umgroups WHERE umdsProviderId=@i_companyId AND name = 'Tenant Admin'),0)--Cannot check for the flag here as the flag is not yet set. TENANT_ADMIN_USER_GROUP_NAME
	DECLARE @entityRequest NVARCHAR(MAX) = N'<App_SecurityAssociationForEntityList><ownerAssociations ownersOperationType="1">
			<categoryPermission categoriesPermissionOperationType="1"><categoriesPermissionList _type_="123" clientSidePackage="1" consumeLicense="1"
			srmReportSet="0" srmReportType="0" type="0"/></categoryPermission><owners _type_="15" userGroupId="' + @tenantGrpId + '" />
			</ownerAssociations></App_SecurityAssociationForEntityList>'
	DECLARE @roleId INT
SET @roleId =ISNULL((SELECT id FROM UMRoles WHERE (flags & 64  <> 0) and name = 'Plan Subscription Role'),0)--'Plan Subscription Role'
	DECLARE @tempPlansToAdd TABLE (planId INT)
	INSERT INTO @tempPlansToAdd
	SELECT t.ref3.value('@planId', 'INT')
    FROM @i_companyProperties.nodes('Api_OrganizationInfo') R ( ref )
             OUTER APPLY ref.nodes('planDetails') S(ref2)
			  OUTER APPLY ref2.nodes('plan') t(ref3)
DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)
		 -- Add more check here
	 -- company can get a plan which is owned by Commcell or actual company
	 DECLARE @planNotAllowed NVARCHAR(MAX)
	 declare @planNotAllowedCount INT  = 0
	--SELECT @planNotAllowed = COALESCE(@planNotAllowed + ' ,', '') + AP.name, @planNotAllowedCount=@planNotAllowedCount + 1 FROM  @tempPlansToAdd TP
	SELECT @planNotAllowed = COALESCE(@planNotAllowed + ' ,', '') + AP.name, @planNotAllowedCount=SUM(COUNT(AP.name))  OVER() FROM  @tempPlansToAdd TP
	INNER JOIN APP_Plan AP
		ON AP.id=TP.planId
	WHERE dbo.AppGetOrganizationForUser(AP.ownerId) NOT IN (0 /*Commcell company Id*/, @i_companyId)
	GROUP BY AP.name
	IF @planNotAllowed IS NOT NULL
	BEGIN
		IF @planNotAllowedCount = 1
		BEGIN
			--Error Setting plan. Plan(s) '^1%s' is/are owned by another company.
SET @errCode = (3931 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
		ELSE
		BEGIN
			--Error Setting plan. Plans '^1%s' are owned by another companies.
SET @errCode = (3932 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
		SET @errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = @errCode AND localeId = @i_localeId)
		SET @errString = REPLACE(@errString, '^1%s', @planNotAllowed)
        GOTO SCRIPT_EXIT
	END
	DECLARE @xmlEntities nvarchar(max)
	SET @xmlEntities =(SELECT 150 '@_type_', planId AS '@entityId', 158 AS  '@entityType'
					FROM  @tempPlansToAdd
				  FOR XML PATH('entity'), ROOT ('entities'))
 DECLARE @resultTable TABLE( errorCode INT, errorString NVARCHAR(1024))
DECLARE @xmlSecStr nvarchar(max)
SET @xmlSecStr = '<App_SecurityAssociationForUserOrGroupList associationsOperationType="2">
						<associations>'
							+ @xmlEntities +
							'<properties>
								<role roleId="'+convert(nvarchar(max),@roleId)+'"/>
<permissions  categoryId="107" permissionId="31"/>--CATEGORY_GLOBAL, EV_VISIBILITY
<permissions  categoryId="118" permissionId="159"/>--CATEGORY_PLAN, CAT_PLAN_ASSOCIATIONS_ADD_REMOVE
	  						</properties>
						</associations>
						<associations>'
							+ '<entities>
<entity _type_="150" entityType="61" entityId="' + convert(nvarchar(max), @i_companyId)+'"/>
	  						</entities>' +
							'<properties>
								<role roleId="'+convert(nvarchar(max),@tenantAdminRoleId)+'"/>
	  						</properties>
						</associations>
					</App_SecurityAssociationForUserOrGroupList>'
IF @tenantGrpId != 0
BEGIN
	--Set flag on tenant admin
	UPDATE UMGroups
SET groupFlags = groupFlags | 0x10000
	WHERE id = @tenantGrpId
	--Give permissions on plan and provider entity
	INSERT INTO @resultTable
	EXEC sec_setSecurityAssociationsFromUserOrUserGroup @xmlSecStr, 1, 0, @tenantGrpId, 0
	SELECT  @errCode=errorCode from @resultTable
	IF(@errCode >0)
		SELECT  @errString =errorString from @resultTable
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
	SELECT @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyTenantAdminGroupPermission')
	delete from GxQscripts where name = 'AppSetCompanyTenantAdminGroupPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyTenantAdminGroupPermission')
	delete from GXDBVersions where aliasname = 'AppSetCompanyTenantAdminGroupPermission'
GO

insert into GXDBVersions values(2, 'AppSetCompanyTenantAdminGroupPermission',  '00010001000200100000', 'AppSetCompanyTenantAdminGroupPermission', '00010001000200100000')
GO

