

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyProperties.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyProperties.sp,v $ $Id: AppSetCompanyProperties.sp,v 1.1.2.89.14.1 2021/03/05 00:45:15 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetCompanyProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyProperties <<<'
	drop procedure AppSetCompanyProperties
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyProperties')
	delete from GxQscripts where name = 'AppSetCompanyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyProperties')
	delete from GXDBVersions where aliasname = 'AppSetCompanyProperties'
GO
print '... Creating Procedure: AppSetCompanyProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetCompanyProperties
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @localeId INT = 0 --Default it to 0 for now
DECLARE @i_userId     		INTEGER
DECLARE @canManageProvider INT=0
DECLARE @portNumber INT = 0
DECLARE @tenantAdminGroupId INT = 0
DECLARE @secAssocXML XML
--DECLARE @isAllPlansDisassociated INT = 0
DECLARE @webconsoleClients  table(clientId int)
DECLARE @nowTime   integer
SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @ownerCompany INT = 0
DECLARE @i_providerId INT = -1
DECLARE @emailDomains TABLE (emailDomain nvarchar(512))
DECLARE @ownerCompanyServiceType int = 0
DECLARE @o_errCode integer =0
DECLARE @o_errString nvarchar(1024)= ''
DECLARE @companyNewName nvarchar(4000)
DECLARE @newAliasName nvarchar(255)
DECLARE @additionalDomainsOperationType INT
DECLARE @jobStartTime INT = NULL
DECLARE @isJobStartTimeEnabled INT = NULL
DECLARE @useCompanyGlobalFilter INT = NULL
DECLARE @passkeyXML XML
DECLARE @companyEntity nvarchar(max)
SET  @i_providerId = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organization/shortName/@id)[1]', 'INT')
SET @i_userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                     FROM @o_xmlText.nodes ('Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo/user') R(ref)), 0)
SET @localeId = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
DECLARE @companyGroup int = 0
DECLARE @IsMSPAdminOrReseller int = 0 --not populated
--USE #tempCompanyPropTbl TABLE TO INSERT OR UPDATE THE APP_COMPANYPROP TABLE.
IF(@i_userId > 0)
BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
END
SET  @companyNewName = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/@newConnectName)[1]', 'nvarchar(4000)'), '')
SET  @companyNewName = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/@newCompanyName)[1]', 'nvarchar(4000)'), @companyNewName)
SET @newAliasName = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/@newAliasName)[1]', 'nvarchar(255)'), '')
SET  @i_providerId = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organization/shortName/@id)[1]', 'INT')
SET  @additionalDomainsOperationType = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@additionalDomainsOperationType)[1]', 'INT')
SET @jobStartTime =  @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@jobStartTime)[1]', 'INT')
SET @isJobStartTimeEnabled = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@isJobStartTimeEnabled)[1]', 'INT')
SET @useCompanyGlobalFilter = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@useCompanyGlobalFilter)[1]', 'INT')
IF @canManageProvider <> 1
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO EXIT_ERROR
END
SET @ownerCompanyServiceType = ISNULL((SELECT serviceType FROM UMDSProviders WHERE id=@ownerCompany),0)
SELECT @companyGroup = CG.id FROM APP_ClientGroup CG
    INNER JOIN App_CompanyProp C ON C.attrValInt = CG.id
WHERE C.componentNameId = @ownerCompany AND C.attrName = 'Associated Smart Client Group' AND C.cs_attrName = CHECKSUM('Associated Smart Client Group') AND C.modified = 0
--MSP/Reseller admin only can
--Company name, alias, Enable reseller mode, Infrastructure type, Sites
EXEC sec_checkPermissionOnEntity @i_userId, 1, @IsMSPAdminOrReseller OUT,1,2
IF (@IsMSPAdminOrReseller=0)
BEGIN
	SET @IsMSPAdminOrReseller = dbo.sec_isUserOperator(@i_userId, @ownerCompany)
END
IF(@companyNewName <> '' AND @ownerCompany > 0)--do not change name for commcell(id = 0)
BEGIN
		--Get existing company name
		DECLARE @companyName nvarchar(4000)=''
		SELECT @companyName = hostname FROM UMDSProviders WHERE id=@ownerCompany
		IF(@companyNewName <> @companyName)
		BEGIN
			IF(@IsMSPAdminOrReseller = 0)
			BEGIN
				--User do not have permission to change the company name.
SET @o_errCode = (4536 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4536 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO EXIT_ERROR
			END
IF EXISTS(SELECT 1 FROM UMDSProviders WHERE hostName=@companyNewName AND id<>@ownerCompany AND flags &  0x0002 = 0 AND serviceType=  5) -- verify same company name doens't exists
			BEGIN
SET @o_errCode = (3443 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = 			(3443 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO EXIT_ERROR
			END
			UPDATE UMDSProviders SET hostName=@companyNewName WHERE id=@ownerCompany
			DECLARE @companyCGNewName nvarchar(4000)= @companyNewName
EXEC AppGetUniqueEntityName 28, @companyCGNewName, @i_userId, @companyCGNewName OUTPUT
			UPDATE APP_ClientGroup SET name = @companyCGNewName WHERE ID=@companyGroup
		END
END
--domain name change
IF(@newAliasName <> '' AND @newAliasName IS NOT NULL)
BEGIN
		DECLARE @OrganizationAlias nvarchar(255)=''
		SELECT @OrganizationAlias = domainName FROM UMDSProviders WHERE id=@ownerCompany
		IF(@OrganizationAlias <> @newAliasName)
		BEGIN
			IF(@IsMSPAdminOrReseller = 0)
			BEGIN
				--User do not have permission to change the company domain name.
SET @o_errCode = (4535 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4535 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO EXIT_ERROR
			END
IF EXISTS(SELECT 1 FROM UMDSProviders WHERE domainName=@newAliasName AND id<>@ownerCompany AND flags & 0x0002 = 0) -- verify same company name doens't exists
			BEGIN
SET @o_errCode = (3759 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3759 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId) -- 'Company with same alias already exists'
				GOTO EXIT_ERROR
			END
			UPDATE UMDSProviders SET domainName=@newAliasName WHERE id=@ownerCompany
			--update login name of all the users
			UPDATE UMUsers SET LOGIN = REPLACE(cast(login as NVARCHAR(MAX)),@OrganizationAlias  + '\', @newAliasName + '\') --REPLACE(login, LEFT(login,(CHARINDEX('\',login, 1)) ), @newAliasName + '\')
			WHERE umDSproviderId=@ownerCompany
			--Update the client group rule
			IF(@companyGroup > 0)
			BEGIN
				DECLARE @xmlRule XML
				SELECT @xmlRule=ruleXML FROM App_SCGRule WHERE scgId=@companyGroup
				IF(@xmlRule IS NOT NULL)
				BEGIN
					SET @xmlRule.modify('replace value of (/scgRule/rules/rule/rules/rule[@propID=("44")]/@secValue)[1] with sql:variable("@newAliasName")')
					SET @xmlRule.modify('replace value of (/scgRule/rules/rule/rules/rule[@propID=("55")]/@secValue)[1] with sql:variable("@newAliasName")')
					UPDATE App_SCGRule SET ruleXml=@xmlRule WHERE scgId=@companyGroup
				END
				ELSE
				BEGIN
					PRINT 'Smart client group rule not was not found for company client group Id ' + CAST(@companyGroup AS VARCHAR(10))
				END
				--update advance setting
				UPDATE APP_AdvanceSettings SET value = REPLACE(cast(value as NVARCHAR(MAX)),@OrganizationAlias  + '\', @newAliasName + '\')
WHERE  entityType=28 and keyName='DefaultUserGroupName' and entityId=@companyGroup
				AND LEFT(cast(value as NVARCHAR(MAX)),(CHARINDEX('\',value, 0))) =@OrganizationAlias  + '\'
UPDATE APP_AdvanceSettings SET value = @newAliasName where entityType=28 AND keyName = 'sLaptopUserDomain'  and entityId=@companyGroup AND cast(value as NVARCHAR(MAX)) = @OrganizationAlias
			END
		END
END
IF object_id('tempdb.dbo.#tempUMDSProviderPropTbl') IS NOT null DROP TABLE #tempUMDSProviderPropTbl
CREATE TABLE #tempUMDSProviderPropTbl (componentId int, propertyAttrName nvarchar(255), stringVal NVARCHAR(max), attrType INT)
SET @tenantAdminGroupId = (SELECT UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@ownerCompany)
-- Call code to setup Ediscovery for Company before processing company properties
EXEC dbo.AppSetEDiscoveryForCompany @ownerCompany, '', @o_xmlText , @o_errCode OUTPUT, @o_errString OUTPUT
--Get properties to be updated.
IF object_id('tempdb.dbo.#tempCompanyPropTbl') IS NOT null DROP TABLE #tempCompanyPropTbl
CREATE TABLE #tempCompanyPropTbl (componentId int, propertyAttrName nvarchar(255), stringVal NVARCHAR(max), attrType INT)
INSERT INTO #tempCompanyPropTbl (componentId, propertyAttrName, stringVal, attrType)
SELECT distinct @ownerCompany , CA.propertyTypId, CA.Value, CA.attrType
FROM @o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties') R ( ref )
			OUTER APPLY ref.nodes('additionalDomains') U(ref5)
			OUTER APPLY ref.nodes('apiQuota') A(ref6)
CROSS APPLY (
SELECT 'Primary Domain' AS propertyTypId,  r.ref.value('@primaryDomain','NVARCHAR(MAX)') AS Value, 1 AS attrType   UNION ALL
SELECT 'Notification Email' AS propertyTypId, r.ref.value('@senderSmtp','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'Notification Sender Name' AS propertyTypId,  r.ref.value('@senderName','NVARCHAR(MAX)') AS Value, 1 AS attrType  UNION ALL
SELECT 'Prefer Machine Centric Client' AS propertyTypId,  r.ref.value('@preferenceMachineCentricClient','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'Enable Auth Code Generation' AS propertyTypId,  r.ref.value('@enableAuthCodeGen','NVARCHAR(MAX)') AS Value, 7 AS attrType  UNION ALL
SELECT 'Use UPN For Email' AS propertyTypId,  r.ref.value('@useUPNForEmail','NVARCHAR(MAX)') AS Value, 7 AS attrType  UNION ALL
SELECT 'Allow Users To Enable Privacy' AS propertyTypId,  r.ref.value('@allowUsersToEnablePrivacy','NVARCHAR(MAX)') AS Value, 7 AS attrType  UNION ALL
SELECT 'completedSetups' AS propertyTypId, r.ref.value('@completedSetups','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'supportedSolutions' AS propertyTypId, r.ref.value('@supportedSolutions','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'PremiseStorageType' AS propertyTypId, r.ref.value('@infrastructureType','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'Sub Domain' AS propertyTypId,  u.ref5.value('@val','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'API Quota Limit' AS propertyTypId,  a.ref6.value('@APILimit','NVARCHAR(MAX)') AS Value, 7 AS attrType  UNION ALL
SELECT 'API Quota Time Frame' AS propertyTypId,  a.ref6.value('@APItimeFrame','NVARCHAR(MAX)') AS Value, 7 AS attrType  UNION ALL
SELECT 'Always activate with default plan' AS propertyTypId,  r.ref.value('@alwaysActivateWithDefaultPlan','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'Allow to Manage Other Companies' AS propertyTypId, r.ref.value('@canCreateCompanies','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'ClientOwnerAssignmentType' AS propertyTypId,  r.ref.value('@autoClientOwnerAssignmentType','NVARCHAR(128)') AS Value, 7 AS attrType  UNION ALL
SELECT 'ClientOwnerAssignmentValue' AS propertyTypId,  r.ref.value('@autoClientOwnerAssignmentValue','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'AllowSettingPasskey' AS propertyTypId, r.ref.value('@allowUsersToEnablePasskey','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'Salesforce Customer Id' AS propertyTypId, r.ref.value('@salesforceCustomerId','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'Contract Id' AS propertyTypId, r.ref.value('@contractId','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'License Usage VM Count' AS propertyTypId, r.ref.value('@quotaVMCount','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'License Usage User Count' AS propertyTypId, r.ref.value('@quotaUserCount','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'vOrg Name' AS propertyTypId, r.ref.value('@vOrgName','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'vOrg Guid' AS propertyTypId, r.ref.value('@vOrgGuid','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
SELECT 'Enable eDiscovery for Laptop' AS propertyTypId, r.ref.value('@enableEDiscoveryForLaptop','NVARCHAR(MAX)') AS Value, 7 AS attrType UNION ALL
SELECT 'Enable eDiscovery for O365' AS propertyTypId, r.ref.value('@enableEDiscoveryForO365','NVARCHAR(MAX)') AS Value, 7 AS attrType
) CA
WHERE ca.Value is not null
DECLARE @oldsupportedSolutions INT = NULL
DECLARE @newsupportedSolutions INT = NULL
SET @newsupportedSolutions = (SELECT stringVal FROM #tempCompanyPropTbl WHERE propertyAttrName = 'supportedSolutions' and componentId = @ownerCompany)
IF(@newsupportedSolutions IS NOT NULL AND  @IsMSPAdminOrReseller = 0 ) --UI will send all the properties even though it is not changed so check againts DB
BEGIN
SET @oldsupportedSolutions = ISNULL((SELECT attrVal from App_CompanyProp where attrName = 'supportedSolutions' and componentNameId = @ownerCompany AND cs_attrName = CHECKSUM('supportedSolutions') AND modified = 0), 0)
	IF(@newsupportedSolutions <> @oldsupportedSolutions)
	BEGIN
		--User do not have permission to change the supported solutions
SET @o_errCode = (4539 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4539 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO EXIT_ERROR
	END
END
-- updating forceDeleteDevicesAfterDays and retireDevicesAfterDays
IF @o_xmlText.exist('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/autoRetireDevices') = 1
BEGIN
	DECLARE @iForceDeleteDevicesAfterDays INT = NULL;
	DECLARE @iRetireDevicesAfterDays INT = NULL;
	DECLARE @oForceDeleteDevicesAfterDays INT = NULL;
	DECLARE @oRetireDevicesAfterDays INT = NULL;
	SET @iForceDeleteDevicesAfterDays = ISNULL (@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/autoRetireDevices/@forceDeleteDevicesAfterDays)[1]', 'INT'),
ISNULL((SELECT attrVal FROM APP_CompanyProp (NOLOCK) WHERE attrName = 'Force delete devices after days' AND componentNameId = @ownerCompany AND modified = 0),365)
										  )
	SET @iRetireDevicesAfterDays = ISNULL (@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/autoRetireDevices/@retireDevicesAfterDays)[1]', 'INT'),
ISNULL((SELECT attrVal FROM APP_CompanyProp (NOLOCK) WHERE attrName = 'Retire devices after days' AND componentNameId = @ownerCompany AND modified = 0),183)
										  )
	IF @iRetireDevicesAfterDays < 0
	BEGIN
		SET @oRetireDevicesAfterDays = -1;
		SET  @oForceDeleteDevicesAfterDays = -1;
	END
	ELSE IF @iRetireDevicesAfterDays > @iForceDeleteDevicesAfterDays AND  @iForceDeleteDevicesAfterDays >= 0
	BEGIN
		SET @oRetireDevicesAfterDays = @iRetireDevicesAfterDays;
SET @oForceDeleteDevicesAfterDays = @iRetireDevicesAfterDays +  183;
	END
	ELSE
	BEGIN
		SET @oRetireDevicesAfterDays = @iRetireDevicesAfterDays;
		SET @oForceDeleteDevicesAfterDays = @iForceDeleteDevicesAfterDays;
		IF @iRetireDevicesAfterDays < -1
		BEGIN
			SET @oRetireDevicesAfterDays = -1;
		END
		IF @iForceDeleteDevicesAfterDays < -1
		BEGIN
			SET @oForceDeleteDevicesAfterDays = -1;
		END
	END
	INSERT INTO #tempCompanyPropTbl (componentId, propertyAttrName, stringVal, attrType)
VALUES (@ownerCompany,'Retire devices after days', @oRetireDevicesAfterDays, 7)
	INSERT INTO #tempCompanyPropTbl (componentId, propertyAttrName, stringVal, attrType)
VALUES (@ownerCompany,'Force delete devices after days',@oForceDeleteDevicesAfterDays,7 )
EXEC AppUpdateDataRetentionForDeconfiguredClients @ownerCompany, 61, @oForceDeleteDevicesAfterDays,0, @o_errCode OUTPUT, @o_errString OUTPUT
	IF @o_errCode != 0
	BEGIN
		GOTO EXIT_ERROR
	END
END
DECLARE @oldPremiseStorageType INT = NULL
DECLARE @newPremiseStorageType INT = NULL
SET @newPremiseStorageType = (SELECT stringVal FROM #tempCompanyPropTbl WHERE propertyAttrName = 'PremiseStorageType' and componentId = @ownerCompany)
SET @oldPremiseStorageType = ISNULL((SELECT attrVal from App_CompanyProp where attrName = 'PremiseStorageType' and cs_attrName = CHECKSUM('PremiseStorageType') and componentNameId = @ownerCompany and modified = 0), 0)
IF(@newPremiseStorageType  IS NOT  NULL AND @IsMSPAdminOrReseller = 0 AND @newPremiseStorageType <> @oldPremiseStorageType)
BEGIN
	--User do not have permission to change the Infrastructure Type
SET @o_errCode = (4537 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4537 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO EXIT_ERROR
END
IF @oldPremiseStorageType <> 0
BEGIN
	IF @oldPremiseStorageType = 1 and @newPremiseStorageType < 1  -- ApiMsg::PremiseStorageType.OWN_STORAGE = 1
	BEGIN
SET @o_errCode = (3919 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3919 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO EXIT_ERROR
	END
	ELSE IF @oldPremiseStorageType = 2 and @newPremiseStorageType < 2 -- ApiMsg::PremiseStorageType.HYBRID = 2
	BEGIN
SET @o_errCode = (3918 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3918 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO EXIT_ERROR
	END
END
--validate and get site domain settings string to save in app_companyprop table
DECLARE @DomainTbl TABLE (attrName varchar(256), DomainName NVARCHAR(MAX) )
DECLARE @subDomainTbl TABLE ( DomainName NVARCHAR(MAX) )
DECLARE @subDomainTblAdd TABLE ( DomainName NVARCHAR(MAX) )
DECLARE @subDomainTblDelete TABLE ( DomainName NVARCHAR(MAX) )
DECLARE @SubDomainStr nvarchar(max)=''--to save property in app_companyprop
DECLARE @primaryDomainInDB nvarchar(1024)
DECLARE @primaryDomainInRequest NVARCHAR(1024)
--Add key for sub domain, domain
IF @additionalDomainsOperationType is not null OR EXISTS (SELECT TOP 1 * FROM #tempCompanyPropTbl WHERE propertyAttrName in('Primary Domain','Sub Domain'))
BEGIN
	SET @primaryDomainInDB = (SELECT attrval  FROM App_CompanyProp WHERE componentNameId=@ownerCompany AND attrName = 'Primary Domain' AND cs_attrName = CHECKSUM('Primary Domain') AND modified = 0)
	INSERT INTO @DomainTbl
	SELECT C.attrName,  S.Data from
	(SELECT  attrName, attrVal FROM App_CompanyProp  p
INNER JOIN UMDSProviders u ON u.id=p.componentNameId AND u.flags &  0x0002  = 0  WHERE attrName  IN ('Sub Domain', 'Primary Domain') AND cs_attrName IN (CHECKSUM('Sub Domain'), CHECKSUM('Primary Domain')) AND componentNameId<>@ownerCompany AND P.modified = 0) C
		CROSS APPLY dbo.SplitString(C.attrVal, ',') S
	INSERT INTO @subDomainTbl
	SELECT S.Data from
(SELECT attrName, attrVal FROM App_CompanyProp WHERE attrName  = 'Sub Domain' AND componentNameId=@ownerCompany AND cs_attrName = CHECKSUM('Sub Domain') AND modified = 0) C
		CROSS APPLY dbo.SplitString(C.attrVal, ',') S
	IF @additionalDomainsOperationType = 1--overwrite
	BEGIN
	   INSERT INTO @subDomainTblAdd
            SELECT stringVal
FROM #tempCompanyPropTbl WHERE propertyAttrName = 'Sub Domain'
            EXCEPT
            SELECT DomainName
            FROM @subDomainTbl
        INSERT INTO @subDomainTblDelete
             SELECT DomainName
            FROM @subDomainTbl
            EXCEPT
            SELECT stringVal
FROM #tempCompanyPropTbl WHERE propertyAttrName ='Sub Domain'
	SET  @SubDomainStr=ISNULL((SELECT STUFF(( SELECT ',' + stringVal
FROM #tempCompanyPropTbl WHERE propertyAttrName ='Sub Domain'
              FOR
                XML PATH('')
              ), 1, 1, '') AS domainList),'')
	END
	ELSE IF(@additionalDomainsOperationType = 2) --ADD
	BEGIN
	INSERT INTO @subDomainTblAdd
            SELECT t1.stringVal FROM #tempCompanyPropTbl t1
		WHERE t1.propertyAttrName ='Sub Domain'
            EXCEPT
             SELECT DomainName
            FROM @subDomainTbl
			SET  @SubDomainStr=(SELECT STUFF(( SELECT ',' + a.DomainName
                FROM (SELECT DomainName FROM @subDomainTblAdd UNION  SELECT DomainName FROM @subDomainTbL) a
              FOR
                XML PATH('')
              ), 1, 1, '') AS domainList)
	END
	ELSE IF(@additionalDomainsOperationType = 3 )--delete
	BEGIN
		  INSERT INTO @subDomainTblDelete
             SELECT t1.stringVal FROM #tempCompanyPropTbl t1
		WHERE t1.propertyAttrName ='Sub Domain'
            INTERSECT
            SELECT DomainName
            FROM @subDomainTbl
			SET  @SubDomainStr=(SELECT STUFF(( SELECT ',' + a.DomainName
                FROM (SELECT DomainName FROM @subDomainTbl EXCEPT  SELECT DomainName FROM @subDomainTblDelete) a
              FOR
                XML PATH('')
              ), 1, 1, '') AS domainList)
	END
	IF(@IsMSPAdminOrReseller=0 AND (EXISTS(SELECT TOP 1 DomainName FROM @subDomainTblAdd) OR EXISTS(SELECT TOP 1 DomainName FROM @subDomainTblDelete)))
	BEGIN
		--User do not have permission to change the site name.
SET @o_errCode = (4538 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4538 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	END
	--Check for duplicate domain or sub domain name
IF EXISTS (SELECT 1 from  @DomainTbl  WHERE DomainName IN (SELECT DomainName FROM @subDomainTblAdd) OR EXISTS (SELECT 1 FROM  @DomainTbl  WHERE DomainName IN (SELECT stringVal FROM #tempCompanyPropTbl where propertyAttrName ='Primary Domain')))
	BEGIN
SET @o_errCode = (3213 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3213 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO EXIT_ERROR
	END
	--delete the rows for sub domain and now add the comma seperated strings for sub domains
DELETE #tempCompanyPropTbl where propertyAttrName='Sub Domain'
	IF(@SubDomainStr is not null)
	BEGIN
		INSERT INTO #tempCompanyPropTbl
SELECT distinct @ownerCompany ,'Sub Domain', @SubDomainStr, 1
	END
END
-- Update clientOwnerAssignmentValue based on clientOwnerAssignmentType
DECLARE @autoClientOwnerAssignmentType INT = (SELECT stringVal FROM #tempCompanyPropTbl where propertyAttrName = 'ClientOwnerAssignmentType')
DECLARE @autoClientOwnerAssignmentValue NVARCHAR(max) = (SELECT stringVal FROM #tempCompanyPropTbl where propertyAttrName = 'ClientOwnerAssignmentValue')
DECLARE @clientOwnerAssignmentValue NVARCHAR(max)
IF @autoClientOwnerAssignmentType IS NOT NULL
BEGIN
	SET @clientOwnerAssignmentValue =
		( CASE
WHEN @autoClientOwnerAssignmentType = 0 THEN 'Administrators,admin,'
WHEN @autoClientOwnerAssignmentType = 1 THEN 'EnumUserProfiles'
WHEN @autoClientOwnerAssignmentType = 2 THEN 'SetLoggedInUserAsOwnersOnce'
			WHEN @autoClientOwnerAssignmentType = 3 AND @autoClientOwnerAssignmentValue IS NOT NULL THEN @autoClientOwnerAssignmentValue
			ELSE ''
		  END
		)
	IF @autoClientOwnerAssignmentValue IS NOT NULL
	BEGIN
UPDATE #tempCompanyPropTbl SET stringVal = @clientOwnerAssignmentValue WHERE propertyAttrName = 'ClientOwnerAssignmentValue'
	END
	ELSE
	BEGIN
INSERT INTO #tempCompanyPropTbl (componentId, propertyAttrName, stringVal, attrType) VALUES (@ownerCompany, 'ClientOwnerAssignmentValue', @clientOwnerAssignmentValue,1)
	END
END
---------authcode settings-------------------------------------
--Need to update modified timestamp for authcode if generate auth code is disabled.
DECLARE @DisableAuthorizationCode int  = 0
IF EXISTS(SELECT stringVal from  #tempCompanyPropTbl WHERE propertyAttrName='Enable Auth Code Generation' AND stringVal='0')
BEGIN
		set @DisableAuthorizationCode = 1
INSERT INTO #tempCompanyPropTbl (componentId, propertyAttrName, stringVal, attrType) VALUES (@ownerCompany, 'Authorization Code', '123',1)--The stringVal is dummy here as this record has to just marked with modified=0 and not updating the attrVal column
--UPDATE App_CompanyProp SET modified =  @nowTime WHERE componentNameId = @ownerCompany AND attrName = 'Authorization Code' AND cs_attrName = CHECKSUM('Authorization Code') AND modified=0
END
--Now update the properties
--insert new input
MERGE App_CompanyProp AS T
USING #tempCompanyPropTbl AS S
ON  T.attrName = S.propertyAttrName and t.componentNameId=S.componentId  AND modified=0
WHEN MATCHED THEN
UPDATE SET T.attrVal=CASE WHEN modified=0 AND S.propertyAttrName<> 'Authorization Code' THEN s.stringVal ELSE T.attrVal END,
T.modified=case WHEN S.propertyAttrName = 'Authorization Code' AND @DisableAuthorizationCode = 1 THEN @nowTime ELSE T.modified END
WHEN NOT MATCHED THEN
INSERT (componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (s.componentId, S.propertyAttrName, s.attrType, s.stringVal,  @nowTime, 0);
---------Plan related-------------------------------------
EXEC AppSetCompanyPlans @o_xmlText, @ownerCompany, @tenantAdminGroupId, @o_errCode OUTPUT, @o_errString OUTPUT
IF(@o_errCode > 0 )
	BEGIN
		GOTO EXIT_ERROR
END
---------end Plan related-------------------------------------
---------Primary Contact-------------------------------------
EXEC AppSetCompanyPrimayContacts @o_xmlText, @tenantAdminGroupId, @o_errCode OUTPUT, @o_errString OUTPUT
IF(@o_errCode > 0 )
BEGIN
		GOTO EXIT_ERROR
END
---------end Primary Contact-------------------------------------
---------authcode settings-------------------------------------
--Need to update modified timestamp for authcode if generate auth code is disabled.
IF EXISTS(SELECT stringVal from  #tempCompanyPropTbl WHERE propertyAttrName='Enable Auth Code Generation' AND stringVal='0')
BEGIN
UPDATE App_CompanyProp SET modified =  @nowTime WHERE componentNameId = @ownerCompany AND attrName = 'Authorization Code' AND cs_attrName = CHECKSUM('Authorization Code') AND modified=0
END
---------authcode settings-------------------------------------
---------push registry key settings starts here-------------------------------------
--For registry
IF object_id('tempdb.dbo.#tempClientsNeedRegistryUpdateTbl') IS NOT null DROP TABLE #tempClientsNeedRegistryUpdateTbl
CREATE TABLE #tempClientsNeedRegistryUpdateTbl (clientId INT)
DECLARE @registryToBeSet TABLE (entityId INT, entityType INT, keyName NVARCHAR(256), type NVARCHAR(40), relativePath NVARCHAR(2048), value NVARCHAR(256) DEFAULT '', deleted INT DEFAULT 0, hidden INT DEFAULT 1, sourceId INT DEFAULT 0, sourceEntityType INT DEFAULT 0)
DECLARE @needPushRegistryUpdateToCompanyClients INT = 0
-- UPDATE REGISTRY FOR enableAutoDiscovery PROPERTY. THIS DOES NOT APPLY TO COMMCELL, IN WITCH CASE PROVIDER ID IS 0
IF @i_providerId <> 0
BEGIN
	DECLARE @enableAutoDiscovery INT = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@enableAutoDiscovery)[1]', 'INT'), -1)
	DECLARE @enableAutoDiscoveryValue NVARCHAR(256) = '', @deleteEnableAutoDiscovery INT = 0
	IF @enableAutoDiscovery = 1
	BEGIN
SET @enableAutoDiscoveryValue = '2'
	END
	ELSE IF @enableAutoDiscovery = 0
	BEGIN
		SET @deleteEnableAutoDiscovery = 1
	END
	IF @enableAutoDiscovery IN (0, 1)
	BEGIN
		INSERT INTO @registryToBeSet
		(entityId, entityType, keyName, type, relativePath, value, deleted)
VALUES (@companyGroup, 28, 'nEnableAutoDetectApp', 'INTEGER', 'iDataAgent', @enableAutoDiscoveryValue, @deleteEnableAutoDiscovery)
		SET @needPushRegistryUpdateToCompanyClients = 1
	END
END
-- UPDATE REGISTRY FOR autoClientOwnerAssignmentType PROPERTY. THIS DOES NOT APPLY TO COMMCELL, IN WITCH CASE PROVIDER ID IS 0
IF @i_providerId <> 0
BEGIN
	DECLARE @deleteEnumuserprofile INT = 0, @deleteLoggedinuseronly INT = 0
	DECLARE @regValueEnable NVARCHAR(8) = '1', @regValueDisable NVARCHAR(8) = '0'
	DECLARE @valueEnumuserprofile NVARCHAR(8) = '', @valueLoggedinuseronly NVARCHAR(8) = ''
	IF @autoClientOwnerAssignmentType IS NOT NULL
	BEGIN
		IF @autoClientOwnerAssignmentType = 0
		BEGIN
			SET @valueEnumuserprofile = @regValueDisable
			SET @valueLoggedinuseronly = @regValueDisable
		END
		ELSE IF @autoClientOwnerAssignmentType = 1
		BEGIN
			SET @valueEnumuserprofile = @regValueEnable
			SET @deleteLoggedinuseronly = 1
		END
		ELSE IF @autoClientOwnerAssignmentType = 2
		BEGIN
			SET @deleteEnumuserprofile = 1
			SET @valueLoggedinuseronly = @regValueEnable
		END
		ELSE IF @autoClientOwnerAssignmentType = 3
		BEGIN
			SET @deleteEnumuserprofile = 1
			SET @deleteLoggedinuseronly = 1
		END
		IF @autoClientOwnerAssignmentType IN (0, 1, 2, 3)
		BEGIN
			INSERT INTO @registryToBeSet
			(entityId, entityType, keyName, type, relativePath, value, deleted)
VALUES (@companyGroup, 28, 'enumuserprofiles', 'INTEGER', 'iDataAgent', @valueEnumuserprofile, @deleteEnumuserprofile),
(@companyGroup, 28, 'nSetLoggedInUserAsOwnersOnce', 'INTEGER', 'iDataAgent', @valueLoggedinuseronly, @deleteLoggedinuseronly)
			SET @needPushRegistryUpdateToCompanyClients = 1
		END
	END
END
IF EXISTS (SELECT TOP 1 * FROM #tempCompanyPropTbl where propertyAttrName in('Primary Domain','Sub Domain'))
BEGIN
	INSERT INTO @webconsoleClients
    SELECT c.id
    FROM app_client c
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
	LEFT JOIN App_VMToPMMAp vm ON vm.PMClientId=c.id WHERE VMClientId is null
	UNION
	SELECT vm.VMClientId
	FROM app_client c
	INNER JOIN App_VMToPMMAp vm ON c.id=PMClientId
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
SET @primaryDomainInRequest = (SELECT stringVal FROM #tempCompanyPropTbl where propertyAttrName  =  'Primary Domain')
	IF ((@primaryDomainInRequest is not null and @primaryDomainInDB is null) or (@primaryDomainInRequest <> '' AND @primaryDomainInRequest <> @primaryDomainInDB))
	BEGIN
		INSERT INTO @subDomainTblAdd
		SELECT @primaryDomainInRequest
	END
	IF(@primaryDomainInDB is not null and @primaryDomainInRequest <> @primaryDomainInDB)
	BEGIN
		INSERT INTO @subDomainTblDelete
		SELECT @primaryDomainInDB
	END
	UPDATE A
	SET  a.deleted=1
	FROM
	APP_AdvanceSettings A
	INNER JOIN (
	SELECT clientId,DomainName keyName
	FROM @webconsoleClients, @subDomainTblDelete ) p
	on p.clientId= a.entityId and a.relativePath='WebConsole\Customization'  and A.value like cast( @ownerCompany as nvarchar) AND A.keyName = p.keyName
	INSERT INTO @registryToBeSet
	(entityId, keyName, type, relativePath, value, deleted, entityType, sourceId, sourceEntityType)
	SELECT clientId,DomainName , 'STRING' , 'WebConsole\Customization' , cast( @ownerCompany as nvarchar) , deleted=CASE WHEN DomainName='' THEN 1 ELSE 0 END, 3 ,0,0
	FROM
	@webconsoleClients, @subDomainTblAdd
	INSERT INTO #tempClientsNeedRegistryUpdateTbl
	SELECT clientId
	FROM @webconsoleClients
END
-- ADD CLIENTS WITHIN THIS COMPANY TO #tempClientsNeedRegistryUpdateTbl, IF REGISTRY UPDATES NEED TO BE PUSHED TO THOSE CLIENTS
IF @needPushRegistryUpdateToCompanyClients = 1
BEGIN
	INSERT INTO #tempClientsNeedRegistryUpdateTbl
	SELECT clientId
	FROM APP_ClientGroupAssoc
	WHERE clientGroupId = @companyGroup
END
DECLARE @registryUpdateOutputs TABLE (action NVARCHAR(10), id INT, keyName NVARCHAR(256), entityId INT, entityType INT)
-- INSERT/UPDATE APP_AdvanceSettings AND APP_AdvanceSettingsEx BASED ON INFO IN @registryToBeSet
MERGE APP_AdvanceSettings AS target
USING @registryToBeSet AS source
ON target.entityId = source.entityId AND target.entityType = source.entityType AND target.keyName = source.keyName AND target.type = source.type AND target.relativePath = source.relativePath
WHEN MATCHED AND source.deleted = 1
	THEN DELETE
WHEN MATCHED AND source.deleted <> 1 AND CAST(target.value AS NVARCHAR(256)) <> source.value
	THEN UPDATE SET value = source.value
WHEN NOT MATCHED AND source.deleted <> 1
	THEN INSERT (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
	VALUES (source.entityId, source.keyName, source.type, source.relativePath, source.value, 1, 0, source.entityType, source.sourceId, source.sourceEntityType)
OUTPUT $action, inserted.id, inserted.keyName, inserted.entityId, inserted.entityType INTO @registryUpdateOutputs;
INSERT INTO APP_AdvanceSettingsEx
 (keyId, details, hidden)
SELECT after.id, '', 1
FROM @registryToBeSet before
JOIN @registryUpdateOutputs after ON before.hidden = 1 AND after.action = 'INSERT' AND before.keyName = after.keyName AND before.entityId = after.entityId AND before.entityType = after.entityType
-- INSERT WORK TOKEN TO WORK QUEUE SO THAT REGISTRY GETS PUSHED TO CLIENTS
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
SELECT DISTINCT clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1
FROM #tempClientsNeedRegistryUpdateTbl
---------push registry key settings ends here-------------------------------------
-------Update Navigation Settings-------------------------------------
IF @o_xmlText.exist('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/navSettings') = 1
BEGIN
	--Build XML
	DECLARE @navSettingXML XML = (SELECT
									(SELECT (SELECT @o_xmlText.query('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/navSettings') FOR XML PATH(''),TYPE))
									 FOR XML PATH('Api_UpdateNavItemsReq'),TYPE)
	-- Call Update SP
	EXEC AppNavSettingsSet @i_userId, @ownerCompany, @navSettingXML OUTPUT, @o_errCode OUTPUT, @o_errString OUTPUT
	IF(@o_errCode > 0 )
	BEGIN
		GOTO EXIT_ERROR
	END
END
-------Update Navigation Settings-------------------------------------
-----Setting the emailDomains for SAML redirection Rule in UMDSproviderprop-------------------------------------
INSERT INTO @emailDomains select ISNULL((select distinct ref.value('@val','nvarchar(255)') from @o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organization/emailDomainNames') R (ref)),'null')
IF EXISTS(SELECT emailDomain FROM @emailDomains WHERE emailDomain <> 'null')
BEGIN
	INSERT INTO #tempUMDSProviderPropTbl (componentId, propertyAttrName, stringVal, attrType)
	 SELECT  @i_providerId,'Email Domain',emailDomain,'1' from @emailDomains where emailDomain <> ''
END
-----Setting the emailDomains for SAML redirection Rule in UMDSproviderprop-------------------------------------
-----Setting Password History Count-------------------------
DECLARE @pswdHistoryCount INT
SET @pswdHistoryCount=(SELECT ref.value('@pswdHistoryCount','int') FROM @o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organization') R(ref))
IF @pswdHistoryCount IS NOT NULL
BEGIN
	INSERT INTO #tempUMDSProviderPropTbl (componentId, propertyAttrName, stringVal, attrType)
SELECT  @i_providerId,'Password History Count' ,@pswdHistoryCount,'1'
END
MERGE UMDSPROVIDERPROP AS T
USING #tempUMDSProviderPropTbl AS S
ON  T.attrName = S.propertyAttrName and t.componentNameId=S.componentId  AND modified=0
WHEN MATCHED THEN
UPDATE SET T.attrVal=s.stringVal
WHEN NOT MATCHED THEN
INSERT (componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (s.componentId, S.propertyAttrName, s.attrType, s.stringVal,  @nowTime, 0);
-- Set TFA on groups if enabled at company to 1, otherwise retain what exists at groups.
IF EXISTS (SELECT stringVal FROM #tempCompanyPropTbl WHERE propertyAttrName = 'EnableTwoFactorAuthentication' and stringVal='1')
BEGIN
	-- Only local user groups and not IDP /external
	 MERGE   UMGroupsProp AS TGT
        USING   (SELECT id FROM UMGroups where umdsproviderId = @i_providerId ) AS SRC
ON      TGT.componentNameId = SRC.id and TGT.attrName = 'DisableTwoFactorAuthentication' AND TGT.attrType = 7
        WHEN    MATCHED THEN        UPDATE SET TGT.attrVal = '0' --Property is DisableTwoFactor, so set it 0
        WHEN    NOT MATCHED THEN    INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.id, 'DisableTwoFactorAuthentication', 7, 0, @nowTime ,0);
END
-- If enable reseller mode is enabled, then we need to give Create Company permission in the backend for the tenant admin.
IF EXISTS (SELECT stringVal FROM #tempCompanyPropTbl WHERE propertyAttrName = 'Allow to Manage Other Companies' and stringVal='1')
BEGIN
	DECLARE @xmlSecStr nvarchar(max)
	SET @xmlSecStr = '<App_SecurityAssociationForUserOrGroupList associationsOperationType="2">
						<associations>
							<entities>	<!-- These Create permissions can be given on Company. Security framework handles it right -->
<entity _type_="61" providerId="' + CAST(@i_providerId AS VARCHAR(10)) + '"/>
							</entities>
							<properties isCreatorAssociation="0">
								<categoryPermission>
<categoriesPermissionList _type_="122" categoryId="14" permissionId="255"/>
								</categoryPermission>
							</properties>
						</associations>
					</App_SecurityAssociationForUserOrGroupList>'
	DECLARE @resultTable TABLE
	(
		errorCode INT,
		errorString NVARCHAR(1024)
	)
	INSERT INTO @resultTable
		EXEC sec_setSecurityAssociationsFromUserOrUserGroup	@xmlSecStr,
															@i_userId,			-- Currently only MSP admin is able to trigger this option. So we should be good passing this caller Id itself.
															0,
															@tenantAdminGroupId,
															0
	SELECT @o_errCode = errorCode,
		   @o_errString = errorString
	FROM @resultTable
	IF @o_errCode <> 0
		GOTO EXIT_ERROR
END
-- Configuring tenant operator role --
DECLARE @tenantOperatorRoleID INT = ISNULL((@o_xmlText.value('(//../organizationInfo/organizationProperties/operatorRole/@roleId)[1]', 'INT')), 0)
IF @tenantOperatorRoleId <> 0
BEGIN
	EXEC AppSetCompanyTenantOperatorRole @i_userId, @localeId, @i_providerId, 3/*Common::Operation_Modify*/, @tenantOperatorRoleId, @o_errCode OUTPUT, @o_errString OUTPUT
END
IF @o_errCode <> 0
	GOTO EXIT_ERROR
-- Setting operators --
DECLARE @orgInfoXML XML = @o_xmlText.query('//../organizationInfo')
EXEC sec_setCommvaultUserAsResellerForCompany @i_userId, @localeId, @orgInfoXML, @i_providerId, @o_errCode OUTPUT, @o_errString OUTPUT
IF @o_errCode <> 0
	GOTO EXIT_ERROR
-- Set Global Filters on smart client group --
IF @companyGroup > 0
BEGIN
	IF @useCompanyGlobalFilter IS NOT NULL
	BEGIN
IF EXISTS(SELECT 1 FROM APP_ComponentProp WHERE componentType = 8 AND componentId = @companyGroup AND propertyTypeId = 3622 AND modified = 0)
		BEGIN
			UPDATE APP_COMPONENTPROP
			SET modified = @nowTime
WHERE componentType = 8
			AND componentId = @companyGroup
AND propertyTypeId = 3622
			AND modified = 0
		END
		INSERT APP_ComponentProp(componentType, componentId, propertyTypeId, dataType, longVal, longlongVal, stringVal, created, modified)
SELECT 8, @companyGroup, 3622, 2 /*PROPERTY_BOOLEAN*/, @useCompanyGlobalFilter, 0, N'', @nowTime, 0
	END
	IF @o_xmlText.exist('//globalFiltersInfo/globalFiltersInfoList') = 1
	BEGIN
		EXEC AppSetClientGroupGlobalFilters @o_xmlText, @companyGroup, @localeId, @i_userId, @o_errCode OUTPUT, @o_errString OUTPUT
		IF(@o_errCode > 0 )
		BEGIN
			GOTO EXIT_ERROR
		END
	END
	-- Set showDLP(0/1) on company smart client group
	IF @o_xmlText.exist('/Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@showDLP') = 1
	BEGIN
		DECLARE @showDLP INT = (@o_xmlText.value('(/Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@showDLP)[1]', 'INT'))
UPDATE APP_ComponentProp SET longval = @showDLP WHERE propertytypeid = 3623 AND componentid = @companyGroup AND modified = 0
		IF @@ROWCOUNT = 0
			INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8, @companyGroup,  3623,8,@showDLP,0,N'', @nowTime, 0)
	END
END
IF (@companyGroup>0)
BEGIN
		IF object_id('tempdb.dbo.#DefaultPlansStartTime') IS NOT null DROP TABLE #DefaultPlansStartTime
		CREATE TABLE #DefaultPlansStartTime (
				planId		INT,
				dataTaskId	INT,
				jobStartTime INT,
				isStartTimeOverridden INT,
				entityTypeSelectedForJobStartTime INT
		)
		CREATE CLUSTERED INDEX DefaultPlansStartTime_planId_Index ON #DefaultPlansStartTime (planId)
		INSERT INTO #DefaultPlansStartTime(planId,dataTaskId,jobStartTime,isStartTimeOverridden,entityTypeSelectedForJobStartTime )
SELECT r.ref.value('(plan/@planId)[1]','INT') , dbo.AppPlanGetEntityValueV2(r.ref.value('(plan/@planId)[1]','INT') , 'Schedule policy', default), r.ref.value('@jobStartTime','INT'),
		r.ref.value('@isStartTimeOverridden','INT'),
		r.ref.value('@entityTypeSelectedForJobStartTime','INT')
		FROM @o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/planDetails') R ( ref )
		DELETE FROM #DefaultPlansStartTime
		WHERE dataTaskId IS NULL OR dataTaskId=0 OR (jobStartTime IS NULL AND isStartTimeOverridden IS NULL AND entityTypeSelectedForJobStartTime IS NULL)
		-- If job start time is not passed but overridden flag is passed then dont process it.
		DELETE FROM #DefaultPlansStartTime
		WHERE isStartTimeOverridden IS NOT NULL AND isStartTimeOverridden = 1 AND jobStartTime IS NULL
		-- We need to delete all job start time settings for plans where isStartTimeOverridden is set to 0 now.
		DELETE APP_ComponentProp FROM
		APP_ComponentProp INNER JOIN #DefaultPlansStartTime DefaultPlansStartTime
ON componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1304 AND dataType = DefaultPlansStartTime.dataTaskId
		AND isStartTimeOverridden = 0
		-- We need to delete all entityLevel stored for plans where job start time overriding is done.
		-- Delete CV_COMPONENT_PROP_JOB_START_TIME_ENTITYLEVEL_FOR_PLAN property for company client group always and insert it again.
		-- Since we are going to compare against system defaults and overwrite only what changed.
		DELETE APP_ComponentProp
		FROM APP_ComponentProp INNER JOIN #DefaultPlansStartTime DefaultPlansStartTime
ON componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1305 AND dataType = DefaultPlansStartTime.dataTaskId
		AND (isStartTimeOverridden = 1 OR (entityTypeSelectedForJobStartTime IS NOT NULL AND entityTypeSelectedForJobStartTime>=0))
IF EXISTS(SELECT 1 FROM APP_ComponentProp WHERE componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1303 AND modified = 0)
		BEGIN
			DELETE #DefaultPlansStartTime
			WHERE entityTypeSelectedForJobStartTime = 189 -- If company has start time specified, then thats the default. Delete all entries where user has selected system default. Handling similar to how appmgr handles default properties.
		END
		ELSE
		BEGIN
			DELETE #DefaultPlansStartTime
			WHERE entityTypeSelectedForJobStartTime = 158 -- If company doesnt have start time specified, then plan setting is default. Delete all entries where user has selected system default. Handling similar to how appmgr handles default properties.
		END
		MERGE APP_ComponentProp as addSet
USING (SELECT 1304 as PropertyType, DefaultPlansStartTime.dataTaskId , jobStartTime AS PropertyVal FROM #DefaultPlansStartTime DefaultPlansStartTime
			WHERE isStartTimeOverridden = 1 AND jobStartTime >= 0
			UNION
SELECT 1305, DefaultPlansStartTime.dataTaskId , entityTypeSelectedForJobStartTime AS propertyVal FROM #DefaultPlansStartTime DefaultPlansStartTime
			WHERE (isStartTimeOverridden IS NULL OR isStartTimeOverridden = 0 ) AND entityTypeSelectedForJobStartTime>0 ) S
ON componentType = 8 AND componentId =  @companyGroup AND propertyTypeId = S.PropertyType AND dataType = S.dataTaskId
		WHEN MATCHED THEN UPDATE SET addSet.longVal = S.PropertyVal
		WHEN NOT MATCHED THEN
		INSERT (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8 ,@companyGroup,S.PropertyType, S.dataTaskId , S.PropertyVal,0, '' , @nowTime,   0)  ;
END
-- Set batch job start time at orgnaization level after setting start time at plan level. Since system default for plan level or company level may change.
IF (@companyGroup > 0 AND (@jobStartTime IS NOT NULL OR @isJobStartTimeEnabled IS NOT NULL))
BEGIN
	IF (@jobStartTime IS NOT NULL AND @jobStartTime>=0)
	BEGIN
IF EXISTS(SELECT 1 FROM APP_ComponentProp WHERE componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1303 AND modified = 0)
		BEGIN
			UPDATE APP_ComponentProp
			SET longVal = @jobStartTime
WHERE componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1303
			AND modified = 0
		END
		ELSE
		BEGIN
			INSERT INTO APP_ComponentProp (componenttype, componentid, propertytypeid,datatype,longval,longlongval,stringval,created,modified)
VALUES (8 ,@companyGroup,1303, 9, @jobStartTime ,0, '', @nowTime,   0)
		END
	END
	ELSE IF ((@isJobStartTimeEnabled IS NOT NULL AND @isJobStartTimeEnabled = 0) OR @jobStartTime = -1)
	BEGIN
DELETE FROM APP_ComponentProp WHERE componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1303
	END
END
-- Set passkeySettings and passkeyInfo for handling authorize for restore requests from JAVA GUI
-- For admin console/REST API users we have /Company/{id}/AuthRestore API endpoint to authorize for restore
IF @o_xmlText.exist('/Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/passkeySettings/@enableAuthorizeForRestore') = 1
BEGIN
	-- Restore for authorize
	IF object_id('tempdb.dbo.#tempAuthRestoreOutputTbl') IS NOT null DROP TABLE #tempAuthRestoreOutputTbl
	CREATE TABLE #tempAuthRestoreOutputTbl (errorCode INT, errorStr nvarchar(max), entityId INT)
	DECLARE @passkeySettings nvarchar(max) = cast(@o_xmlText.query('/Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/passkeySettings') as nvarchar(max))
	SET @companyEntity = '<company providerId="' + CAST(@ownerCompany as nvarchar(10)) + '"/>'
	DECLARE @passkey NVARCHAR(max) = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/passkeyInfo/@currentPasskey)[1]','nvarchar(max)')
	SET @passkeySettings = '<App_AuthorizeForRestoreRequest' + CASE @passkey WHEN '' THEN '>' ELSE ' passkey="' + @passkey +'">' END +
							cast(@o_xmlText.query('/Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo') as nvarchar(max)) + @companyEntity + @passkeySettings +'</App_AuthorizeForRestoreRequest>'
	SET @passkeyXML = CAST(@passkeySettings as XML)
	INSERT INTO #tempAuthRestoreOutputTbl
	EXEC [dbo].[AppSetAuthorizeForRestoreOnEntity] @passkeyXML
	SELECT @o_errCode = errorCode, @o_errString = errorStr FROM #tempAuthRestoreOutputTbl
	IF object_id('tempdb.dbo.#tempAuthRestoreOutputTbl') IS NOT null DROP TABLE #tempAuthRestoreOutputTbl
	IF(@o_errCode > 0 )
	BEGIN
		GOTO EXIT_ERROR
	END
END
-- Set passkeyInfo for setting/disabling passkey from JAVA GUI
-- For admin console/REST API users we have /Company/{id}/Passkey API endpoint to set/disable passkey
IF @o_xmlText.exist('/Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/passkeyInfo/@passkeyOpType') = 1
BEGIN
	-- passkey is set at company level
	IF object_id('tempdb.dbo.#tempPasskeyOutputTbl') IS NOT null DROP TABLE #tempPasskeyOutputTbl
	CREATE TABLE #tempPasskeyOutputTbl (errorCode INT, errorStr nvarchar(max))
	DECLARE @passkeyInfo nvarchar(max) = cast (@o_xmlText.query('/Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/passkeyInfo') as nvarchar(max))
	SET @companyEntity = '<company providerId="' + CAST(@ownerCompany as nvarchar(10)) + '"/>'
	SET @passkeyInfo = '<App_SetPasskeyRequest' + right(left(@passkeyInfo,LEN(@passkeyInfo) - 2),LEN(@passkeyInfo)-14) + '>' + @companyEntity +
						+ cast(@o_xmlText.query('/Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo') as nvarchar(max)) + '</App_SetPasskeyRequest>'
	SET @passkeyXML = CAST(@passkeyInfo as XML)
	INSERT INTO #tempPasskeyOutputTbl
	EXEC [dbo].[AppSetPasskeyOnEntity] @passkeyXML
	SELECT @o_errCode = errorCode, @o_errString = errorStr FROM #tempPasskeyOutputTbl
	IF object_id('tempdb.dbo.#tempPasskeyOutputTbl') IS NOT null DROP TABLE #tempPasskeyOutputTbl
	IF(@o_errCode > 0 )
	BEGIN
		GOTO EXIT_ERROR
	END
END
EXIT_ERROR:
SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_UpdateOrganizationPropertiesResponse'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_UpdateOrganizationPropertiesResponse'))
END CATCH
SCRIPT_EXIT:
IF object_id('tempdb.dbo.#tempCompanyPropTbl') IS NOT null DROP TABLE #tempCompanyPropTbl
IF object_id('tempdb.dbo.#DefaultPlansStartTime') IS NOT null DROP TABLE #DefaultPlansStartTime
IF object_id('tempdb.dbo.#tempUMDSProviderPropTbl') IS NOT null DROP TABLE #tempUMDSProviderPropTbl
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyProperties')
	delete from GxQscripts where name = 'AppSetCompanyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyProperties')
	delete from GXDBVersions where aliasname = 'AppSetCompanyProperties'
GO

insert into GXDBVersions values(2, 'AppSetCompanyProperties',  'v1.1.2.89.14.1', 'AppSetCompanyProperties', 'v1.1.2.89.14.1')
GO

