

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyPrimayContacts.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyPrimayContacts.sp,v $ $Id: AppSetCompanyPrimayContacts.sp,v 1.1.2.1 2018/03/07 18:29:13 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSetCompanyPrimayContacts <<<'

IF EXISTS (select * from sysobjects where name='AppSetCompanyPrimayContacts')
	drop procedure AppSetCompanyPrimayContacts
IF EXISTS (select * from GxQscripts where name='AppSetCompanyPrimayContacts')
	delete from GxQscripts where name = 'AppSetCompanyPrimayContacts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyPrimayContacts')
	delete from GXDBVersions where aliasname = 'AppSetCompanyPrimayContacts'
GO
print '... Creating Procedure: AppSetCompanyPrimayContacts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyPrimayContacts
  @o_xmlText XML,
  @tenantAdminGroupId INT, 
  @o_errCode INT OUTPUT,
  @o_errString NVARCHAR(max) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @localeId INT = 0
SET @localeId = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
DECLARE @tempUserInputTable TABLE (userIdPrimaryContact INT)
DECLARE @tempUsersToDelete TABLE (userIdPrimaryContact INT)
DECLARE @tempUsersToAdd TABLE (userIdPrimaryContact INT)
DECLARE @tempUserTable TABLE (userId INT)
DECLARE @primaryContactsOperationType INT
SET @primaryContactsOperationType =ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@primaryContactsOperationType)[1]', 'int'),2)--ADD
INSERT INTO @tempUserInputTable SELECT distinct ISNULL(ref.value('@userId', 'INT'),0) FROM @o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/primaryContacts/user') R ( ref )
IF(@primaryContactsOperationType = 3 )--delete
BEGIN
	INSERT INTO @tempUsersToDelete (userIdPrimaryContact)
	SELECT userIdPrimaryContact FROM @tempUserInputTable
END
ELSE IF(@primaryContactsOperationType = 2 OR @primaryContactsOperationType = 1 )--add, overwrite
BEGIN
	INSERT INTO @tempUsersToAdd (userIdPrimaryContact)
	SELECT userIdPrimaryContact FROM @tempUserInputTable
END
IF EXISTS (SELECT TOP 1 * FROM @tempUserInputTable) -- There Should be atleast 1 user for Edit
 BEGIN
	-- All users for provided Tenant Admin Group
	INSERT INTO @tempUserTable
	SELECT UUG.userId
	FROM UMUserGroup UUG  WITH (NOLOCK)
	WHERE UUG.groupId= @tenantAdminGroupId
	-- Check If any User Supposed to be Primary contact is not part of Tenant Admin Group
	IF EXISTS (SELECT t1.userIdPrimaryContact FROM @tempUsersToAdd t1 LEFT JOIN @tempUserTable t2 ON t1.userIdPrimaryContact=t2.userId WHERE t2.userId is NULL)
	BEGIN
		-- One of the Provided User is not part of Tenant Admin Group
SET @o_errCode = (3558 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3558 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO SCRIPT_EXIT
	END
	IF(@primaryContactsOperationType = 1 )--overwrite
	BEGIN
		INSERT INTO @tempUsersToDelete (userIdPrimaryContact)
		SELECT userId FROM @tempUserTable
	END
	-- First Remove the Primary Contact mapping for users which are not in the provided list
	UPDATE UMUsersProp SET attrVal=0 WHERE attrName='Primary Contact' AND componentNameId IN
																	(SELECT userIdPrimaryContact FROM @tempUsersToDelete)
	-- Now Set this value for Users which doesn't have primary contact value set
	MERGE UMUsersProp AS UPROP
	USING(SELECT userIdPrimaryContact FROM @tempUsersToAdd) AS U(userId)
	ON (UPROP.componentNameId = U.userId AND UPROP.attrType = 7 AND UPROP.attrName = 'Primary Contact')
	WHEN MATCHED THEN
		UPDATE SET UPROP.attrVal = 1
	WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES(U.userId, 'Primary Contact', 7, 1, dbo.GetUnixTime (GetUTCdate()), 0);
END
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyPrimayContacts')
	delete from GxQscripts where name = 'AppSetCompanyPrimayContacts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyPrimayContacts')
	delete from GXDBVersions where aliasname = 'AppSetCompanyPrimayContacts'
GO

insert into GXDBVersions values(2, 'AppSetCompanyPrimayContacts',  '00010001000200010000', 'AppSetCompanyPrimayContacts', '00010001000200010000')
GO

