

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyPlans.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyPlans.sp,v $ $Id: AppSetCompanyPlans.sp,v 1.1.2.14 2020/12/21 15:57:32 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetCompanyPlans')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyPlans <<<'
	drop procedure AppSetCompanyPlans
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyPlans')
	delete from GxQscripts where name = 'AppSetCompanyPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyPlans')
	delete from GXDBVersions where aliasname = 'AppSetCompanyPlans'
GO
print '... Creating Procedure: AppSetCompanyPlans'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetCompanyPlans
  @o_xmlText XML,
  @ownerCompany INT,
  @tenantAdminGroupId INT, 
  @o_errCode INT OUTPUT,
  @o_errString NVARCHAR(max) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--#tempCompanyPropTbl needs to be populate before call this.
DECLARE @i_providerId INT = -1
DECLARE @localeId INT = 0 --Default it to 0 for now
DECLARE @i_userId     		INTEGER
DECLARE @planDetailsOperationType INT
DECLARE @tempPlanInputTable TABLE (entityId INT)
DECLARE @tempPlansToDelete TABLE (RowID int not null identity(1,1) primary key,entityId INT)
DECLARE @tempPlansToAdd TABLE (entityId INT)
DECLARE @upatePlans int = 0 -- this will be used to check if there is any input to update
DECLARE @defaultPlansOperationType INT
DECLARE @tempDefaultPlanInputTable TABLE  (componentId int, propertyAttrName varchar(255), planId INT)
DECLARE @tempDefaultPlansToDelete TABLE (componentId int, propertyAttrName varchar(255), planId INT)
DECLARE @tempDefaultPlansToAdd TABLE (componentId int, propertyAttrName varchar(255), planId INT)
--Variables for 'Laptop Admins' group creation
DECLARE @newUserGrpId INT
DECLARE @userGrpDesc NVARCHAR(MAX)
DECLARE @ownerCompanyServiceType int = 0
DECLARE @roleId INT = 0
DECLARE @derivedPlanCreatorRoleId INT = 0
DECLARE @inputXML XML
DECLARE @errorTable TABLE (errorCode INT, errorString NVARCHAR(MAX))
SET  @i_providerId = @o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organization/shortName/@id)[1]', 'INT')
SET @i_userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                     FROM @o_xmlText.nodes ('Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo/user') R(ref)), 0)
SET @localeId = ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
SET @planDetailsOperationType =ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/@planDetailsOperationType)[1]', 'int'),2)--default to add.
SET @defaultPlansOperationType =ISNULL(@o_xmlText.value('(//Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/@defaultPlansOperationType)[1]', 'int'),2)
 SET @ownerCompanyServiceType = ISNULL((SELECT serviceType FROM UMDSProviders WHERE id=@ownerCompany),0)
-- Associated plans operation
INSERT INTO @tempPlanInputTable SELECT distinct ISNULL(ref.value('@planId', 'INT'),0) FROM @o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/planDetails/plan') R ( ref )
IF(@planDetailsOperationType = 3 )--delete
BEGIN
	INSERT INTO @tempPlansToDelete (entityId)
	SELECT entityId FROM @tempPlanInputTable
END
IF(@planDetailsOperationType = 2 OR @planDetailsOperationType = 1)--add OR ovewrite
BEGIN
	INSERT INTO @tempPlansToAdd (entityId)
	SELECT entityId FROM @tempPlanInputTable
END
IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
    DROP TABLE #getPlans
CREATE TABLE #getPlans
(
    planId INT
)
	IF(@planDetailsOperationType = 1)-- overwrite
	BEGIN
		IF(@ownerCompanyServiceType <> 1) -- if not cs try to find the tenant admin
		BEGIN
EXEC AppGetCompanyPlanList @ownerCompany,159,'#getPlans'
		END
		--Delete plan that are scheduled for delete
		DELETE T
		FROM #getPlans T
		INNER JOIN APP_PLAN P ON P.id = T.planId
WHERE P.flag & 0x40000000 = 0x40000000
		INSERT INTO @tempPlansToDelete
		SELECT planId from #getPlans A
		LEFT JOIN @tempPlanInputTable B on a.planId=B.entityId
		WHERE planid>0 AND b.entityId is null
		DELETE A
		FROM @tempPlansToAdd A
		INNER JOIN #getPlans B on A.entityId=B.planId
	END
		IF EXISTS (SELECT TOP 1 UU.id FROM UMUsers UU
				INNER JOIN UMUsersProp UUP WITH (NOLOCK)
					ON  UUP.componentNameId=UU.id AND UUP.modified = 0
				INNER JOIN UMDSProviders UD
					ON  UD.id=UU.umDSproviderId
WHERE (UUP.attrName='Associated Plan' and UUP.attrVal in (SELECT CAST(entityId AS NVARCHAR(10)) FROM @tempPlansToDelete))
AND ((UD.id=@i_providerId AND serviceType=5) OR (UD.ownerCompany=@i_providerId AND serviceType IN (2, 12))))
		OR
		EXISTS (SELECT TOP 1 UU.id FROM UMGroups UU
					INNER JOIN UMGroupsProp UUP WITH (NOLOCK)
						ON  UUP.componentNameId=UU.id AND UUP.modified = 0
				INNER JOIN UMDSProviders UD
					ON  UD.id=UU.umDSproviderId
WHERE (UUP.attrName='Associated Plan' and UUP.attrVal in (SELECT CAST(entityId AS NVARCHAR(10)) FROM @tempPlansToDelete))
AND ((UD.id=@i_providerId AND serviceType=5) OR (UD.ownerCompany=@i_providerId AND serviceType IN (2, 12))))
		BEGIN
			-- GOTO Error
			-- User Asked to remove one of the plan which is currently in use.
SET @o_errCode = (3560 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3560 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			GOTO SCRIPT_EXIT
		END
SET @roleId = (SELECT id FROM UMRoles WITH (NOLOCK) where flags & 64 <> 0 AND name='Plan Subscription Role')
		-- Below condition will come into picture only when we have atlease one plan to delete
	IF EXISTS (SELECT TOP 1 * FROM @tempPlansToDelete)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#deleteSecurity_UserGroupTbl') IS NOT NULL
            DROP TABLE #deleteSecurity_UserGroupTbl
		CREATE TABLE #deleteSecurity_UserGroupTbl (isUser int, userOrGroupId int)
		--Get all company users and user groups to remove plan from
		INSERT INTO #deleteSecurity_UserGroupTbl
			SELECT 1, id FROM UMUsers WHERE umDSproviderId=@ownerCompany OR umDSproviderId in (SELECT id FROM UMDSProviders WHERE ownerCompany=@ownerCompany)
		UNION
			SELECT 0, id from UMGroups WHERE umDSproviderId=@ownerCompany OR umDSproviderId in (SELECT id FROM UMDSProviders WHERE ownerCompany=@ownerCompany)
		DECLARE @i int
		SELECT @i = min(RowID) from @tempPlansToDelete
		DECLARE @max int
		SELECT @max = max(RowID) from @tempPlansToDelete
		DECLARE @pId int=0
		WHILE @i <= @max
		BEGIN
			SELECT @pId=entityId FROM @tempPlansToDelete WHERE RowID=@i
IF EXISTS(SELECT  1 FROM UMSecurityAssociations WHERE  entityType1=158 AND entityId1=@pId AND isCreator=1 AND companyId=@ownerCompany)
			BEGIN
				DECLARE @masterUserId INT = (Select dbo.getMasterGroupId())
				-- Tansfer ownership to master group, only if the plan is disassociated form its owner company
				DECLARE @transferOwnerXML xml = '<transferInfo>
				<transferOwnershipEntity entityType="158" entityId="' +  cast(@pId as varchar(10)) +'"/>
				<newUserGroup userGroupId="1"/>
				</transferInfo>'
				EXEC sec_transferUserOwnership  @transferOwnerXML,@masterUserId
			END
			--Now delete all the associations for given user and user groups
EXEC sec_deleteUserAndGroupSecurityOnEntity 158 , @pId
			SET @i = @i + 1
		END
	 END
	 -- Add more check here
	 -- company can get a plan which is owned by Commcell or actual company
	 DECLARE @planNotAllowed NVARCHAR(MAX)
	 DECLARE @planNotAllowedCount INT  = 0
	--SELECT @planNotAllowed = COALESCE(@planNotAllowed + ' ,', '') + AP.name, @planNotAllowedCount=@planNotAllowedCount + 1 FROM  @tempPlansToAdd TP
	SELECT @planNotAllowed = COALESCE(@planNotAllowed + ' ,', '') + AP.name, @planNotAllowedCount=SUM(COUNT(AP.name))  OVER() FROM  @tempPlansToAdd TP
	INNER JOIN APP_Plan AP
		ON AP.id=TP.entityId
	WHERE dbo.AppGetOrganizationForUser(AP.ownerId) NOT IN (0 /*Commcell company Id*/, @ownerCompany)
	GROUP BY AP.name
	IF @planNotAllowed IS NOT NULL
	BEGIN
		IF @planNotAllowedCount = 1
		BEGIN
			--Error Setting plan. Plan(s) '^1%s' is/are owned by another company.
SET @o_errCode = (3931 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
		ELSE
		BEGIN
			--Error Setting plan. Plans '^1%s' are owned by another companies.
SET @o_errCode = (3932 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		END
		SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errCode AND localeId = @localeId)
		SET @o_errString = REPLACE(@o_errString, '^1%s', @planNotAllowed)
        GOTO SCRIPT_EXIT
	END
	-- Below condition will come into picture only when we have atlease one plan to add
	IF EXISTS (SELECT 1 FROM @tempPlansToAdd WHERE entityId<>0 )
	BEGIN
		-- Map New Plans (which are not yet mapped) to the User Group - Tenant Admin Group
SET @derivedPlanCreatorRoleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'Derived Plan Creator Role'),0)
		SET @inputXML = (SELECT 2 AS '@associationsOperationType', -- Operation Type ADD AS 2
								(SELECT
									(SELECT
(SELECT 150 AS '@_type_', 158 AS '@entityType', t1.entityId as '@entityId' FROM @tempPlansToAdd t1 FOR XML PATH('entity'),TYPE)
									FOR XML PATH('entities'),TYPE),
									(SELECT
										(SELECT @roleId AS '@roleId' FOR XML PATH('role'),TYPE),
										(SELECT @derivedPlanCreatorRoleId AS '@roleId' FOR XML PATH('role'),TYPE)
									FOR XML PATH('properties'),TYPE)
								FOR XML PATH('associations'),TYPE),
							(SELECT
									(SELECT
(SELECT 150 AS '@_type_', 158 AS '@entityType', t1.entityId as '@entityId' FROM @tempPlansToAdd t1 FOR XML PATH('entity'),TYPE)
									FOR XML PATH('entities'),TYPE),
									(SELECT
(SELECT 107 AS '@categoryId', 31 AS '@permissionId' FOR XML PATH('permissions'),TYPE),
(SELECT 118 AS '@categoryId', 159 AS '@permissionId' FOR XML PATH('permissions'),TYPE)
									FOR XML PATH('properties'),TYPE)
								FOR XML PATH('associations'),TYPE)
							FOR XML PATH('App_SecurityAssociationForUserOrGroupList'),TYPE)
		DELETE FROM @errorTable
		INSERT INTO @errorTable EXEC sec_setSecurityAssociationsFromUserOrUserGroup @inputXML, @i_userId, 0, @tenantAdminGroupId, 0
		SET @o_errCode = ISNULL( (SELECT TOP 1 errorCode FROM @errorTable),0)
		SET @o_errString =ISNULL((SELECT TOP 1 errorString FROM @errorTable),'')
		IF @o_errCode <>0
			GOTO SCRIPT_EXIT
		-- When first laptop plan is associated to a company then create a "Laptop Admins" blacklisted group for the company
		-- Or already a user group was marked blacklisted in the company then do not create another user group
		IF EXISTS(
			SELECT TOP 1 *
				FROM @tempPlansToAdd TPA
				INNER JOIN App_Plan AP WITH(NOLOCK)
					ON TPA.entityId = AP.id
					WHERE TPA.entityId <> 0
AND AP.subType = 33554439
			) AND NOT EXISTS(
SELECT 1 FROM UMGroups WITH(NOLOCK) WHERE (groupFlags & CAST(0x20000 as integer)) > 0 AND umdsProviderId = @i_providerId
			)
		BEGIN
SET @userGrpDesc = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3711 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId)
VALUES ((1 | CAST(0x20000 AS INTEGER)), 0, 0, 1, 'Laptop Admins', @userGrpDesc, 2, NEWID(), @i_providerId)
		END
	END
	-- verify if the plan association is removed which was a default plan. We need to remove it as default plan if the assocation of a plan was removed.
IF(@ownerCompanyServiceType <>1)
	BEGIN
		DELETE c
		FROM App_CompanyProp C
		INNER JOIN @tempPlansToDelete T ON C.attrVal = CAST(T.entityId AS NVARCHAR(10))
		WHERE attrName IN
('Default Server Plan','Default Laptop Plan','Default File System Plan' , 'Default DB Plan', 'Default Virtual Server Backup Plan','Default Virtual Server Replication Plan')
	END
--default plans
INSERT INTO @tempDefaultPlanInputTable (componentId, planId)
SELECT distinct @ownerCompany , ISNULL(ref.value('@planId', 'INT'),0)
FROM
@o_xmlText.nodes('Api_UpdateOrganizationPropertiesRequest/organizationInfo/organizationProperties/defaultPlans/plan') R ( ref )
SET @upatePlans = @@ROWCOUNT
	UPDATE t SET propertyAttrName= CASE subtype
WHEN 33554437 THEN 'Default Server Plan'
WHEN 33554439 THEN 'Default Laptop Plan'
WHEN 50331655 THEN 'Default File System Plan'
WHEN 33579013 THEN 'Default DB Plan'
WHEN 83886085 THEN 'Default Virtual Server Backup Plan'
WHEN 83918853 THEN 'Default Virtual Server Replication Plan'
				END
	FROM @tempDefaultPlanInputTable T
	INNER JOIN APP_plan P ON p.id = T.planId and P.modified=0
	IF(@defaultPlansOperationType = 3 )--delete
	BEGIN
		INSERT INTO @tempDefaultPlansToDelete (componentId, propertyAttrName, planId)
		SELECT componentId, propertyAttrName, planId FROM @tempDefaultPlanInputTable
	END
	IF(@defaultPlansOperationType = 2 OR @defaultPlansOperationType = 1 )--add, overwrite
	BEGIN
		INSERT INTO @tempDefaultPlansToAdd (componentId, propertyAttrName, planId)
		SELECT componentId, propertyAttrName, planId FROM @tempDefaultPlanInputTable
	END
	IF(@defaultPlansOperationType = 1 )--get existing plans
	BEGIN
		INSERT INTO @tempDefaultPlansToDelete (componentId, propertyAttrName, planId)
		SELECT componentNameId, attrName,attrValInt FROM App_CompanyProp
WHERE attrName in ('Default Server Plan','Default Laptop Plan','Default File System Plan','Default DB Plan','Default Virtual Server Backup Plan','Default Virtual Server Replication Plan')
		AND modified=0
		AND componentNameId=@ownerCompany
	END
	--First get the associated plans to check if the plan can be set as default plan
IF((@ownerCompanyServiceType <> 1) AND (@defaultPlansOperationType = 1 OR @defaultPlansOperationType=2))
	BEGIN
		DELETE FROM #getPlans --Reusing the table so make sure it has no entries.
		IF(@ownerCompanyServiceType <> 1) -- if not cs try to find the tenant admin
		BEGIN
EXEC AppGetCompanyPlanList @ownerCompany,159,'#getPlans'
		END
		IF EXISTS (SELECT TOP 1 1 FROM @tempDefaultPlansToAdd  dp LEFT JOIN #getPlans ap on dp.planId = ap.planId WHERE ap.planId IS NULL)
		BEGIN
SET @o_errCode = (3559 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3559 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			GOTO SCRIPT_EXIT
		END
	END
	DELETE c
	FROM App_CompanyProp c
	INNER JOIN @tempDefaultPlansToDelete t ON c.componentNameId = t.componentId AND c.attrName = t.propertyAttrName AND cs_attrName=checksum(t.propertyAttrName)
	WHERE c.componentNameId=@ownerCompany and modified=0
	MERGE App_CompanyProp AS T
	USING @tempDefaultPlansToAdd AS S
	ON  T.attrName = S.propertyAttrName and t.componentNameId=S.componentId  and T.attrVal = CAST(S.planId as nvarchar(max)) AND modified=0 AND cs_attrName=checksum(S.propertyAttrName)
	WHEN NOT MATCHED THEN
	INSERT (componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (s.componentId, S.propertyAttrName, 7, s.planId,  dbo.GetUnixTime(GetUTCDate()), 0);
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyPlans')
	delete from GxQscripts where name = 'AppSetCompanyPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyPlans')
	delete from GXDBVersions where aliasname = 'AppSetCompanyPlans'
GO

insert into GXDBVersions values(2, 'AppSetCompanyPlans',  '00010001000200140000', 'AppSetCompanyPlans', '00010001000200140000')
GO

