

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyInitialProperties.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyInitialProperties()
--  | Description:  This procedure will be used while creating a company. This will set the properties for a company
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyInitialProperties.sp,v $ $Id: AppSetCompanyInitialProperties.sp,v 1.1.2.35.14.1 2021/03/05 00:45:13 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppSetCompanyInitialProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyInitialProperties <<<'
	drop procedure AppSetCompanyInitialProperties
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyInitialProperties')
	delete from GxQscripts where name = 'AppSetCompanyInitialProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyInitialProperties')
	delete from GXDBVersions where aliasname = 'AppSetCompanyInitialProperties'
GO
print '... Creating Procedure: AppSetCompanyInitialProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppSetCompanyInitialProperties
  @i_companyId INTEGER,
  @i_companyProperties XML,
  @i_localeId INTEGER,
  @i_userId INTEGER
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(1024) =''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @companyName NVARCHAR(255) = (SELECT hostName FROM UMDSProviders WHERE ID = @i_companyId )
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @webconsoleClients  table(clientId int)
	--Insert Creation Time for the company in app_companyprop table
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Creation Time', 7, @nowTime, @nowTime, 0)
    DECLARE @authCodeEnabled INT = 0
    SET @authCodeEnabled = ISNULL((select ref.value('@enableAuthCodeGen','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref)),0)
IF NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'Enable Auth Code Generation'  AND modified = 0 )
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Enable Auth Code Generation', 7, @authCodeEnabled, @nowTime, 0)
	END
IF NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'API Quota Limit'  AND modified = 0 )
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'API Quota Limit', 7, 0, @nowTime, 0)
	END
IF NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'API Quota Time Frame'  AND modified = 0 )
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'API Quota Time Frame', 7, 0, @nowTime, 0)
	END
	-- During Company creation enable TFA if its enabled at Commcell Level.
	DECLARE @tfaCommcell INT = ISNULL((select Convert(int, value) from GxGlobalParam WITH (NOLOCK)
where Name = 'EnableTwoFactorAuthentication')
, 0)
	DECLARE @enableTFA INT = 0
    SET @enableTFA = ISNULL(
									(select ref.value('@enableTwoFactorAuthentication','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref)),
									 (CASE WHEN @tfaCommcell = 1 THEN 1 ELSE 0 END)
								)
IF NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'EnableTwoFactorAuthentication'  AND modified = 0 )
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'EnableTwoFactorAuthentication', 7, @enableTFA, @nowTime, 0)
	END
	DECLARE @setDefaultPlan INT = ISNULL((SELECT 1 FROM	GXGlobalParam WITH(NOLOCK) WHERE name=N'Set Default Plan Automatically' AND value=N'1'),0)
	--Domain and sub domain information, Plan information.
	--The plans will be save as default plans for the company. We will only set Server, Laptop, FS and DB plan as default plan if the user has given one of them.
	DECLARE @tempSetTable table(componentId int, propertyAttrName nvarchar(255), stringVal NVARCHAR(max), attrType INT)
		INSERT INTO @tempSetTable (componentId, propertyAttrName, stringVal, attrType)
    SELECT distinct @i_companyId , CA.propertyTypId, CA.Value, CA.attrtype
    FROM @i_companyProperties.nodes('Api_OrganizationInfo') R ( ref )
             	 OUTER APPLY ref.nodes('organizationProperties') S(ref2)
			 OUTER APPLY ref2.nodes('additionalDomains') T(ref3)
			  OUTER APPLY ref.nodes('planDetails') U(ref4)
			  	  OUTER APPLY ref4.nodes('plan') v(ref5)
	CROSS APPLY (
SELECT 'Primary Domain'  AS propertyTypId,  S.ref2.value('@primaryDomain','NVARCHAR(MAX)') AS Value, 1 AS attrType WHERE  S.ref2.value('@primaryDomain','NVARCHAR(MAX)') <> '' UNION ALL
SELECT 'Sub Domain' AS propertyTypId,  T.ref3.value('@val','NVARCHAR(MAX)') AS Value, 1 AS attrType UNION ALL
 SELECT case u.ref4.value('@subtype','NVARCHAR(MAX)')
WHEN 33554437 THEN 'Default Server Plan'
WHEN 33554439 THEN 'Default Laptop Plan'
WHEN 50331655 THEN 'Default File System Plan'
WHEN 33579013  THEN 'Default DB Plan'
END, v.ref5.value('@planId','NVARCHAR(MAX)') , 7 AS attrType
FROM app_plan WHERE id = v.ref5.value('@planId','NVARCHAR(MAX)') AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0) AND @setDefaultPlan=1
		  ) CA
	WHERE ca.Value is not null AND CA.propertyTypId IS NOT NULL
	--check for duplicate plan subtypes and remove them from the temp table. we will only save one plan as default company plan for a given subtype of a plan.
 ;WITH CTE
        AS
        (
            SELECT ROW_NUMBER() OVER ( PARTITION BY componentId,  propertyAttrName ORDER BY propertyAttrName DESC ) AS 'RowNumber'
FROM @tempSetTable T WHERE propertyAttrName IN ('Default Server Plan','Default Laptop Plan','Default File System Plan','Default DB Plan')
        )
      DELETE FROM cte
WHERE  RowNumber <> 1;
	--Check for duplicate domain or sub domain name
	DECLARE @DomainTbl TABLE (
                                DomainName NVARCHAR(MAX)
                             )
	INSERT INTO @DomainTbl
	SELECT S.Data from
	(SELECT attrVal FROM App_CompanyProp where attrName  in ('Sub Domain', 'Primary Domain') AND componentNameId<>@i_companyId) C
		CROSS APPLY dbo.SplitString(C.attrVal, ',') S
	IF EXISTS (SELECT 1 from  @DomainTbl WHERE DomainName IN (SELECT stringVal FROM @tempSetTable))
	BEGIN
SET @errCode = (3213 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3213 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
		GOTO EXIT_ERROR
	END
	DECLARE @SubDomainStr nvarchar(max)
	SET  @SubDomainStr=(SELECT STUFF(( SELECT ',' + stringVal
		FROM @tempSetTable where propertyAttrName='Sub Domain'
              FOR
                XML PATH('')
              ), 1, 1, '') AS domainList)
	--delete the rows for sub domain and now add the comma seperated strings for sub domains
	DELETE @tempSetTable where propertyAttrName='Sub Domain'
	IF(@SubDomainStr is not null)
	BEGIN
		INSERT INTO @tempSetTable
SELECT distinct @i_companyId ,'Sub Domain', @SubDomainStr,1
	END
	INSERT INTO App_CompanyProp (componentNameId,  attrName, attrType, attrVal, created, modified)
	SELECT @i_companyId, propertyAttrName, attrType, stringVal, @nowTime, 0
	FROM @tempSetTable
IF EXISTS (SELECT 1 FROM @tempSetTable where propertyAttrName in ('Primary Domain' , 'Sub Domain'))
	BEGIN
		INSERT INTO @webconsoleClients
		SELECT c.id
			FROM app_client c
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
		LEFT JOIN App_VMToPMMAp vm on vm.PMClientId=c.id WHERE VMClientId IS NULL
		UNION
		SELECT vm.VMClientId
		FROM app_client c
		INNER JOIN App_VMToPMMAp vm ON c.id=PMClientId
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
			INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			SELECT C.clientId, stringVal,'STRING', 'WebConsole\Customization',cast( @i_companyId as nvarchar), 1,0,3,0,0
			FROM @tempSetTable T , @webconsoleClients C
WHERE propertyAttrName in ('Primary Domain' ,  'Sub Domain')
			AND  NOT EXISTS (SELECT 1 FROM APP_AdvanceSettings A WHERE C.clientId = A.entityId AND A.keyName=T.stringVal AND type='STRING' AND A.relativePath='WebConsole\Customization')
			--now mark the keys hidden
			INSERT INTO APP_AdvanceSettingsEx(keyId  , details, hidden)
			SELECT id, '', 1 from APP_AdvanceSettings WHERE relativePath='WebConsole\Customization' AND value LIKE CAST(@i_companyId AS NVARCHAR(MAX))
            INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
            SELECT clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1
            FROM @webconsoleClients
	END
	-- Set salesforceCustomerId, contractId, quotaVMCount & quotaUserCount if set in the request
	DECLARE @salesforceCustomerId NVARCHAR(256) = (SELECT ref.value('@salesforceCustomerId','NVARCHAR(256)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @contractId NVARCHAR(256) = (SELECT ref.value('@contractId','NVARCHAR(256)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @quotaVMCount INT = (SELECT ref.value('@quotaVMCount','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @quotaUserCount INT = (SELECT ref.value('@quotaUserCount','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
IF (@salesforceCustomerId IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'Salesforce Customer Id'  AND modified = 0 AND cs_attrName=CHECKSUM('Salesforce Customer Id'))
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Salesforce Customer Id', 1, @salesforceCustomerId, @nowTime, 0)
	END
IF (@contractId IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'Contract Id'  AND modified = 0 AND cs_attrName=CHECKSUM('Contract Id'))
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Contract Id', 1, @contractId, @nowTime, 0)
	END
IF (@quotaVMCount IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'License Usage VM Count'  AND modified = 0 AND cs_attrName=CHECKSUM('License Usage VM Count'))
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'License Usage VM Count', 7, @quotaVMCount, @nowTime, 0)
	END
IF (@quotaUserCount IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'License Usage User Count'  AND modified = 0 AND cs_attrName=CHECKSUM('License Usage User Count'))
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'License Usage User Count', 7, @quotaUserCount, @nowTime, 0)
	END
	-- Set VorgName and Vorg GUID if set in the request
	DECLARE @vOrgName NVARCHAR(256) = (SELECT ref.value('@vOrgName','NVARCHAR(256)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @vOrgGUID NVARCHAR(128) = (SELECT ref.value('@vOrgGuid','NVARCHAR(128)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
IF (@vOrgName IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'vOrg Name'  AND modified = 0 AND cs_attrName=CHECKSUM('vOrg Name'))
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'vOrg Name', 1, @vOrgName, @nowTime, 0)
	END
IF (@vOrgGUID IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'vOrg Guid'  AND modified = 0 AND cs_attrName=CHECKSUM('vOrg Guid'))
	BEGIN
		INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'vOrg Guid', 1, @vOrgGUID, @nowTime, 0)
	END
	--------------------------------- START - Ediscovery Code----------------------------------------------------------------
	DECLARE @enableEDiscoveryForLaptopRequest INT = (select ref.value('@enableEDiscoveryForLaptop','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @enableEDiscoveryForO365Request INT = (select ref.value('@enableEDiscoveryForO365','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	-- Call code to setup Ediscovery for Company before processing company properties
	-- SP takes care of handling empty input
	-- No need to call below SP as this is company creation. No client exist at this time for this company
	-- Keeping below code which will need to be uncommented in case we support passing client id as part of company creation
	-- EXEC dbo.AppSetEDiscoveryForCompany @i_companyId, '', @i_companyProperties , @errorCode OUTPUT, @errorString OUTPUT
	--Setup actual DB values
IF (@enableEDiscoveryForLaptopRequest IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'Enable eDiscovery for Laptop'  AND modified = 0 AND cs_attrName=CHECKSUM('Enable eDiscovery for Laptop'))
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId,  'Enable eDiscovery for Laptop', 7, @enableEDiscoveryForLaptopRequest, @nowTime, 0)
	END
IF (@enableEDiscoveryForO365Request IS NOT NULL) AND NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'Enable eDiscovery for O365'  AND modified = 0 AND cs_attrName=CHECKSUM('Enable eDiscovery for O365'))
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId,  'Enable eDiscovery for O365', 7, @enableEDiscoveryForO365Request, @nowTime, 0)
	END
	--------------------------------- START - Ediscovery Code----------------------------------------------------------------
	-- If enableAutoDiscovery is set when creating company, we need to add the following additional setting to corresponding client group of the company
	DECLARE @enableAutoDiscovery INT = ISNULL((select ref.value('@enableAutoDiscovery','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref)),0)
	IF @enableAutoDiscovery <> 0
	BEGIN
DECLARE @clientGroupId INT = (SELECT CAST(attrVal AS INT) FROM App_CompanyProp WHERE componentNameId = @i_companyId AND attrName = 'Associated Smart Client Group' AND modified = 0 AND cs_attrName = CHECKSUM('Associated Smart Client Group'))
		IF @clientGroupId IS NOT NULL
		BEGIN
			DECLARE @tmpRecordTable TABLE (id INT)
			INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			OUTPUT Inserted.id INTO @tmpRecordTable
VALUES (@clientGroupId, 'nEnableAutoDetectApp', 'INTEGER', 'iDataAgent', '2', 1, 0, 28, 0, 0)
			INSERT INTO APP_AdvanceSettingsEx(keyId, details, hidden)
			SELECT TOP 1 id, '', 1 FROM @tmpRecordTable
		END
	END
Declare @emailDomains TABLE (emailDomain nvarchar(512))
INSERT INTO @emailDomains select distinct ref.value('@val','nvarchar(255)') from @i_companyProperties.nodes('Api_OrganizationInfo/organization/emailDomainNames') R (ref)
Delete from UMDSProviderProp where attrName='Email Domain' and componentNameId=@i_companyId
INSERT INTO UMDSProviderProp (componentNameId,attrName,attrType,attrVal,created,modified) select  @i_companyId,'Email Domain','1',emailDomain,@nowTime,0 from @emailDomains where emailDomain <> ''
-- Setting tenant operator role --
DECLARE @tenantOperatorRoleID INT = ISNULL((@i_companyProperties.value('(Api_OrganizationInfo/organizationProperties/operatorRole/@roleId)[1]', 'INT')), 0)
EXEC AppSetCompanyTenantOperatorRole @i_userId, @i_localeId, @i_companyId, 1/*Common::OperationType_ADD*/, @tenantOperatorRoleID, @errCode OUTPUT, @errString OUTPUT
IF @errCode <> 0
	GOTO EXIT_ERROR
-- Requirement: If a user is creating a company make him (or tenant admin group, if he is company user), as default tenant operator on the company created.
DECLARE @operatorsXML XML
DECLARE @creatorUserCompanyId INT = dbo.AppGetOrganizationForUser (@i_userId)
DECLARE @tenantAdminGroupIdOfCreator INT = 0
IF @creatorUserCompanyId > 0
BEGIN
	SELECT @tenantAdminGroupIdOfCreator = id
	FROM UMGroups (NOLOCK)
	WHERE
		umdsProviderId = @creatorUserCompanyId
AND groupFlags & 0x10000 <> 0			-- 0x10000
END
SET @operatorsXML = (SELECT
						(SELECT 2 AS '@operatorsOperationType',
							  (SELECT
									CASE WHEN @tenantAdminGroupIdOfCreator > 0 THEN
									(
										SELECT @tenantAdminGroupIdOfCreator AS '@userGroupId',
15 AS '@_type_'
										FOR XML PATH ('userGroup'), TYPE
									)
									ELSE
									(		-- If he is not company user, make himself as operator.
										SELECT @i_userId AS '@userId',
13 AS '@_type_'
										FOR XML PATH ('user'), TYPE
									)
									END
								FOR XML PATH ('operators'), TYPE),
							(SELECT @i_companyProperties.query('Api_OrganizationInfo/organizationProperties/operators')		-- there might be other operators specified in input req. Include them too.
							FOR XML PATH (''), TYPE)
						FOR XML PATH('organizationProperties'), TYPE)
					FOR XML PATH ('Api_OrganizationInfo'))
-- Setting operators --
EXEC sec_setCommvaultUserAsResellerForCompany @i_userId, @i_localeId, @operatorsXML, @i_companyId, @errCode OUTPUT, @errString OUTPUT
IF @errCode <> 0
	GOTO EXIT_ERROR
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
EXIT_ERROR:
	select @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyInitialProperties')
	delete from GxQscripts where name = 'AppSetCompanyInitialProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyInitialProperties')
	delete from GXDBVersions where aliasname = 'AppSetCompanyInitialProperties'
GO

insert into GXDBVersions values(2, 'AppSetCompanyInitialProperties',  'v1.1.2.35.14.1', 'AppSetCompanyInitialProperties', 'v1.1.2.35.14.1')
GO

