

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyGroupPermission.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyGroupPermission()
--  | Description:  This procedure will be used while creating a company. This will set the permission on company's smart client group
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppSetCompanyGroupPermission.sp,v $ $Id: AppSetCompanyGroupPermission.sp,v 1.1.2.11 2020/05/16 00:50:25 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyGroupPermission')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyGroupPermission <<<'
	drop procedure AppSetCompanyGroupPermission
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyGroupPermission')
	delete from GxQscripts where name = 'AppSetCompanyGroupPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyGroupPermission')
	delete from GXDBVersions where aliasname = 'AppSetCompanyGroupPermission'
GO
print '... Creating Procedure: AppSetCompanyGroupPermission'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyGroupPermission
  @i_companyId INTEGER,
  @i_companyName NVARCHAR(256),
  @i_localeId INTEGER
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(1024)= ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
DECLARE @CompanyGrpId NVARCHAR(64) = ISNULL((SELECT attrValInt FROM App_CompanyProp WHERE attrName='Associated Smart Client Group' AND componentNameId=@i_companyId AND modified=0 AND  cs_attrName = CHECKSUM('Associated Smart Client Group')),0)
DECLARE @TenantAdminGroupId int = ISNULL((SELECT id FROM umgroups WHERE umdsProviderId=@i_companyId AND groupFlags &  0x10000 = 0x10000),0)
DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)
	--Set flag for Tenant user group
DECLARE @TenantUsersGroupId int = ISNULL((SELECT id FROM umgroups WHERE umdsProviderId=@i_companyId AND name = 'Tenant Users'),0)
	UPDATE UMGroups
SET groupFlags = groupFlags | 1073741824
	WHERE id = @TenantUsersGroupId
	DECLARE @entityRequest NVARCHAR(MAX) = N''
	IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name='skipAutoSettingOwnerPermission' AND value='1')
	BEGIN
		SET @entityRequest = N'<App_SecurityAssociationForEntityList associationsOperationType="2">
								  <associations>
									<properties>
								  <role roleId="' + cast (@tenantAdminRoleId as nvarchar) +'">
									  </role>
									</properties>
								<userOrGroup userGroupId="' + cast (@TenantAdminGroupId as nvarchar) +'">
								</userOrGroup>
								  </associations>
								</App_SecurityAssociationForEntityList>'
	END
	ELSE
	BEGIN
		SET @entityRequest = N'<App_SecurityAssociationForEntityList associationsOperationType="2">
		  <associations>
			<properties>
		  <role roleId="' + cast (@tenantAdminRoleId as nvarchar) +'">
			  </role>
			</properties>
		<userOrGroup userGroupId="' + cast (@TenantAdminGroupId as nvarchar) +'">
		</userOrGroup>
		  </associations>
		  <ownerAssociations>
		<categoryPermission categoriesPermissionOperationType="1">
<categoriesPermissionList categoryName="Client"  categoryId="102"  _type_="121">
					</categoriesPermissionList>
				</categoryPermission>
		  </ownerAssociations>
		</App_SecurityAssociationForEntityList>'
	END
	IF @CompanyGrpId != 0
		BEGIN
		EXEC[dbo].[sec_setSecurityAssociationsFromEntity]
		@xmlIn = @entityRequest,
		@userId = @adminUserId,
		@isCmdLine = 1,
		@skipSecurityCheck = 1,
		@entityType1 = 28,--CLIENT_GROUP_ENTITY
		@entityId1 = @CompanyGrpId,
		@entityType2 = 0,
		@entityId2 = 0,
		@entityType3 = 0,
		@entityId3 = 0,
		@entityType4 = 0,
		@entityId4 = 0,
		@entityType5 = 0,
		@entityId5 = 0
--UPDATE APP_ClientGroup SET flag = (flag | 1073741824) WHERE id = @CompanyGrpId
	END
	ELSE
	BEGIN
SET @errCode = (3215 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3215 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
EXIT_ERROR:
	select @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyGroupPermission')
	delete from GxQscripts where name = 'AppSetCompanyGroupPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyGroupPermission')
	delete from GXDBVersions where aliasname = 'AppSetCompanyGroupPermission'
GO

insert into GXDBVersions values(2, 'AppSetCompanyGroupPermission',  '00010001000200110000', 'AppSetCompanyGroupPermission', '00010001000200110000')
GO

