

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppSetCompanyEmailCustomization.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 1/8/2018
-- Description:	To create update email customization for a company
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppSetCompanyEmailCustomization')
BEGIN
	print '>>> Drop Stored Procedure: AppSetCompanyEmailCustomization <<<'
	drop procedure AppSetCompanyEmailCustomization
END
IF EXISTS (select * from GxQscripts where name='AppSetCompanyEmailCustomization')
	delete from GxQscripts where name = 'AppSetCompanyEmailCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyEmailCustomization')
	delete from GXDBVersions where aliasname = 'AppSetCompanyEmailCustomization'
GO
print '... Creating Procedure: AppSetCompanyEmailCustomization'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppSetCompanyEmailCustomization
  @i_userId INT,
  @i_localeId INT,
  @i_providerId INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @canManageProvider INT
DECLARE @nowTime   integer
SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
DECLARE @ownerCompany INT = 0
DECLARE @o_errCode integer=0
DECLARE @o_errString nvarchar(max)=''
SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
EXEC sec_checkPermissionOnEntity @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
IF @canManageProvider = 1
BEGIN
	DECLARE @newHeaderTemplate nvarchar(max)
	SET  @newHeaderTemplate = @o_xmlText.value('(//Api_OrganizationEmailTemplateSettings/@headerTemplate)[1]', 'nvarchar(max)')
	IF(@newHeaderTemplate is not null)
	BEGIN
		DECLARE @oldHeaderTemplate nvarchar(max)
SET @oldHeaderTemplate = (SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany AND attrName =  'Header Template'   AND modified=0)
		IF(@oldHeaderTemplate is null)
		BEGIN
			INSERT INTO App_CompanyProp(componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (@ownerCompany,'Header Template' , 1, @newHeaderTemplate,  dbo.GetUnixTime(GetUTCDate()), 0);
		END
		ELSE IF (@oldHeaderTemplate <> @newHeaderTemplate)
		BEGIN
UPDATE App_CompanyProp SET attrVal=@newHeaderTemplate WHERE componentNameId=@ownerCompany AND attrName =  'Header Template' AND modified=0
		END
	END
	DECLARE @newFooterTemplate nvarchar(max)
	SET  @newFooterTemplate = @o_xmlText.value('(//Api_OrganizationEmailTemplateSettings/@footerTemplate)[1]', 'nvarchar(max)')
	IF(@newFooterTemplate is not null)
	BEGIN
		DECLARE @oldFooterTemplate nvarchar(max)
SET @oldFooterTemplate = (SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany AND attrName =  'Footer Template'   AND modified=0)
		IF(@oldFooterTemplate is null)
		BEGIN
			INSERT INTO App_CompanyProp(componentNameId,  attrName, attrType, attrVal, created, modified)
VALUES (@ownerCompany,'Footer Template' , 1, @newFooterTemplate,  dbo.GetUnixTime(GetUTCDate()), 0);
		END
		ELSE IF (@oldFooterTemplate <> @newFooterTemplate)
		BEGIN
UPDATE App_CompanyProp SET attrVal=@newFooterTemplate WHERE componentNameId=@ownerCompany AND attrName =  'Footer Template' AND modified=0
		END
	END
END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO SCRIPT_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), TYPE)
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSetCompanyEmailCustomization')
	delete from GxQscripts where name = 'AppSetCompanyEmailCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSetCompanyEmailCustomization')
	delete from GXDBVersions where aliasname = 'AppSetCompanyEmailCustomization'
GO

insert into GXDBVersions values(2, 'AppSetCompanyEmailCustomization',  '00000000000000000000', 'AppSetCompanyEmailCustomization', '00000000000000000000')
GO

